% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6causal.R
\name{SCM}
\alias{SCM}
\title{R6 Class for structural causal models}
\description{
R6 Class for structural causal models

R6 Class for structural causal models
}
\details{
An R6 class for structural causal models (SCM)
with latent variables and missing data mechanism. There are methods for
defining, printing, plotting, intervening and simulating SCMs.
}
\examples{

## ------------------------------------------------
## Method `SCM$new`
## ------------------------------------------------

backdoor <- SCM$new("backdoor",
 uflist = list(
  uz = function(n) {return(stats::runif(n))},
  ux = function(n) {return(stats::runif(n))},
  uy = function(n) {return(stats::runif(n))}
 ),
 vflist = list(
  z = function(uz) {
    return(as.numeric(uz < 0.4))},
  x = function(ux, z) {
    return(as.numeric(ux < 0.2 + 0.5*z))},
  y = function(uy, z, x) {
    return(as.numeric(uy < 0.1 + 0.4*z + 0.4*x))}
 )
)

## ------------------------------------------------
## Method `SCM$print`
## ------------------------------------------------

backdoor

## ------------------------------------------------
## Method `SCM$plot`
## ------------------------------------------------

backdoor$plot()
backdoor$plot("v")

## ------------------------------------------------
## Method `SCM$intervene`
## ------------------------------------------------

# A simple intervention
backdoor_x1 <- backdoor$clone()  # making a copy
backdoor_x1$intervene("x",1) # applying the intervention
backdoor_x1$plot() # to see that arrows incoming to x are cut

# An intervention that redefines a structural equation
backdoor_yz <- backdoor$clone()  # making a copy
backdoor_yz$intervene("y",
    function(uy, z) {return(as.numeric(uy < 0.1 + 0.8*z ))}) # making y a function of z only
backdoor_yz$plot() # to see that arrow x -> y is cut

## ------------------------------------------------
## Method `SCM$simulate`
## ------------------------------------------------

backdoor$simulate(10)
backdoor$simdata

## ------------------------------------------------
## Method `SCM$dosearch`
## ------------------------------------------------

backdoor$dosearch(data = "p(x,y,z)", query = "p(y|do(x))")
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{vflist}}{List of the structural functions of observed variables.}

\item{\code{vfsymb}}{List of the names of observed variables.}

\item{\code{simdata}}{Data table containing data simulated from the SCM.}

\item{\code{simdata_md}}{Data table containing data simulated from the SCM
where missing values are indicated by \code{NA}.}

\item{\code{igraph}}{The graph of the SCM in the \code{igraph} form
(without the missing data mechanism).}

\item{\code{igraph_bidirected}}{The graph of the SCM in the \code{igraph} form where
latent variables are presented by bidirected arcs.}

\item{\code{igraph_md}}{The graph of the SCM in the \code{igraph} form including
the missing data mechanism.}

\item{\code{toporder}}{A vector giving the topological order of variables.}

\item{\code{toporderv}}{A vector giving the topological order of observed
variables.}

\item{\code{graphtext}}{A character string that gives the edges of the graph
of the SCM (without the missing data mechanism).}

\item{\code{graphtext_md}}{A character string that gives the edges of the graph
of the SCM including the missing data mechanism.}

\item{\code{name}}{The name of the SCM.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SCM$new()}}
\item \href{#method-print}{\code{SCM$print()}}
\item \href{#method-plot}{\code{SCM$plot()}}
\item \href{#method-intervene}{\code{SCM$intervene()}}
\item \href{#method-simulate}{\code{SCM$simulate()}}
\item \href{#method-causal.effect}{\code{SCM$causal.effect()}}
\item \href{#method-dosearch}{\code{SCM$dosearch()}}
\item \href{#method-clone}{\code{SCM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$new(
  name,
  uflist,
  vflist,
  rflist = NULL,
  rprefix = "R_",
  starsuffix = "_md"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name.}

\item{\code{uflist}}{A named list containing the functions for latent variables.}

\item{\code{vflist}}{A named list containing the functions for observed variables.}

\item{\code{rflist}}{A named list containing the functions for missingness indicators.}

\item{\code{rprefix}}{The prefix of the missingness indicators.}

\item{\code{starsuffix}}{The suffix for variables with missing data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `SCM` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor <- SCM$new("backdoor",
 uflist = list(
  uz = function(n) {return(stats::runif(n))},
  ux = function(n) {return(stats::runif(n))},
  uy = function(n) {return(stats::runif(n))}
 ),
 vflist = list(
  z = function(uz) {
    return(as.numeric(uz < 0.4))},
  x = function(ux, z) {
    return(as.numeric(ux < 0.2 + 0.5*z))},
  y = function(uy, z, x) {
    return(as.numeric(uy < 0.1 + 0.4*z + 0.4*x))}
 )
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print a summmary of the SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the DAG of the SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$plot(subset = "uvr", method = "igraph", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subset}}{Variable groups to be plotted: "uvr","vr","uv", or "v".}

\item{\code{method}}{Plotting method: "qgraph" or "igraph".}

\item{\code{...}}{other parameters passed to the plotting method}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor$plot()
backdoor$plot("v")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intervene"></a>}}
\if{latex}{\out{\hypertarget{method-intervene}{}}}
\subsection{Method \code{intervene()}}{
Apply an intervention to the SCM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$intervene(target, ifunction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target}}{Name(s) of the variables in vflist to be intervened.}

\item{\code{ifunction}}{Either numeric value(s) or new structural function(s) for the target variables.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# A simple intervention
backdoor_x1 <- backdoor$clone()  # making a copy
backdoor_x1$intervene("x",1) # applying the intervention
backdoor_x1$plot() # to see that arrows incoming to x are cut

# An intervention that redefines a structural equation
backdoor_yz <- backdoor$clone()  # making a copy
backdoor_yz$intervene("y",
    function(uy, z) {return(as.numeric(uy < 0.1 + 0.8*z ))}) # making y a function of z only
backdoor_yz$plot() # to see that arrow x -> y is cut
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-simulate"></a>}}
\if{latex}{\out{\hypertarget{method-simulate}{}}}
\subsection{Method \code{simulate()}}{
Simulate data from the SCM object.
Creates or updates \code{simdata}.
If \code{no_missing_data = FALSE}, creates or updates also \code{simdata_md}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$simulate(n = 1, no_missing_data = FALSE, fixedvars = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of observations to be generated.}

\item{\code{no_missing_data}}{Logical, should the generation of missing data skipped? (defaults FALSE).}

\item{\code{fixedvars}}{List of variables that remain unchanged.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor$simulate(10)
backdoor$simdata
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-causal.effect"></a>}}
\if{latex}{\out{\hypertarget{method-causal.effect}{}}}
\subsection{Method \code{causal.effect()}}{
Is a causal effect identifiable from observational data?
Calls the implementation of ID algorithm from package \pkg{causaleffect}.
See the documentation of \code{\link[causaleffect]{causal.effect}} for the details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$causal.effect(y, x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{A vector of character strings specifying target variable(s).}

\item{\code{x}}{A vector of character strings specifying intervention variable(s).}

\item{\code{...}}{Other parameters passed to \code{\link[causaleffect]{causal.effect}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An expression for the joint distribution of the set of variables (y) given
the intervention on the set of variables (x) conditional on (z) if the effect is
 identifiable. Otherwise an error is thrown describing the graphical structure
 that witnesses non-identifiability.
 @examples
 backdoor$causal.effect(y = "y", x = "x")
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dosearch"></a>}}
\if{latex}{\out{\hypertarget{method-dosearch}{}}}
\subsection{Method \code{dosearch()}}{
Is a causal effect or other query identifiable from given data sources?
Calls \code{\link[dosearch]{dosearch}} from the package \pkg{dosearch}.
See the documentation of dosearch for the details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$dosearch(
  data,
  query,
  transportability = NULL,
  selection_bias = NULL,
  missing_data = NULL,
  control = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Character string specifying the data sources.}

\item{\code{query}}{Character string specifying the query of interest.}

\item{\code{transportability}}{Other parameters passed to \code{dosearch()}.}

\item{\code{selection_bias}}{Other parameters passed to \code{dosearch()}.}

\item{\code{missing_data}}{Other parameters passed to \code{dosearch()}.}

\item{\code{control}}{List of control parameters passed to \code{dosearch()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{dosearch}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{backdoor$dosearch(data = "p(x,y,z)", query = "p(y|do(x))")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SCM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
