% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6causal.R
\name{run_experiment}
\alias{run_experiment}
\title{Conduct a sequence of interventions and collect the simulated data.}
\usage{
run_experiment(SCM, intervene, response, n)
}
\arguments{
\item{SCM}{An SCM object}

\item{intervene}{A list where the names of the elements are the variables to be
intervened and the values of the elements are vectors specifying the values set
in the intervention}

\item{response}{A vector of the names of the response variables}

\item{n}{Size of the data to be simulated for each intervention}
}
\value{
A list containing the values of the response variables for all intervention combinations
}
\description{
Conduct a sequence of interventions and collect the simulated data.
}
\examples{
backdoor_experiment <- run_experiment(backdoor,
                                     intervene = list(x = c(0,1)),
                                     response = "y",
                                     n = 10000)
colMeans(backdoor_experiment$response_list$y)
}
