% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBCD_GAUSSIAN_raw.R
\name{DBCD_GAUSSIAN_raw}
\alias{DBCD_GAUSSIAN_raw}
\title{Doubly Adaptive Biased Coin Design (Gaussian Responses)}
\usage{
DBCD_GAUSSIAN_raw(X.df, group_allo, rho_func_index, rho_func, alpha)
}
\arguments{
\item{X.df}{A data frame of two columns: treatment arm and response value.
treatment arm.}

\item{group_allo}{An integer of the size of group allocation. The default is
1.}

\item{rho_func_index}{Supply a number of 1, 2 or 3 indicting the
allocation function to use.
1 = Zhang-Rosenberger allocation;
2 = Neyman allocation.
The default is 2.}

\item{rho_func}{Supply a user-specified allocation function of Mean_RK and
SD_RK when rho_func_index is NULL. Default is NULL.}

\item{alpha}{Supply a number indicating the subscripts of the probability
function. The default is 2.}
}
\value{
Number of the arm that the next subject is assigned to.
}
\description{
Allocates patients to one of treatments based on doubly adaptive
biased coin design on summarized data.
}
\details{
'DBCD_GAUSSIAN' assigns the next subject to a group given the observed
success rates, enrolled subjects and allocation function.
}
\examples{
X.df = data.frame(
ARM = sample(LETTERS[1:2],50,replace = TRUE),
RESPONSE = rnorm(50)
)

DBCD_GAUSSIAN_raw(X.df)

}
