% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_boto}
\alias{install_boto}
\title{Install Amazon SDK boto3 for Athena connection}
\usage{
install_boto(
  method = c("auto", "virtualenv", "conda"),
  conda = "auto",
  envname = "RAthena",
  conda_python_version = "3.7",
  ...
)
}
\arguments{
\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows. Note also that since this command runs without privilege
the "system" method is available only on Windows.}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow \code{reticulate} to
automatically find an appropriate \code{conda} binary. See \strong{Finding Conda} for more details.}

\item{envname}{Name of Python environment to install within, by default environment name RAthena.}

\item{conda_python_version}{the python version installed in the created conda
environment. Python 3.7 is installed by default.}

\item{...}{other arguments passed to [reticulate::conda_install()] or
[reticulate::virtualenv_install()].}
}
\value{
Returns \code{NULL} after installing \code{Python} \code{Boto3}.
}
\description{
Install Amazon SDK boto3 for Athena connection
}
\note{
[reticulate::use_python] or [reticulate::use_condaenv] might be required before connecting to Athena.
}
