% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{chem_shift_corr}
\alias{chem_shift_corr}
\title{Chemical shift correlation between any two atoms from a single residue}
\usage{
chem_shift_corr(atom1, atom2, res = NA, type = "c", interactive = TRUE)
}
\arguments{
\item{atom1}{atom name in NMR-STAR nomenclature like CA,CB2}

\item{atom2}{atom name in NMR_STAR nomenclature like HA,HB2}

\item{res}{residue name like ALA,GLY (optional by default includes all possible amino acids)}

\item{type}{'c' for contour plot and 's' for scatter plot default 'c'.scatter plot will be slow and heavy for large data set}

\item{interactive}{TRUE/FALSE default=TRUE}
}
\value{
plot object
}
\description{
Plots the correlated chemical shift distribution of any two atoms in a single residue for the 20 standard amino acids from BMRB database.
By default it will generate interactive graphics using plotly library
}
\examples{
#plt<-chem_shift_corr('HE21','HE22')
#plots the chemical shift distribution between HE21 and HE22
}
\seealso{
\code{\link{fetch_atom_chemical_shifts}} and \code{\link{atom_chem_shift_corr}}
}
