% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_parameter_VAR.R
\name{toString.parameter_VAR}
\alias{toString.parameter_VAR}
\title{parameter_VAR to string}
\usage{
\method{toString}{parameter_VAR}(x, ...)
}
\arguments{
\item{x}{parameter_VAR object, object to be converted.}

\item{...}{Optional arguments.}
}
\value{
A string ready to be printed or written.
}
\description{
Convert an object of class 'parameter_VAR' into a ready-to-write vector of string
}
\examples{
X=data.frame(input1=rnorm(100),input2=rnorm(100))
Y=data.frame(output=X$input1+0.8*X$input2+0.1*rnorm(100))
VAR.indx=data.frame(indx=c(rep(1,50),rep(2,50)))
workspace=tempdir()
d <- dataset(X=X,Y=Y,data.dir=workspace,VAR.indx=VAR.indx)
p <- parameter_VAR(name='par',index='indx',d=d,
                   init=c(-1,1,2),
                   prior.dist=c('Gaussian','FlatPrior','Triangle'),
                   prior.par=list(c(-1,1),NULL,c(2,0,5)))
toString(p)
}
