% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est.R
\name{mn.regu.cv}
\alias{mn.regu.cv}
\title{Model-assisted inference for population means based on cross validation}
\usage{
mn.regu.cv(fold, nrho = NULL, rho.seq = NULL, y, tr, x,
  ploss = "cal", yloss = "gaus", off = 0, ...)
}
\arguments{
\item{fold}{A vector of length 2 giving the fold numbers for cross validation in propensity score estimation and outcome regression respectively.}

\item{nrho}{A vector of length 2 giving the numbers of tuning parameters searched in cross validation.}

\item{rho.seq}{A list of two vectors giving the tuning parameters in propensity score estimation (first vector) and outcome regression (second vector).}

\item{y}{An \eqn{n} x \eqn{1} vector of outcomes with missing data.}

\item{tr}{An \eqn{n} x \eqn{1} vector of non-missing indicators (=1 if \code{y} is observed or 0 if \code{y} is missing).}

\item{x}{An \eqn{n} x \eqn{p} matix of covariates, used in both propensity score and outcome regression models.}

\item{ploss}{A loss function used in propensity score estimation (either "ml" or "cal").}

\item{yloss}{A loss function used in outcome regression (either "gaus" for continuous outcomes or "ml" for binary outcomes).}

\item{off}{An offset value (e.g., the true value in simulations) used to calculate the z-statistic from augmented IPW estimation.}

\item{...}{Additional arguments to \code{\link{glm.regu.cv}}.}
}
\value{
\item{ps}{A list containing the results from fitting the propensity score model by \code{\link{glm.regu.cv}}.}
\item{fp}{The \eqn{n} x \eqn{1} vector of fitted propensity scores.}
\item{or}{A list containing the results from fitting the outcome regression model by \code{\link{glm.regu.cv}}.}
\item{fo}{The \eqn{n} x \eqn{1} vector of fitted values from outcome regression.}
\item{est}{A list containing the results from augmented IPW estimation by \code{\link{mn.aipw}}.}
}
\description{
This function implements model-assisted inference for population means with missing data,
using regularized calibrated estimation based on cross validation.
}
\details{
Two steps are involved in this function: first fitting propensity score and outcome regression models and then applying the augmented IPW estimator 
for a population mean. For \code{ploss}="cal", regularized calibrated estimation is performed with cross validation as described in Tan (2017, 2019). 
The method then leads to model-assisted inference, in which confidence intervals are valid with high-dimensinoal data 
if the propensity score model is correctly specified but the outcome regression model may be misspecified.
With linear outcome models, the inference is also doubly robust.
For \code{ploss}="ml", regularized maximum likelihood estimation is used (Belloni et al. 2014; Farrell 2015). In this case, standard errors 
are only shown to be valid if both the propensity score model and the outcome regression model are correctly specified.
}
\examples{
\donttest{
data(simu.data)
n <- dim(simu.data)[1]
p <- dim(simu.data)[2]-2

y <- simu.data[,1]
tr <- simu.data[,2]
x <- simu.data[,2+1:p]
x <- scale(x)

# missing data
y[tr==0] <- NA

mn.cv.rcal <- mn.regu.cv(fold=5*c(1,1), nrho=(1+10)*c(1,1), rho.seq=NULL, y, tr, x, 
                         ploss="cal", yloss="gaus")
unlist(mn.cv.rcal$est)
}

}
\references{
Belloni, A., Chernozhukov, V., and Hansen, C. (2014) Inference on treatment effects after selection among high-dimensional controls,
\emph{Review of Economic Studies}, 81, 608-650.

Farrell, M.H. (2015) Robust inference on average treatment effects with possibly more covariates than observations, \emph{Journal of Econometrics}, 189, 1-23.

Tan, Z. (2017) Regularized calibrated estimation of propensity scores with model misspecification and high-dimensional data, arXiv:1710.08074. 

Tan, Z. (2019) Model-assisted inference for treatment effects using regularized calibrated estimation with high-dimensional data, 
\emph{Annals of Statistics}, to appear (preprint arXiv:1801.09817).
}
