% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeGlobalStat}
\alias{makeGlobalStat}
\title{Compute global statistic of a variable}
\usage{
makeGlobalStat(x, area = NULL, verbose = FALSE, FUN = weighted.mean, ...)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{area}{An area \code{\link{cmip5data}} object}

\item{verbose}{logical. Print info as we go?}

\item{FUN}{function. Function to apply across grid}

\item{...}{Other arguments passed on to \code{FUN}}
}
\value{
A \code{\link{cmip5data}} object, in which the \code{val} dimensions are the
same as the caller for Z (if present) and time, but lon and lat are reduced to
1 (i.e. no dimensionality). A \code{numCells} field is also added, recording the number
of cells in the spatial grid.
}
\description{
Calculates a global summary for CMIP5 data, usually weighted by the
grid cell areas used by each particular model. If no
area weighting is supplied, one is computed based on the lon/lat
values of \code{x}. The default statistic is \link{weighted.mean},
but any summary function that returns a numeric result can be used.
}
\details{
The stat function is calculated for all combinations of lon,
lat, and Z (if present).
This function is more complicated than the other makeXxxStat functions, because
it provides explicit support for area-weighted functions. We expect that
weighted.mean and a weighted sum will be the most frequent
calculations needed. The former is built into R, and the latter can generally
be calculated as weighted.mean * sum(area). A user-supplied stat function must
follow the weighted.mean syntax, in particular
accepting parameters 'x' (data) and 'w' (weights) of equal size, as well as dots(...).
}
\examples{
d <- cmip5data(1970:1975)   # sample data
makeGlobalStat(d)
summary(makeGlobalStat(d))
}
\seealso{
\code{\link{makeAnnualStat}} \code{\link{makeZStat}} \code{\link{makeMonthlyStat}}
}

