% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-forest.R
\name{plotForest}
\alias{plotForest}
\title{Plot forest plot from pathway/geneset/meta analysis results}
\usage{
plotForest(
  resultsList,
  yAxis = c("ID", "name"),
  statLims = c(-2.5, 2.5),
  useFDR = TRUE
)
}
\arguments{
\item{resultsList}{A named list of dataframes from pathway analysis, geneset analysis, and/or meta analysis results.
The columns are ID, name, description, p.value, pFDR, size, nDE, score and normalizedScore.}

\item{yAxis}{The column to use for the y-axis.}

\item{statLims}{A vector of length 2 specifying the limits for score to use in the x axis.}

\item{useFDR}{A boolean parameter to specify if adjusted p-value should be considered.}
}
\value{
A list of ggplot objects.
}
\description{
Plot forest plot from pathway/geneset/meta analysis results.
}
\examples{
\donttest{
library(RCPA)

affyFgseaResult <- loadData("affyFgseaResult")
agilFgseaResult <- loadData("agilFgseaResult")
RNASeqFgseaResult <- loadData("RNASeqFgseaResult")
metaPAResult <- loadData("metaPAResult")

PAResults <- list(
    "Affymetrix - GSE5281" = affyFgseaResult,
    "Agilent - GSE61196" = agilFgseaResult,
    "RNASeq - GSE153873" = RNASeqFgseaResult,
    "Meta-analysis" = metaPAResult
)

selectedPathways <- c("path:hsa05010", "path:hsa05012", "path:hsa05014", "path:hsa05016",
                      "path:hsa05017", "path:hsa05020", "path:hsa05022", "path:hsa04724",
                      "path:hsa04727", "path:hsa04725", "path:hsa04728", "path:hsa04726",
                      "path:hsa04720", "path:hsa04730", "path:hsa04723", "path:hsa04721",
                      "path:hsa04722")
resultsToPlot <- lapply(PAResults, function(df) df[df$ID \%in\% selectedPathways,])

RCPA::plotForest(resultsToPlot, yAxis = "name", statLims = c(-3.5, 3.5))

}
}
