% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{world}
\alias{world}
\title{World dataset for R Companion to Political Analysis, Third Edition}
\format{
A data frame with 169 rows and 206 variables.
\describe{
  \item{arda.code}{Country numerical code}
  \item{bribe.judge}{Prevalence of bribing judges}
  \item{bribe.police}{Prevalence of bribing police}
  \item{broadband}{Broadband subscription per 100 people}
  \item{business.starts}{Number of new corporations registered annually}
  \item{cabrv}{Three-letter abbreviation of country name}
  \item{carbon.footprint}{National carbon footprint}
  \item{ccode}{Numeric country code based on the ISO-3166-1 standard}
  \item{ciaedex}{Percent of GDP spent on education}
  \item{ciagdpag}{Composition of GDP: Agricultural sector}
  \item{ciagdpin}{Composition of GDP: Industrial sector}
  \item{ciagdpsv}{Composition of GDP: Service sector}
  \item{civil.war}{Civil war intensity}
  \item{co2.percap}{Carbon dioxide emissions per capita}
  \item{colony}{Colony of what country?}
  \item{compulsory.voting}{Does country require citizens to vote?}
  \item{confidence}{Confidence in institutions scale}
  \item{conflict.index}{Level of violent conflict in country}
  \item{conflict.internal}{Number of internal conflict without foreign invention}
  \item{conflict.internat}{Number of internal conflict with foreign invention}
  \item{corp.tax.rate}{Corporate tax rate}
  \item{corrupt.perception}{Corruption perception index}
  \item{country}{Country/territory name}
  \item{coup.attempts}{Number of attempted coups d'etat since 1950}
  \item{coups}{Number of successful coups d'etat since 1950}
  \item{covid.cases.permil}{Total COVID cases per million}
  \item{covid.deaths.per.million}{Total COVID deaths per million}
  \item{covid.response.max}{Maximum of COVID response stringency index}
  \item{covid.response.mean}{Mean of COVID response stringency index}
  \item{covid.vaccinated}{Percentage of population fully vaccinated against COVID}
  \item{death.penalty.status}{Legal status of death penalty}
  \item{debt.percent.gdp}{Public debt as a percentage of GDP}
  \item{dem.other}{Percentage of other democracies in region}
  \item{dem.other5}{Percentage of other democracies in region}
  \item{district.size3}{Average number of members per district}
  \item{dnpp.3}{Effective number of parliamentary parties}
  \item{dpi.cemo}{Is chief executive a military officer?}
  \item{dpi.system}{National political system}
  \item{durable}{Number of years since the last regime transition}
  \item{eco.footprint}{Total ecological footprint}
  \item{econ.compete}{Global economic competitiveness}
  \item{econ.freedom}{Rating of overall economic freedom}
  \item{econ.freedom.5cat}{Rating of overall economic freedom, 5 ordinal categories}
  \item{educ.f.avgyrs}{Average Schooling Years, Female}
  \item{educ.f.none}{Percentage of Females with No Schooling}
  \item{educ.m.avgyrs}{Average Schooling Years, Male}
  \item{educ.m.none}{Percentage of Males with No Schooling}
  \item{educ.quality}{Average rating of quality of educational system}
  \item{effectiveness}{Government effectiveness scale}
  \item{eiu.democ.4cat}{Level of democracy, 4 ordinal categories}
  \item{eiu.democ.bin}{Is country a democracy?}
  \item{eiu.democ.score}{Rating of democracy}
  \item{election.integrity}{Integrity of country's electoral system }
  \item{election.violence.post}{Were there riots and protest after election?}
  \item{election.violence.pre}{Were there riots and protest before election?}
  \item{energy.renew.percent}{Percentage of country's energy that is non-fossil fuel }
  \item{enpp3.democ}{Effective number of parliamentary parties}
  \item{enpp3.democ08}{Effective number of parliamentary parties}
  \item{enpp.3}{Effective number of parliamentary parties}
  \item{envir.treaty}{Number of environmental treaties agreed to}
  \item{eu}{EU member state}
  \item{fdi.inflow}{Inflow of foreign direct investment (in millions of US dollars)}
  \item{fertility}{Number children born per woman}
  \item{fh.democ.3cat}{Rating of democracy, 3 ordinal categories}
  \item{fh.democ.score}{Freedom House rating of democracy}
  \item{fh.internet.3cat}{Level of Internet freedom in country, 3 ordinal categories}
  \item{fh.internet.score}{Measure of Internet freedom}
  \item{frac.eth}{Ethnic factionalization}
  \item{frac.eth2}{Ethnic factionalization}
  \item{frac.eth3}{Ethnic factionalization}
  \item{frac.lang}{Language factionalization}
  \item{frac.relig}{Religious factionalization}
  \item{gas.production}{Gas production (in millions of barrels of oil equivalent)}
  \item{gdp.growth}{Annual economic growth rate}
  \item{gdp.percap}{Gross domestic product per capita (in U.S. dollars)}
  \item{gdp.percap.5cat}{Gross domestic product per person, 5 ordinal categories}
  \item{gender.equal3}{Gender empowerment}
  \item{gender.inequality}{Index of gender inequality}
  \item{gini.index}{GINI index (of income inequality)}
  \item{global.social}{Social globalization}
  \item{govt.help.cap}{Capacity of state to provide for needy citizens}
  \item{govt.integrity}{Rating of government integrity}
  \item{govt.per.gdp}{Government spending (all types) as a percentage of GDP}
  \item{govt.quality}{The quality of government}
  \item{gri}{Index of government restrictions on religion}
  \item{grp.name}{Name of government preferred religion}
  \item{grp.score}{Index of government religious preference}
  \item{happiness}{Average happiness in country}
  \item{hdi}{Human development index}
  \item{hiv.percent}{Percentage of population aged 15-49 with HIV}
  \item{homicide.rate}{Intentional homicides per 100,000 persons}
  \item{hospital.beds}{Number of hospital beds per thousand people}
  \item{human.flight}{Human flight and brain drain from country}
  \item{icc.treaty.ratified}{Has country ratified treaty for International Criminal Court?}
  \item{immigrants.percent}{Percentage of population born in another county}
  \item{imprisonment.rate}{Number incarcerated per 100,000 persons}
  \item{income.tax.rate}{Income tax rate}
  \item{indep.judiciary}{Does country have an independent judiciary?}
  \item{indy}{Year of independence}
  \item{infant.mortality}{Number infants dying before age one per 1,000 live births}
  \item{inflation}{Annual inflation rate}
  \item{internet.users}{Percentage of population that uses the Internet}
  \item{judicial.effectiveness}{Rating of effectiveness of country's judiciary}
  \item{judicial.indep.wef}{Average rating of judicial independence}
  \item{laws.protect.prop}{Legal protections for private property rights}
  \item{legal.origin}{Legal origin of commercial code of country}
  \item{legal.quality}{Measure of quality of country's legal institutions}
  \item{life.expectancy}{Life expectancy at birth}
  \item{lifeex.f}{Life expectancy at birth among females}
  \item{lifeex.m}{Life expectancy at birth among males}
  \item{literacy}{Literacy rate}
  \item{media.access.cand}{Does country provide free or subsidized media access for political candidates?}
  \item{media.access.parties}{Does country provide free or subsidized media access for political parties?}
  \item{median.age}{Median age in years}
  \item{migration.net}{Net migration}
  \item{muslim}{Are Muslims predominate religious group?}
  \item{ocean.health}{Measure of health of oceans adjacent to country}
  \item{oecd}{OECD member state?}
  \item{oil}{Oil production, in barrels per day}
  \item{oil.production}{Oil production, in metric tons}
  \item{organized.crime}{Impact of organized crime on the economy}
  \item{peace.5cat}{Peacefulness of country, 5 ordinal categories}
  \item{peace.index}{Peacefulness of country}
  \item{pmat12.3}{Post-materialism}
  \item{pol.terror.scale.ai}{Political terror scale}
  \item{pol.terror.scale.hrw}{Political terror scale}
  \item{polity.score}{Rating of democracy}
  \item{pop.0.14}{Percentage of population age 0-14}
  \item{pop.15.64}{Percentage of population age 15-64}
  \item{pop.65.older}{Percent of population age 65 and older}
  \item{pop.growth}{Percentage population growth/decline annually}
  \item{pop.urban}{Percentage of the population living in urban areas}
  \item{population}{Size of national population}
  \item{population.3cat}{Size of national population, 3 ordinal categories}
  \item{population.density}{Number of people per square kilometer}
  \item{poverty}{Percentage of the population below the poverty line}
  \item{pr.sys}{Proportional representation system?}
  \item{press.freedom.fh}{Freedom of the country's press}
  \item{press.freedom.rsf}{Freedom of the country's press}
  \item{protact3}{Protest activity}
  \item{refugees.from}{Refugees from the country who live in other countries}
  \item{refugees.impact}{Impact of population displacement on country}
  \item{refugees.in}{Refugees from other countries in the country}
  \item{regime.type3}{Regime type}
  \item{region}{Region name}
  \item{regionun}{United Nations region}
  \item{religion}{Largest religion by proportion}
  \item{reserved.seats}{Does country reserve seats in national legislature for any group?}
  \item{rights.assn}{Freedom of assembly and association}
  \item{rights.dommov}{Freedom of domestic movement}
  \item{rights.formov}{Freedom of foreign movement}
  \item{rights.injud}{Independence of the judiciary}
  \item{rights.law.index}{Measure of violations of human right and rule of law}
  \item{rights.relfree}{Freedom of Religion}
  \item{rights.speech}{Freedom of speech}
  \item{rights.treaties}{Number of international human rights treaties ratified}
  \item{rights.wecon}{Women's economic rights}
  \item{rights.wopol}{Women's political rights}
  \item{rights.worker}{Worker's rights}
  \item{schools.internet}{Average rating of internet availability in schools}
  \item{self.employed}{Percentage of labor force that is self-employed}
  \item{sexratio}{Sex ratio at birth}
  \item{shi}{Social hostility toward religion}
  \item{soldiers.percent}{Percentage of labor force in the military}
  \item{soldiers.total}{Total number of people in the military}
  \item{spendeduc}{Public expenditure on education as a percentage of GDP}
  \item{spendhealth}{Public expenditure on health as a percentage of GDP}
  \item{spendmil.wdi}{Public expenditure on the military as a percentage of GDP}
  \item{tariff.rate}{Tariff rate on imports}
  \item{taxes.percent.gdp}{Taxes (all forms) as a percentage of GDP}
  \item{terror.index.voh}{Impact of terrorism on the county}
  \item{trade.percent.gdp}{International trade as percentage of GDP}
  \item{typerel}{Predominant religion}
  \item{unemployment}{Percentage of labor force that is unemployed}
  \item{unexp.rd}{Public expenditure on research and development as a percentage of GDP}
  \item{unfempf}{Ratio of female to male formal employment rates}
  \item{unin.inc}{Inequality-adjusted income index}
  \item{unineduc}{Inequality-adjusted education index}
  \item{unions}{Union density}
  \item{unjourn}{Number of verified cases of journalists imprisoned}
  \item{unlit}{Adult literacy rate }
  \item{unmobcov}{Percentage covered by a mobile phone network}
  \item{unmort.f}{Number of adult female deaths per 1,000 females}
  \item{unmort.m}{Number of adult male deaths per 1,000 males}
  \item{unnewsp}{Daily newspapers per thousand people}
  \item{unnoncom}{Death rates from non-communicable diseases}
  \item{unpop30}{Projected 2030 population in millions}
  \item{unremitp}{Per capita remittance inflows in US dollars}
  \item{unremitt}{Remittance inflows as a percentage of GDP}
  \item{unsathlt}{Percentage satisfied with their personal health}
  \item{unsati}{Overall life satisfaction}
  \item{unsatif}{Overall life satisfaction among females}
  \item{unsatjob}{Percentage satisfied with their job}
  \item{unsatliv}{Percentage satisfied with their standard of living}
  \item{unseced}{Percentage with at least secondary education}
  \item{vdem.2cat}{Is country a democracy or autocracy?}
  \item{vdem.4cat}{Ordinal ranking of democracy, 4 categories}
  \item{vdem.edi.score}{Electoral democracy index}
  \item{vdem.ldi.score}{Liberall democracy index}
  \item{vi.rel3}{Percent saying religion very important}
  \item{violence.cost}{Economic cost of violence on national economy}
  \item{votevap10s}{Turnout of voting age population in 2010s }
  \item{womenleg}{Percent women in lower house of legislature}
  \item{womyear}{Year women first enfranchised}
  \item{womyear2}{Year women first enfranchised}
  \item{youngleg}{Percentage of lower house of legislature aged 40 years or younger}
}
}
\source{
Sources vary.  See Appendix of printed textbook for further information.
}
\usage{
world
}
\description{
A dataset with variables about countries in the world. This dataset is used to demonstrate application of R to political analysis. See book Appendix for variable names and descriptions.
}
\keyword{datasets}
