% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_statistics.R
\name{summary_statistics}
\alias{summary_statistics}
\title{summary_statistics() Creates summary statistics table of all numeric variables in data}
\usage{
summary_statistics(
  data,
  probs = c(0, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 1),
  na.rm = T
)
}
\arguments{
\item{data}{A data.frame, tibble or data.table}

\item{probs}{The quantiles to compute. Default is c(0, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 1)}

\item{na.rm}{whether to exclude NA's from calculations}
}
\value{
A tibble with the Mean, N (not NA) and probs selects for each numeric column
}
\description{
summary_statistics() Creates summary statistics table of all numeric variables in data
}
\details{
This function computes the selected quantiles, mean and N values of all the numeric columns of data.
}
\examples{
data <-data.frame(x = c(1:5), y = c(100, 200, 300, 410, 540), z = rep("c", 5))
summary_statistics(data)
}
