% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-RCTRecruit.R
\docType{package}
\name{RCTRecruit-package}
\alias{RCTRecruit}
\alias{RCTRecruit-package}
\title{RCTRecruit: Non-Parametric Recruitment Prediction for Randomized Clinical Trials}
\description{
Accurate prediction of subject recruitment for Randomized Clinical Trials (RCT) remains an ongoing challenge. Many previous prediction models rely on parametric assumptions. We present functions for non-parametric RCT recruitment prediction under several scenarios.
}
\details{
\tabular{lll}{
    \tab  \tab  \cr
   Package: \tab RCTRecruit \tab  \cr
   Type: \tab Package \tab  \cr
   Version: \tab 0.1.24 \tab  \cr
   Date: \tab 2025-01-14 \tab  \cr
   License: \tab MIT + file LICENSE \tab  \cr
   Functions: \tab  \tab  \cr
    \tab \link{GetDistance} \tab Euclidean distance between predicted and actual recruitment \cr
    \tab \link{GetWeekPredCI} \tab Calculate median recruitment with 95\% CI for the next 104 weeks (two years) \cr
    \tab \link{LoadData} \tab Load recruitment data. \cr
    \tab \link{Time2Nsubjects} \tab Simulate the number of weeks needed to recruit a given number of subjects \cr
   Datasets: \tab  \tab  \cr
    \tab \link{gripsYR1} \tab Daily recruitment data for the 1st year of the GRIPS study \cr
    \tab \link{gripsYR2} \tab Daily recruitment data for the 2nd year of the GRIPS study \cr
    \tab \link{gripsYR2Weekly} \tab Weekly recruitment data for the 2nd year of the GRIPS study \cr
}
}
\references{
\enumerate{
\item Villasante-Tezanos A, Kuo Y, Kurinec C, Li Y, Yu X (2024). "A
non-parametric approach to predict the recruitment for randomized
clinical trials: an example in elderly inpatient settings." \emph{BMC
medical research methodology}, \emph{24}, 189. ISSN 1471-2288,
\url{https://pubmed.ncbi.nlm.nih.gov/39210285/}.
\item Gajewski BJ, Simon SD, Carlson SE (2008). "Predicting accrual in
clinical trials with Bayesian posterior predictive distributions."
\emph{Statistics in medicine}, \emph{27}, 2328-40. ISSN 0277-6715,
\url{https://pubmed.ncbi.nlm.nih.gov/17979152/}.
\item Jiang Y, Simon S, Mayo MS, Gajewski BJ (2015). "Modeling and validating
Bayesian accrual models on clinical data and simulations using adaptive
priors." \emph{Statistics in medicine}, \emph{34}, 613-29. ISSN 1097-0258,
\url{https://pubmed.ncbi.nlm.nih.gov/25376910/}.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/imalagaris/RCTRecruit}
  \item Report bugs at \url{https://github.com/imalagaris/RCTRecruit/issues}
}


Packages:\if{html}{\out{<br>}}
\itemize{
\item Liu J, Jiang Y, Wu C, Simon S, Mayo MS, Raghavan R, Gajewski BJ (2023).
\emph{accrual: Bayesian Accrual Prediction}. R package version 1.4,
\url{https://CRAN.R-project.org/package=accrual}.
}

Other Links: 
\code{\link{GetDistance}()},
\code{\link{GetWeekPredCI}()},
\code{\link{LoadData}()},
\code{\link{Time2Nsubjects}()},
\code{\link{gripsYR1}},
\code{\link{gripsYR2}},
\code{\link{gripsYR2Weekly}}
}
\author{
\strong{Maintainer}: Ioannis Malagaris \email{iomalaga@utmb.edu} (\href{https://orcid.org/0000-0001-5126-2068}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Alejandro Villasante-Tezanos \email{alvillas@utmb.edu}
  \item Christopher Kurinec \email{chkurine@utmb.edu}
  \item Xiaoying Yu \email{xiyu@utmb.edu}
}

}
\concept{Links}
\keyword{internal}
