% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{determine_beta}
\alias{determine_beta}
\title{Helpfunction in estimate_beta() for estimating beta_est.}
\usage{
determine_beta(
  string,
  X_special,
  Y_special,
  robust,
  NN,
  TT,
  S,
  method_estimate_beta,
  initialisation = FALSE,
  indices = NA,
  vars_est,
  sigma2,
  nosetting_local = FALSE,
  kappa_candidates = c(2^(-0:-20), 0),
  special_case_dgp1 = FALSE
)
}
\arguments{
\item{string}{can have values: "homogeneous" (when one beta_est is estimated for all individuals together) or "heterogeneous" (when beta_est is estimated either groupwise or elementwise)}

\item{X_special}{preprocessed X (2-dimensional matrix with 'var_est' observable variables)}

\item{Y_special}{preprocessed Y}

\item{robust}{robust or classical estimation}

\item{NN}{number of time series}

\item{TT}{length of time series}

\item{S}{estimated number of groups}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{initialisation}{indicator of being in the initialisation phase}

\item{indices}{individuals for which beta_est is being estimated}

\item{vars_est}{number of available observed variables for which a coefficient will be estimated. As default it is equal to the number of available observed variables.}

\item{sigma2}{sum of squared error terms, scaled by NT}

\item{nosetting_local}{option to remove the recommended setting in lmrob(). It is much faster. Defaults to FALSE.}

\item{kappa_candidates}{Defines the size of the SCAD-penalty used in the classical algorithm. This vector should contain more than 1 element.}

\item{special_case_dgp1}{special case for data generated according to dgp 1: it changes the 1st variable in X to 1 (-> intercept). Consequently the estimation of beta needs to be restructured slightly.}
}
\value{
The function returns a numeric vector (for the default setting: string == "heterogeneous") or a matrix with the estimated beta (if string == "homogeneous").
}
\description{
Helpfunction in estimate_beta() for estimating beta_est.
}
