% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{SuccessionPlot}
\alias{SuccessionPlot}
\title{Density Plots of two successive phases (for phases in temporal order constraint)}
\usage{
SuccessionPlot(Phase1Beginning_chain, Phase1End_chain, Phase2Beginning_chain,
  Phase2End_chain, level = 0.95,
  title = "Phases marginal posterior densities", GridLength = 1024)
}
\arguments{
\item{Phase1Beginning_chain}{numeric vector containing the output of the MCMC algorithm for the beginning of the oldest phase}

\item{Phase1End_chain}{numeric vector containing the output of the MCMC algorithm for the end of the oldest phase}

\item{Phase2Beginning_chain}{numeric vector containing the output of the MCMC algorithm for the beginning of the following phase}

\item{Phase2End_chain}{numeric vector containing the output of the MCMC algorithm for the end of the following phase}

\item{level}{probability corresponding to the level of confidence}

\item{title}{title of the graph}

\item{GridLength}{length of the grid used to estimate the density}
}
\value{
Plot of the densities of two successive phases
}
\description{
Plot of the densities of two successive phases and several summary statistics statistics (mean, CI, HPDR)
}
\details{
Transition and gap ranges are represented by two-coloured segments using the colors of the both phases in succession. 
If the gap between the successive phases does not exist, a cross is drawn instead of a segment. 
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Phases); attach(Phases)
  SuccessionPlot(Phase.1.alpha, Phase.1.beta, Phase.2.alpha, Phase.2.beta, 0.95)
}
\keyword{ gap between two phases}
\keyword{ transition between two phases}
\keyword{ phase time range}
\keyword{ temporal order}
\keyword{ marginal posterior density }
