#' @title Get Criteo Campaigns
#' 
#' @description This function returns the Criteo Campaign Information.
#' 
#' @param authToken Authentication token generated by \code{\link{doCriteoAuth}}
#' @param appToken Application Token
#' 
#' @export
#' 
#' @return Campaign Information
getCriteoCampaigns <- function(authToken, appToken){
  
  body = paste('<?xml version="1.0" encoding="utf-8"?>
               <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
               <soap:Header>
               <apiHeader xmlns="https://advertising.criteo.com/API/v201010">
               <authToken>', authToken ,'</authToken>
               <appToken>', appToken ,'</appToken>
               <clientVersion>string</clientVersion>
               </apiHeader>
               </soap:Header>
               <soap:Body>
               <getCampaigns xmlns="https://advertising.criteo.com/API/v201010">
               <campaignSelector>
               <campaignIDs>
               </campaignIDs>
               <budgetIDs>
               </budgetIDs>
               <campaignStatus>
               </campaignStatus>
               <biddingStrategy>
               </biddingStrategy>
               </campaignSelector>
               </getCampaigns>
               </soap:Body>    
               </soap:Envelope>',sep="")
  
  headerFields = c(Accept = "text/xml",
                   Accept = "multipart/*",
                   'Content-Type' = "text/xml; charset=utf-8",
                   SOAPAction = "https://advertising.criteo.com/API/v201010/getCampaigns")
  
  h = RCurl::basicTextGatherer()
  
  RCurl::curlPerform(url = "https://advertising.criteo.com/API/v201010/AdvertiserService.asmx",
                     httpheader = headerFields,
                     postfields = body,
                     writefunction = h$update
  )

  xml <- sub('xmlns="https://advertising.criteo.com/API/v201010"','',h$value())
  doc <- XML::xmlRoot(XML::xmlTreeParse(xml, useInternalNodes = TRUE))
  data <- data.frame(#campaignCategoryUID=xpathSApply(doc, "//campaignCategoryUID", xmlValue),
                    campaignID=XML::xpathSApply(doc, "//campaign/campaignID", XML::xmlValue),
                    campaignName=XML::xpathSApply(doc, "//campaignName", XML::xmlValue),
                    #categoryID=xpathSApply(doc, "//categoryID", xmlValue),
                    #selected=xpathSApply(doc, "//selected", xmlValue),
                    biddingStrategy=XML::xpathSApply(doc, "//campaignBid/biddingStrategy", XML::xmlValue),
                    status=XML::xpathSApply(doc, "//campaign/status", XML::xmlValue))
  data
}