% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REDCapR-package.R
\docType{package}
\name{REDCapR-package}
\alias{REDCapR-package}
\alias{REDCapR}
\title{R utilities for interacting with a REDCap data system \url{http://www.project-redcap.org/}}
\description{
Much of this package has been developed to support the needs of the following projects.  We appreciate the support.
\itemize{
\item \emph{OUHSC CCAN Independent Evaluation of the State of Oklahoma Competitive Maternal, Infant, and Early Childhood Home Visiting (\href{http://mchb.hrsa.gov/programs/homevisiting/}{MIECHV}) Project}. \href{https://perf-data.hrsa.gov/mchb/DGISReports/Abstract/AbstractDetails.aspx?Source=TVIS&GrantNo=D89MC23154&FY=2012}{HRSA/ACF D89MC23154}.  David Bard, PI, OUHSC; 2011-2015.
\item \emph{Independent Evaluation of the State of OK MIECHV Evidence Based Home Visitation Project}, \href{https://www.nih.gov/}{NIH}-sponsored collaboration with \href{https://www.ok.gov/health/}{OSDH}. David Bard, PI, OUHSC; 2015-2017.
\item \emph{OSDH ParentPRO Pilot Evaluation}, federally-sponsored collaboration with \href{https://www.ok.gov/health/}{OSDH}.  David Bard, PI, OUHSC; 2015-2017.
\item \emph{Title IV-E Waiver Project}, \href{http://mchb.hrsa.gov/}{HRSA/MCHB}-sponsored collaboration with \href{http://www.okdhs.org/}{OKDHS}; David Bard, PI, OUHSC; 2014-2017.
\item \emph{Integrative Analysis of Longitudinal Studies of Aging (IALSA)}, sponsored by \href{http://grantome.com/grant/NIH/P01-AG043362}{NIH 5P01AG043362}.  Scott Hofer, PI, University of Victoria; Will Beasley, PI of site-award, OUHSC; 2013-2018.
\item \emph{Oklahoma Shared Clinical and Translational Resources}, sponsored by \href{http://grantome.com/grant/NIH/U54-GM104938}{NIH NIGMS; U54 GM104938}. Judith A. James, PI, OUHSC; 2013-2018.
\item Additional Institutional Support from OUHSC \href{https://www.oumedicine.com/department-of-pediatrics}{Dept of Pediatrics}; 2013-2017.
}
}
\note{
The release version is available through \href{https://cran.r-project.org/package=REDCapR}{CRAN} by
running \code{install.packages('REDCapR')}.
The most recent development version is available through \href{https://github.com/OuhscBbmc/REDCapR}{GitHub} by
running
\code{devtools::install_github} \code{('OuhscBbmc/REDCapR')}
(make sure \href{https://cran.r-project.org/package=devtools}{devtools} is already installed).
If you're having trouble with the package, please install the development version.  If this doesn't solve
your problem, please create a \href{https://github.com/OuhscBbmc/REDCapR/issues}{new issue}, or email Will.

See REDCapR's advanced vignette for information and examples for overriding the default SSL options.
}
\examples{
\dontrun{
# Install/update REDCapR with the release version from CRAN.
install.packages('REDCapR')

# Install/update REDCapR with the development version from GitHub
#install.packages('devtools') #Uncomment if `devtools` isn't installed already.
devtools::install_github('OuhscBbmc/REDCapR')
}
}
