% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_tibble.R
\name{extract_tibble}
\alias{extract_tibble}
\title{Extract a single data tibble from a REDCapTidieR supertibble}
\usage{
extract_tibble(supertbl, tbl)
}
\arguments{
\item{supertbl}{A supertibble generated by \code{read_redcap()}. Required.}

\item{tbl}{The \code{redcap_form_name} of the data tibble to extract. Required.}
}
\value{
A \code{tibble}.
}
\description{
Take a supertibble generated with \code{read_redcap()}
and return one of its data tibbles.
}
\details{
This function makes it easy to extract a single instrument's data from a
REDCapTidieR supertibble.
}
\examples{
# Mock up a supertibble
sample_data <- tibble::tribble(
  ~redcap_form_name,    ~redcap_data,   ~structure,
  "super_hero_powers",  list(),         "repeating",
  "heroes_information", list(),         "nonrepeating"
)

extract_tibble(sample_data, "heroes_information")

}
