% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled.R
\name{format-helpers}
\alias{format-helpers}
\alias{fmt_strip_whitespace}
\alias{fmt_strip_trailing_colon}
\alias{fmt_strip_trailing_punct}
\alias{fmt_strip_html}
\alias{fmt_strip_field_embedding}
\title{Format REDCap variable labels}
\usage{
fmt_strip_whitespace(x)

fmt_strip_trailing_colon(x)

fmt_strip_trailing_punct(x)

fmt_strip_html(x)

fmt_strip_field_embedding(x)
}
\arguments{
\item{x}{a character vector}
}
\value{
a modified character vector
}
\description{
Use these functions with the \code{format_labels} argument of
\code{make_labelled()} to define how variable labels should be formatted before
being applied to the data columns of \code{redcap_data}. These functions are
helpful to create pretty variable labels from REDCap field labels.
\itemize{
\item \code{fmt_strip_whitespace()} removes extra white space inside and at the start
and end of a string. It is a thin wrapper of \code{stringr::str_trim()} and
\code{stringr::str_squish()}.
\item \code{fmt_strip_trailing_colon()} removes a colon character at the end of a string.
\item \code{fmt_strip_trailing_punct()} removes punctuation at the end of a string.
\item \code{fmt_strip_html()} removes html tags from a string.
\item \code{fmt_strip_field_embedding()} removes text between curly braces \code{{}} which
REDCap uses for special "field embedding" logic. Note that \code{read_redcap()}
removes html tags and field embedding logic from field labels in the metadata
by default.
}
}
\examples{

fmt_strip_whitespace("Poorly Spaced   Label ")

fmt_strip_trailing_colon("Label:")

fmt_strip_trailing_punct("Label-")

fmt_strip_html("<b>Bold Label</b>")

fmt_strip_field_embedding("Label{another_field}")

supertbl <- tibble::tribble(
  ~redcap_data, ~redcap_metadata,
  tibble::tibble(x = letters[1:3]), tibble::tibble(field_name = "x", field_label = "X Label:")
)

make_labelled(supertbl, format_labels = fmt_strip_trailing_colon)

}
