/*
 * Decompiled with CFR 0.152.
 */
package com.visutools.nav.bislider;

import com.visutools.nav.bislider.BiSlider;
import com.visutools.nav.bislider.ContentPainterSupport;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.parser.ParserDelegator;

public class BiSliderPresentation
extends ComponentUI
implements Serializable,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ComponentListener {
    protected static final ParserDelegator MAXIMUM_VARIABLE_SIZE_FOR_NAME = null;
    static final long serialVersionUID = 6420110040552724883L;
    protected BiSlider Ctrl = null;
    protected JComponent JComponent1 = null;
    protected int[][] ColorTable = null;
    protected long j = 0L;
    protected int NbAff = 0;
    protected final int NOTHING = 200;
    protected final int RIGHT_POLYGON = 201;
    protected final int LEFT_POLYGON = 202;
    protected final int SELECTION = 203;
    protected final int FIRST_LABEL = 204;
    protected final int LAST_LABEL = 205;
    protected int MouseUnder = 200;
    protected Polygon TheLeft_Polygon = null;
    protected Polygon TheRight_Polygon = null;
    protected Rectangle2D RectFirstLabel = null;
    protected Rectangle2D RectLastLabel = null;
    protected Rectangle2D RectangleSegment = null;
    protected boolean NeverDrawn = true;
    protected double GraduationWidth = 1.0;
    protected double PreciseOpenedValue = 0.0;
    protected static final int NONE = 100;
    protected static final int LEFT_RULER = 101;
    protected static final int RIGHT_RULER = 102;
    protected static final int SHIFT_LEFT_RULER = 103;
    protected static final int SHIFT_RIGHT_RULER = 104;
    protected static final int SEGMENT = 105;
    protected static final int SHIFT_SEGMENT = 106;
    protected static final int ALT_LEFT_RULER = 107;
    protected static final int ALT_RIGHT_RULER = 108;
    protected static final int SEGMENT_SIZE = 109;
    protected static final int SEGMENT_SIZE_INT = 110;
    protected static final int PRECISE_LEFT_RULER = 111;
    protected static final int PRECISE_RIGHT_RULER = 112;
    protected int Dragging = 100;
    protected int LeftValue = 0;
    protected int RightValue = 0;
    protected int DeplBef = 0;
    protected int DeplAft = 0;
    protected int Center = 0;
    protected int RulerWidth = 0;
    protected static final int MINIMUM_RULER_HEIGHT = 20;
    protected static final int PREFERRED_RULER_HEIGHT = 20;
    protected int RulerHeight = 20;
    protected static final int MARGIN_RULER_LEFT = 10;
    protected int Margin_Ruler_Top = 13;
    protected static final int MARGIN_RULER_RIGHT = 10;
    protected static final int MARGIN_RULER_BOTTOM = 3;
    protected JTextField JTextFieldMin = new JTextField("");
    protected JTextField JTextFieldMax = new JTextField("");
    protected Vector<Point> LastFiveEvents = null;
    protected JPanel JPanel1 = new JPanel();
    protected JSlider JSlider1 = new JSlider(1, -100, 100, 0);
    protected JLabel JLabel1 = new JLabel("0");
    protected ContentPainterSupport ContentPainterSupport1 = null;
    private static final int PADDING_TOP_BOTTOM = 20;
    private static final int BTN_NONE = 0;
    private static final int BTN_UP = 1;
    private static final int BTN_MID = 2;
    private static final int BTN_DOWN = 3;

    public BiSliderPresentation(BiSlider Ctrl_Arg, ContentPainterSupport ContentPainterSupport_Arg) {
        this.Ctrl = Ctrl_Arg;
        this.ContentPainterSupport1 = ContentPainterSupport_Arg;
        this.Ctrl.setBackground(null);
        this.JPanel1.setLayout(new BorderLayout());
        this.JPanel1.setBorder(BorderFactory.createLineBorder(this.Ctrl.getForeground()));
        this.JSlider1.setPaintLabels(true);
        this.JSlider1.setMajorTickSpacing(20);
        this.JSlider1.setMinorTickSpacing(1);
        this.JPanel1.add((Component)this.JSlider1, "Center");
        this.JPanel1.add((Component)this.JLabel1, "South");
        this.JLabel1.setHorizontalAlignment(0);
        this.JLabel1.setOpaque(true);
        this.JSlider1.setOpaque(true);
        this.JPanel1.revalidate();
        this.JSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ChangeEvent_Arg) {
                double MiddleVal = BiSliderPresentation.this.PreciseOpenedValue;
                double Amplitude = BiSliderPresentation.this.Ctrl.getSegmentSize() / (double)BiSliderPresentation.this.Ctrl.getSegmentCount();
                if (BiSliderPresentation.this.Dragging == 112 && MiddleVal - Amplitude < (double)BiSliderPresentation.this.Ctrl.getMinimumColoredValue()) {
                    MiddleVal = (double)BiSliderPresentation.this.Ctrl.getMinimumColoredValue() + Amplitude;
                } else if (BiSliderPresentation.this.Dragging == 111 && MiddleVal + Amplitude > (double)BiSliderPresentation.this.Ctrl.getMaximumColoredValue()) {
                    MiddleVal = (double)BiSliderPresentation.this.Ctrl.getMaximumColoredValue() - Amplitude;
                } else if (MiddleVal - Amplitude < BiSliderPresentation.this.Ctrl.getMinimumValue()) {
                    MiddleVal = BiSliderPresentation.this.Ctrl.getMinimumValue() + Amplitude;
                } else if (MiddleVal + Amplitude > BiSliderPresentation.this.Ctrl.getMaximumValue()) {
                    MiddleVal = BiSliderPresentation.this.Ctrl.getMaximumValue() - Amplitude;
                }
                double Val = MiddleVal + (double)BiSliderPresentation.this.JSlider1.getValue() / 100.0 * Amplitude;
                BiSliderPresentation.this.JLabel1.setText("");
                if (BiSliderPresentation.this.Dragging == 111) {
                    BiSliderPresentation.this.Ctrl.setMinimumColoredValue((int)Val);
                }
                if (BiSliderPresentation.this.Dragging == 112) {
                    BiSliderPresentation.this.Ctrl.setMaximumColoredValue((int)Val);
                }
            }
        });
        if (UIManager.getLookAndFeel().getName().equals("Metal")) {
            int[] xp1 = new int[]{this.LeftValue, this.LeftValue - 7, this.LeftValue - 7, this.LeftValue - 6, this.LeftValue + 6, this.LeftValue + 7, this.LeftValue + 7};
            int[] yp1 = new int[]{this.Margin_Ruler_Top + this.RulerHeight + 1 - 14, this.Margin_Ruler_Top + this.RulerHeight + 1 - 7, this.Margin_Ruler_Top + this.RulerHeight + 1, this.Margin_Ruler_Top + this.RulerHeight + 1 + 1, this.Margin_Ruler_Top + this.RulerHeight + 1 + 1, this.Margin_Ruler_Top + this.RulerHeight + 1, this.Margin_Ruler_Top + this.RulerHeight + 1 - 7};
            this.TheLeft_Polygon = new Polygon(xp1, yp1, 7);
            int[] xp2 = new int[]{this.RightValue - 7, this.RightValue - 7, this.RightValue - 6, this.RightValue + 6, this.RightValue + 7, this.RightValue + 7, this.RightValue};
            int[] yp2 = new int[]{this.Margin_Ruler_Top - 1 + 7, this.Margin_Ruler_Top - 1, this.Margin_Ruler_Top - 1 - 1, this.Margin_Ruler_Top - 1 - 1, this.Margin_Ruler_Top - 1, this.Margin_Ruler_Top - 1 + 7, this.Margin_Ruler_Top - 1 + 14};
            this.TheRight_Polygon = new Polygon(xp2, yp2, 7);
        } else {
            this.TheLeft_Polygon = new Polygon();
            this.TheLeft_Polygon.addPoint(this.LeftValue, this.Margin_Ruler_Top + this.RulerHeight - this.RulerHeight / 2 - 1);
            this.TheLeft_Polygon.addPoint(this.LeftValue + this.RulerHeight / 2 + 2, this.Margin_Ruler_Top + this.RulerHeight + 1);
            this.TheLeft_Polygon.addPoint(this.LeftValue, this.Margin_Ruler_Top + this.RulerHeight + 1);
            this.TheLeft_Polygon.addPoint(this.LeftValue, this.Margin_Ruler_Top + this.RulerHeight - this.RulerHeight / 2 - 1);
            this.TheRight_Polygon = new Polygon();
            this.TheRight_Polygon.addPoint(this.RightValue - 2 - this.RulerHeight / 2, this.Margin_Ruler_Top - 1);
            this.TheRight_Polygon.addPoint(this.RightValue, this.Margin_Ruler_Top - 1);
            this.TheRight_Polygon.addPoint(this.RightValue, this.Margin_Ruler_Top + this.RulerHeight / 2 + 1);
            this.TheRight_Polygon.addPoint(this.RightValue - 2 - this.RulerHeight / 2, this.Margin_Ruler_Top - 1);
        }
        this.JComponent1 = this.Ctrl;
        this.JComponent1.addMouseListener(this);
        this.JComponent1.addMouseMotionListener(this);
        this.JComponent1.addMouseWheelListener(this);
        this.JComponent1.addComponentListener(this);
        this.JComponent1.setLayout(null);
        this.Ctrl.setPreferredSize(new Dimension(20 + 16 * this.Ctrl.getSegmentCount(), this.Margin_Ruler_Top + 3 + 20));
        this.Ctrl.setMinimumSize(new Dimension(20 + 8 * this.Ctrl.getSegmentCount(), this.Margin_Ruler_Top + 3 + 20));
        this.JTextFieldMin.setVisible(false);
        this.JTextFieldMax.setVisible(false);
        this.JTextFieldMin.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent DocumentEvent_Arg) {
            }

            public void insertUpdate(DocumentEvent DocumentEvent_Arg) {
                String Text = BiSliderPresentation.this.JTextFieldMin.getText();
                if (!BiSliderPresentation.this.Ctrl.getUnit().equals("alpha")) {
                    try {
                        double Val = Double.parseDouble(Text);
                        BiSliderPresentation.this.JTextFieldMin.setBackground(Color.WHITE);
                    }
                    catch (NumberFormatException NumberFormatException_Arg) {
                        BiSliderPresentation.this.JTextFieldMin.setBackground(new Color(255, 128, 128));
                    }
                }
            }

            public void removeUpdate(DocumentEvent DocumentEvent_Arg) {
                String Text = BiSliderPresentation.this.JTextFieldMin.getText();
                if (!BiSliderPresentation.this.Ctrl.getUnit().equals("alpha")) {
                    try {
                        double Val = Double.parseDouble(Text);
                        BiSliderPresentation.this.JTextFieldMin.setBackground(Color.WHITE);
                    }
                    catch (NumberFormatException NumberFormatException_Arg) {
                        BiSliderPresentation.this.JTextFieldMin.setBackground(new Color(255, 128, 128));
                    }
                }
            }
        });
        this.JTextFieldMin.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    while (BiSliderPresentation.this.JTextFieldMin.getActionListeners().length > 0) {
                        BiSliderPresentation.this.JTextFieldMin.removeActionListener(BiSliderPresentation.this.JTextFieldMin.getActionListeners()[0]);
                    }
                    BiSliderPresentation.this.JTextFieldMin.setVisible(false);
                }
                BiSliderPresentation.this.JTextFieldMin.setSize(BiSliderPresentation.this.JTextFieldMin.getPreferredSize().width + 10, BiSliderPresentation.this.JTextFieldMin.getPreferredSize().height);
            }
        });
        this.JComponent1.add(this.JTextFieldMin);
        this.JTextFieldMax.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent DocumentEvent_Arg) {
            }

            public void insertUpdate(DocumentEvent DocumentEvent_Arg) {
                String Text = BiSliderPresentation.this.JTextFieldMax.getText();
                if (!BiSliderPresentation.this.Ctrl.getUnit().equals("alpha")) {
                    try {
                        double Val = Double.parseDouble(Text);
                        BiSliderPresentation.this.JTextFieldMax.setBackground(Color.WHITE);
                    }
                    catch (NumberFormatException NumberFormatException_Arg) {
                        BiSliderPresentation.this.JTextFieldMax.setBackground(new Color(255, 128, 128));
                    }
                }
            }

            public void removeUpdate(DocumentEvent DocumentEvent_Arg) {
                String Text = BiSliderPresentation.this.JTextFieldMax.getText();
                if (!BiSliderPresentation.this.Ctrl.getUnit().equals("alpha")) {
                    try {
                        double Val = Double.parseDouble(Text);
                        BiSliderPresentation.this.JTextFieldMax.setBackground(Color.WHITE);
                    }
                    catch (NumberFormatException NumberFormatException_Arg) {
                        BiSliderPresentation.this.JTextFieldMax.setBackground(new Color(255, 128, 128));
                    }
                }
            }
        });
        this.JTextFieldMax.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    while (BiSliderPresentation.this.JTextFieldMax.getActionListeners().length > 0) {
                        BiSliderPresentation.this.JTextFieldMax.removeActionListener(BiSliderPresentation.this.JTextFieldMax.getActionListeners()[0]);
                    }
                    BiSliderPresentation.this.JTextFieldMax.setVisible(false);
                }
                int OldX = BiSliderPresentation.this.JTextFieldMax.getLocation().x;
                int OldWidth = BiSliderPresentation.this.JTextFieldMax.getSize().width;
                BiSliderPresentation.this.JTextFieldMax.setSize(BiSliderPresentation.this.JTextFieldMax.getPreferredSize().width + 10, BiSliderPresentation.this.JTextFieldMax.getPreferredSize().height);
                BiSliderPresentation.this.JTextFieldMax.setLocation(OldX + (OldWidth - BiSliderPresentation.this.JTextFieldMax.getSize().width), BiSliderPresentation.this.JTextFieldMax.getLocation().y);
            }
        });
        this.JComponent1.add(this.JTextFieldMax);
        this.JComponent1.setDoubleBuffered(true);
    }

    protected Color getOppositeColor(Color Color_Arg) {
        int R = Color_Arg.getRed();
        int G = Color_Arg.getGreen();
        int B = Color_Arg.getBlue();
        R = 255 - R;
        int R2 = (Color_Arg.getRed() + 128) % 255;
        if (Math.abs(R - Color_Arg.getRed()) < Math.abs(R2 - Color_Arg.getRed())) {
            R = R2;
        }
        G = 255 - G;
        int G2 = (Color_Arg.getGreen() + 128) % 255;
        if (Math.abs(G - Color_Arg.getGreen()) < Math.abs(G2 - Color_Arg.getGreen())) {
            G = G2;
        }
        B = 255 - B;
        int B2 = (Color_Arg.getBlue() + 128) % 255;
        if (Math.abs(B - Color_Arg.getBlue()) < Math.abs(B2 - Color_Arg.getBlue())) {
            B = B2;
        }
        return new Color(R, G, B);
    }

    public void setRulerValues(double Min_Arg, double Max_Arg) {
        int NewRightValue;
        int SegmentCount = this.Ctrl.getSegmentCount();
        if (SegmentCount == 0) {
            SegmentCount = 1;
        }
        this.RulerWidth = this.JComponent1.getSize().width - 10 - 10;
        this.GraduationWidth = (double)this.RulerWidth * this.Ctrl.getSegmentSize() / (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue());
        this.NeverDrawn = false;
        int NewLeftValue = (int)(10.0 + (Min_Arg - this.Ctrl.getMinimumValue()) * (double)this.RulerWidth / (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()));
        if (NewLeftValue <= (NewRightValue = (int)(10.0 + (Max_Arg - this.Ctrl.getMinimumValue()) * (double)this.RulerWidth / (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()))) && NewLeftValue >= 10 && NewRightValue <= 10 + this.RulerWidth) {
            this.LeftValue = NewLeftValue;
            this.RightValue = NewRightValue;
            int TriangleSide = this.RulerHeight / 2;
            TriangleSide = Math.max(Math.min(TriangleSide, 20), 10);
            if (UIManager.getLookAndFeel().getName().equals("Metal")) {
                int[] xp1 = new int[]{this.LeftValue, this.LeftValue - 7, this.LeftValue - 7, this.LeftValue - 6, this.LeftValue + 6, this.LeftValue + 7, this.LeftValue + 7};
                int[] yp1 = new int[]{this.Margin_Ruler_Top + this.RulerHeight + 1 - 14, this.Margin_Ruler_Top + this.RulerHeight + 1 - 7, this.Margin_Ruler_Top + this.RulerHeight + 1, this.Margin_Ruler_Top + this.RulerHeight + 1 + 1, this.Margin_Ruler_Top + this.RulerHeight + 1 + 1, this.Margin_Ruler_Top + this.RulerHeight + 1, this.Margin_Ruler_Top + this.RulerHeight + 1 - 7};
                this.TheLeft_Polygon = new Polygon(xp1, yp1, 7);
                int[] xp2 = new int[]{this.RightValue - 7, this.RightValue - 7, this.RightValue - 6, this.RightValue + 6, this.RightValue + 7, this.RightValue + 7, this.RightValue};
                int[] yp2 = new int[]{this.Margin_Ruler_Top - 1 + 7, this.Margin_Ruler_Top - 1, this.Margin_Ruler_Top - 1 - 1, this.Margin_Ruler_Top - 1 - 1, this.Margin_Ruler_Top - 1, this.Margin_Ruler_Top - 1 + 7, this.Margin_Ruler_Top - 1 + 14};
                this.TheRight_Polygon = new Polygon(xp2, yp2, 7);
            } else {
                this.TheLeft_Polygon = new Polygon();
                this.TheLeft_Polygon.addPoint(this.LeftValue, this.Margin_Ruler_Top + this.RulerHeight - TriangleSide - 1);
                this.TheLeft_Polygon.addPoint(this.LeftValue + TriangleSide + 2, this.Margin_Ruler_Top + this.RulerHeight + 1);
                this.TheLeft_Polygon.addPoint(this.LeftValue, this.Margin_Ruler_Top + this.RulerHeight + 1);
                this.TheLeft_Polygon.addPoint(this.LeftValue, this.Margin_Ruler_Top + this.RulerHeight - TriangleSide - 1);
                this.TheRight_Polygon = new Polygon();
                this.TheRight_Polygon.addPoint(this.RightValue - 2 - TriangleSide, this.Margin_Ruler_Top - 1);
                this.TheRight_Polygon.addPoint(this.RightValue, this.Margin_Ruler_Top - 1);
                this.TheRight_Polygon.addPoint(this.RightValue, this.Margin_Ruler_Top + TriangleSide + 1);
                this.TheRight_Polygon.addPoint(this.RightValue - 2 - TriangleSide, this.Margin_Ruler_Top - 1);
            }
        } else if (this.Ctrl.getSize().width != 0 && this.Ctrl.getSize().height != 0) {
            System.err.println("\nsetRulerValues()");
            System.err.println("  Size              = " + this.Ctrl.getSize());
            System.err.println("  NewLeftValue      = " + NewLeftValue);
            System.err.println("  NewRightValue     = " + NewRightValue);
            System.err.println("  MARGIN_RULER_LEFT = 10");
            System.err.println("  MARGIN_RULER_LEFT + RulerWidth = " + (10 + this.RulerWidth));
        }
    }

    public void update(Graphics graphics_Arg, JComponent comp) {
        Color BackColor = null;
        Object SliderBackColor = UIManager.getLookAndFeel().getDefaults().get("Slider.background");
        if (SliderBackColor != null || !(SliderBackColor instanceof ColorUIResource)) {
            BackColor = (Color)SliderBackColor;
        }
        if (BackColor == null || this.Ctrl.getBackground() != null) {
            BackColor = this.Ctrl.getBackground();
        }
        if (comp.isOpaque() && BackColor != null) {
            graphics_Arg.setColor(BackColor);
            graphics_Arg.fillRect(0, 0, this.JComponent1.getSize().width, this.JComponent1.getSize().height);
        }
        this.paint(graphics_Arg);
    }

    public void paint(Graphics graphics_Arg) {
        int i;
        if (graphics_Arg == null) {
            return;
        }
        Graphics2D Graphics2 = (Graphics2D)graphics_Arg;
        RenderingHints RenderingHints2 = new RenderingHints(null);
        RenderingHints2.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        RenderingHints2.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        RenderingHints2.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        RenderingHints2.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        Graphics2.setRenderingHints(RenderingHints2);
        Font Font1 = this.Ctrl.getFont();
        Font Font2 = new Font(Font1.getName(), 1, Font1.getSize());
        Shape OldClip = Graphics2.getClip();
        RoundRectangle2D.Float NewClip = new RoundRectangle2D.Float(10.0f, this.Margin_Ruler_Top, this.RulerWidth, this.RulerHeight, this.Ctrl.getArcSize(), this.Ctrl.getArcSize());
        int SegmentCount = this.Ctrl.getSegmentCount();
        FontMetrics TheFontMetrics = Graphics2.getFontMetrics();
        this.RulerWidth = this.JComponent1.getSize().width - 10 - 10;
        double ValuesWidth = this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue();
        if (this.NeverDrawn) {
            this.LeftValue = (int)(10.0 + ((double)this.Ctrl.getMinimumColoredValue() - this.Ctrl.getMinimumValue()) * (double)this.RulerWidth / (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()));
            this.RightValue = (int)(10.0 + ((double)this.Ctrl.getMaximumColoredValue() - this.Ctrl.getMinimumValue()) * (double)this.RulerWidth / (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()));
            this.TheRight_Polygon.translate(this.RulerWidth, 0);
            this.NeverDrawn = false;
        }
        if (this.RulerWidth != this.JComponent1.getSize().width - 10 - 10) {
            int NewRulerWidth = this.JComponent1.getSize().width - 10 - 10;
            NewRulerWidth -= NewRulerWidth % SegmentCount;
            int NewLeftValue = 10 + (this.LeftValue - 10) * NewRulerWidth / this.RulerWidth;
            int NewRightValue = 10 + (this.RightValue - 10) * NewRulerWidth / this.RulerWidth;
            this.TheLeft_Polygon.translate(NewLeftValue - this.LeftValue, 0);
            this.TheRight_Polygon.translate(NewRightValue - this.RightValue, 0);
            this.LeftValue = NewLeftValue;
            this.RightValue = NewRightValue;
            this.RulerWidth = NewRulerWidth;
            this.GraduationWidth = (float)((double)this.RulerWidth * this.Ctrl.getSegmentSize() / (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()));
        }
        Graphics2.setClip(NewClip);
        if (!UIManager.getLookAndFeel().getName().equals("Metal")) {
            Graphics2.setColor(this.Ctrl.getSliderBackground());
            Graphics2.fillRoundRect(10, this.Margin_Ruler_Top, this.RulerWidth, this.RulerHeight, this.Ctrl.getArcSize(), this.Ctrl.getArcSize());
        } else {
            Object SliderBackColor = UIManager.getLookAndFeel().getDefaults().get("Slider.gradient");
            if (SliderBackColor != null && SliderBackColor instanceof List) {
                List GradientProperties = (List)SliderBackColor;
                Float Cut1 = (Float)GradientProperties.get(0);
                Float Cut2 = (Float)GradientProperties.get(1);
                Color Color1 = (Color)GradientProperties.get(2);
                Color Color2 = (Color)GradientProperties.get(3);
                Color Color3 = (Color)GradientProperties.get(4);
                float Rem = 1.0f - Cut2.floatValue() - 2.0f * Cut1.floatValue();
                int x1 = 10;
                int x2 = this.RulerWidth + 10;
                int y1 = this.Margin_Ruler_Top;
                int y2 = this.Margin_Ruler_Top + this.RulerHeight;
                GradientPaint GradientPaint1 = new GradientPaint(x1, y1, Color3, x1, y1 + (int)((float)this.RulerHeight * Rem), Color2);
                GradientPaint GradientPaint2 = new GradientPaint(x1, y1 + (int)((float)this.RulerHeight * Rem), Color2, x1, y1 + (int)((float)this.RulerHeight * (Rem + Cut1.floatValue())), Color1);
                GradientPaint GradientPaint3 = new GradientPaint(x1, y1 + (int)((float)this.RulerHeight * (Rem + Cut1.floatValue() + Cut2.floatValue())), Color1, x1, y2, Color.WHITE);
                Graphics2.setPaint(GradientPaint1);
                Graphics2.fillRect(x1, y1, this.RulerWidth, (int)((float)this.RulerHeight * Rem));
                Graphics2.setPaint(GradientPaint2);
                Graphics2.fillRect(x1, y1 + (int)((float)this.RulerHeight * Rem), this.RulerWidth, (int)((float)this.RulerHeight * Cut1.floatValue()) + 1);
                Graphics2.setColor(Color1);
                Graphics2.fillRect(x1, y1 + (int)((float)this.RulerHeight * (Rem + Cut1.floatValue())), this.RulerWidth, (int)((float)this.RulerHeight * Cut2.floatValue()) + 1);
                Graphics2.setPaint(GradientPaint3);
                Graphics2.fillRect(x1, y1 + (int)((float)this.RulerHeight * (Rem + Cut1.floatValue() + Cut2.floatValue())), this.RulerWidth, (int)((float)this.RulerHeight * Cut1.floatValue()) + 1);
            }
        }
        Graphics2.setColor(this.Ctrl.getSliderBackground().darker());
        Graphics2.drawArc(11, this.Margin_Ruler_Top, this.Ctrl.getArcSize(), this.Ctrl.getArcSize(), 90, 90);
        Graphics2.drawArc(10 + this.RulerWidth - this.Ctrl.getArcSize() - 1, this.Margin_Ruler_Top, this.Ctrl.getArcSize(), this.Ctrl.getArcSize(), 0, 90);
        Graphics2.setColor(this.Ctrl.getSliderBackground().brighter());
        Graphics2.drawArc(10 + this.RulerWidth - this.Ctrl.getArcSize() - 1, this.Margin_Ruler_Top + this.RulerHeight - this.Ctrl.getArcSize(), this.Ctrl.getArcSize(), this.Ctrl.getArcSize(), 270, 90);
        Graphics2.drawArc(11, this.Margin_Ruler_Top + this.RulerHeight - this.Ctrl.getArcSize(), this.Ctrl.getArcSize(), this.Ctrl.getArcSize(), 180, 90);
        Graphics2.setColor(this.Ctrl.getSliderBackground().darker());
        Graphics2.drawLine(10 + this.Ctrl.getArcSize() / 2 - 1, this.Margin_Ruler_Top + 1, 10 + this.RulerWidth - this.Ctrl.getArcSize() / 2 + 1, this.Margin_Ruler_Top + 1);
        Graphics2.drawLine(11, this.Margin_Ruler_Top + this.Ctrl.getArcSize() / 2, 11, this.Margin_Ruler_Top + this.RulerHeight - this.Ctrl.getArcSize() / 2);
        Graphics2.setColor(this.Ctrl.getSliderBackground().brighter());
        Graphics2.drawLine(10 + this.Ctrl.getArcSize() / 2 - 1, this.Margin_Ruler_Top + this.RulerHeight - 1, 10 + this.RulerWidth - this.Ctrl.getArcSize() / 2 + 1, this.Margin_Ruler_Top + this.RulerHeight - 1);
        Graphics2.drawLine(10 + this.RulerWidth - 1, this.Margin_Ruler_Top + this.Ctrl.getArcSize() / 2 + 1, 10 + this.RulerWidth - 1, this.Margin_Ruler_Top + this.RulerHeight - this.Ctrl.getArcSize() / 2);
        Graphics2.setClip(OldClip);
        int LastMax = 0;
        int SegmentCountBefore = 0;
        double[][] ColTable = this.Ctrl.getColorTable();
        String Unit = this.Ctrl.getUnit();
        for (i = 0; i <= SegmentCount; ++i) {
            double Val = this.Ctrl.getMinimumValue() + (double)i * this.Ctrl.getSegmentSize();
            double Val2 = this.Ctrl.getMinimumValue() + (double)(i + 1) * this.Ctrl.getSegmentSize();
            if (Val <= ColTable[0][0] && ColTable[0][0] < Val2) {
                SegmentCountBefore = i;
            }
            String NumberString = "";
            int NumberWidth = 0;
            int x = 0;
            String MaxNumberString = "";
            MaxNumberString = Unit.equals("alpha") ? "" + (char)((int)this.Ctrl.getMaximumValue() + 65) : (this.Ctrl.getMaximumValue() == (double)((long)this.Ctrl.getMaximumValue()) ? "" + (long)this.Ctrl.getMaximumValue() + Unit : "" + (long)(this.Ctrl.getMaximumValue() * 10.0) / 10L + Unit);
            if (Val > this.Ctrl.getMaximumValue()) {
                Val = this.Ctrl.getMaximumValue();
                NumberString = Unit.equals("alpha") ? "" + (char)((int)Val + 65) : (Val == (double)((long)Val) ? "" + (long)Val + Unit : "" + (float)((long)(Val * 10.0)) / 10.0f + Unit);
                NumberWidth = TheFontMetrics.stringWidth(NumberString);
                x = this.JComponent1.getSize().width - 10 - NumberWidth;
            } else {
                NumberString = Unit.equals("alpha") ? "" + (char)((int)Val + 65) : (Val == (double)((long)Val) ? "" + (long)Val + Unit : "" + (float)((long)(Val * 10.0)) / 10.0f + Unit);
                NumberWidth = TheFontMetrics.stringWidth(NumberString);
                x = 10 + (int)(this.GraduationWidth * (double)i) - (int)((float)NumberWidth * ((float)i / (float)SegmentCount));
            }
            graphics_Arg.setColor(this.Ctrl.getForeground());
            if (Val == this.Ctrl.getMaximumValue() || Val == this.Ctrl.getMinimumValue()) {
                Graphics2.setFont(Font2);
                Graphics2.drawString(NumberString, x, this.Margin_Ruler_Top - 1);
                Graphics2.setFont(Font1);
                LastMax = x + NumberWidth;
            } else if (x + NumberWidth < this.JComponent1.getSize().width - 10 - TheFontMetrics.stringWidth(MaxNumberString) && x >= LastMax + 2) {
                Graphics2.drawString(NumberString, x, this.Margin_Ruler_Top - 1);
                LastMax = x + NumberWidth;
            }
            if (LastMax == x + NumberWidth) {
                Graphics2.setColor(this.Ctrl.getSliderBackground().darker().darker());
            } else {
                Graphics2.setColor(this.Ctrl.getSliderBackground().darker());
            }
            if (this.ContentPainterSupport1.getPainterListenerNumber() > 0 && Val < this.Ctrl.getMaximumValue()) {
                int x0 = 10 + (int)(this.GraduationWidth * (double)i);
                int x3 = 10 + (int)(this.GraduationWidth * (double)(i + 1));
                Rectangle Rect1bis = new Rectangle(x0, this.Margin_Ruler_Top + 2, x3 - x0, this.RulerHeight - 3);
                x3 = Math.min(x3, 10 + this.RulerWidth);
                Rectangle Rect1 = new Rectangle(x0, this.Margin_Ruler_Top + 2, x3 - x0, this.RulerHeight - 3);
                Shape ShapeClip = Graphics2.getClip();
                Color Color0 = Graphics2.getColor();
                Graphics2.setClip(NewClip);
                Graphics2.clip(Rect1);
                this.ContentPainterSupport1.firePaint(this.Ctrl, Graphics2, Val, Val2, i, null, Rect1bis, Rect1bis);
                Graphics2.setClip(ShapeClip);
                Graphics2.setColor(Color0);
            }
            if (i != 0 && Val < this.Ctrl.getMaximumValue() && this.ContentPainterSupport1.getPainterListenerNumber() == 0) {
                Graphics2.drawLine(10 + (int)(this.GraduationWidth * (double)i), this.Margin_Ruler_Top + 2, 10 + (int)(this.GraduationWidth * (double)i), this.Margin_Ruler_Top + this.RulerHeight - 2);
            }
            if (i == 0) {
                this.RectFirstLabel = new Rectangle(x - 1, this.Margin_Ruler_Top - TheFontMetrics.getAscent(), NumberWidth + 1, TheFontMetrics.getAscent());
            }
            if (i == SegmentCount) {
                this.RectLastLabel = new Rectangle(x - 1, this.Margin_Ruler_Top - TheFontMetrics.getAscent(), NumberWidth + 1, TheFontMetrics.getAscent());
            }
            if (this.MouseUnder == 204) {
                Graphics2.draw(this.RectFirstLabel);
            }
            if (this.MouseUnder != 205) continue;
            Graphics2.draw(this.RectLastLabel);
        }
        if (this.MouseUnder == 105 && this.RectangleSegment != null) {
            Graphics2.setColor(SystemColor.control.darker());
            Graphics2.draw(this.RectangleSegment);
        }
        for (i = 0; i < ColTable.length; ++i) {
            Graphics2.setColor(new Color((int)ColTable[i][2]));
            if (!(ColTable[i][0] < ColTable[i][1])) continue;
            int x1 = (int)(10.0 + (double)this.RulerWidth * (ColTable[i][0] - this.Ctrl.getMinimumValue()) / ValuesWidth) + 1;
            int x2 = (int)(10.0 + (double)this.RulerWidth * (ColTable[i][1] - this.Ctrl.getMinimumValue()) / ValuesWidth);
            int x0 = 10 + (int)(this.GraduationWidth * (double)((int)ColTable[i][3]));
            int x3 = 10 + (int)(this.GraduationWidth * (double)((int)(ColTable[i][3] + 1.0)));
            Rectangle Rect1bis = new Rectangle(x1, this.Margin_Ruler_Top + 2, x2 - x1, this.RulerHeight - 3);
            x3 = Math.min(x3, 10 + this.RulerWidth);
            Rectangle Rect1 = new Rectangle(x1, this.Margin_Ruler_Top + 2, x2 - x1, this.RulerHeight - 3);
            Rectangle RectClip = new Rectangle(x1 - 1, this.Margin_Ruler_Top + 2, x2 - x1 + 1, this.RulerHeight - 3);
            Rectangle Rect2 = new Rectangle(x0, this.Margin_Ruler_Top + 2, x3 - x0, this.RulerHeight - 3);
            if (this.ContentPainterSupport1.getPainterListenerNumber() == 0) {
                Graphics2.fill(Rect1);
                if (i == 0) continue;
                Graphics2.setColor(new Color(Graphics2.getColor().getRed(), Graphics2.getColor().getGreen(), Graphics2.getColor().getBlue(), 192));
                Graphics2.drawLine(x1 - 1, this.Margin_Ruler_Top + 3, x1 - 1, this.Margin_Ruler_Top + this.RulerHeight - 3);
                continue;
            }
            Shape ShapeClip = Graphics2.getClip();
            Color Color0 = Graphics2.getColor();
            Graphics2.setClip(NewClip);
            Graphics2.clip(RectClip);
            this.ContentPainterSupport1.firePaint(this.Ctrl, Graphics2, ColTable[i][0], ColTable[i][1], i + SegmentCountBefore, Graphics2.getColor(), Rect1bis, Rect2);
            Graphics2.setClip(OldClip);
            Graphics2.setColor(Color0);
        }
        Graphics2.setClip(OldClip);
        if (this.Dragging == 107 || this.Dragging == 108) {
            Rectangle Rect1 = this.TheRight_Polygon.getBounds();
            Rectangle Rect2 = this.TheLeft_Polygon.getBounds();
            Rectangle2D Rectangle2D1 = Rect1.createUnion(Rect2);
            Graphics2.setColor(SystemColor.scrollbar.darker());
            Graphics2.fillRect((int)(Rectangle2D1.getX() + Rectangle2D1.getWidth() / 2.0), this.Margin_Ruler_Top, 2, this.RulerHeight);
        }
        Graphics2.setColor(Color.BLACK);
        Graphics2.drawRoundRect(10, this.Margin_Ruler_Top, this.RulerWidth, this.RulerHeight, this.Ctrl.getArcSize(), this.Ctrl.getArcSize());
        this.paintThumbs(Graphics2);
        if (this.Dragging == 108 || this.Dragging == 107 || this.Dragging == 102 || this.Dragging == 105 || this.Dragging == 106 || this.Dragging == 104) {
            String ValString = "";
            if (Unit.equals("alpha")) {
                ValString = "" + (char)(this.Ctrl.getMaximumColoredValue() + 65);
            } else if ((double)Math.abs(this.Ctrl.getMaximumColoredValue() - this.Ctrl.getMaximumColoredValue()) < 1.0E-4) {
                ValString = "" + this.Ctrl.getMaximumColoredValue();
            }
            Graphics2.setColor(this.getOppositeColor(this.Ctrl.getForeground()));
            Graphics2.drawString(ValString, this.RightValue + 3, this.Margin_Ruler_Top + TheFontMetrics.getAscent() + 1);
            Graphics2.setColor(this.Ctrl.getForeground());
            Graphics2.drawString(ValString, this.RightValue + 2, this.Margin_Ruler_Top + TheFontMetrics.getAscent());
        }
        if (this.Dragging == 108 || this.Dragging == 107 || this.Dragging == 101 || this.Dragging == 105 || this.Dragging == 106 || this.Dragging == 103) {
            String ValString = "";
            if (Unit.equals("alpha")) {
                ValString = "" + (char)(this.Ctrl.getMinimumColoredValue() + 65);
            } else if ((double)Math.abs(this.Ctrl.getMinimumColoredValue() - this.Ctrl.getMinimumColoredValue()) < 1.0E-4) {
                ValString = "" + this.Ctrl.getMinimumColoredValue();
            }
            Graphics2.setColor(this.getOppositeColor(this.Ctrl.getForeground()));
            Graphics2.drawString(ValString, this.LeftValue - TheFontMetrics.stringWidth(ValString) - 1, this.Margin_Ruler_Top + this.RulerHeight - 1);
            Graphics2.setColor(this.Ctrl.getForeground());
            Graphics2.drawString(ValString, this.LeftValue - TheFontMetrics.stringWidth(ValString) - 2, this.Margin_Ruler_Top + this.RulerHeight - 2);
        }
        if (this.JTextFieldMax.isVisible()) {
            this.JTextFieldMax.repaint();
        }
        if (this.JTextFieldMin.isVisible()) {
            this.JTextFieldMin.repaint();
        }
    }

    public void paintThumbs(Graphics graphics_Arg) {
        Graphics2D Graphics2 = (Graphics2D)graphics_Arg;
        if (UIManager.getLookAndFeel().getName().equals("Metal")) {
            if (this.Dragging == 101 || this.Dragging == 103 || this.Dragging == 107) {
                this.paintThumb(graphics_Arg, true, this.TheLeft_Polygon, MetalLookAndFeel.getPrimaryControlShadow(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControl());
            } else if (this.MouseUnder == 202) {
                this.paintThumb(graphics_Arg, true, this.TheLeft_Polygon, MetalLookAndFeel.getControlShadow(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
            } else {
                this.paintThumb(graphics_Arg, true, this.TheLeft_Polygon, MetalLookAndFeel.getControl(), MetalLookAndFeel.getControlShadow(), MetalLookAndFeel.getControlHighlight());
            }
            if (this.Dragging == 102 || this.Dragging == 104 || this.Dragging == 108) {
                this.paintThumb(graphics_Arg, false, this.TheRight_Polygon, MetalLookAndFeel.getPrimaryControlShadow(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControl());
            } else if (this.MouseUnder == 201) {
                this.paintThumb(graphics_Arg, false, this.TheRight_Polygon, MetalLookAndFeel.getControlShadow(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
            } else {
                this.paintThumb(graphics_Arg, false, this.TheRight_Polygon, MetalLookAndFeel.getControl(), MetalLookAndFeel.getControlShadow(), MetalLookAndFeel.getControlHighlight());
            }
        } else {
            Graphics2.setColor(SystemColor.control);
            if (this.Dragging == 101 || this.Dragging == 103 || this.Dragging == 107) {
                Graphics2.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else if (this.MouseUnder == 202) {
                Graphics2.setColor(MetalLookAndFeel.getControlHighlight());
            }
            Graphics2.fillPolygon(this.TheLeft_Polygon);
            Graphics2.setColor(SystemColor.control);
            if (this.Dragging == 102 || this.Dragging == 104 || this.Dragging == 108) {
                Graphics2.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else if (this.MouseUnder == 201) {
                Graphics2.setColor(MetalLookAndFeel.getControlHighlight());
            }
            Graphics2.fillPolygon(this.TheRight_Polygon);
            Graphics2.setColor(SystemColor.control.brighter());
            Graphics2.drawLine(this.TheLeft_Polygon.xpoints[0] + 1, this.TheLeft_Polygon.ypoints[0] + 2, this.TheLeft_Polygon.xpoints[2] + 1, this.TheLeft_Polygon.ypoints[2] - 1);
            Graphics2.drawLine(this.TheRight_Polygon.xpoints[0] + 1, this.TheRight_Polygon.ypoints[0] + 1, this.TheRight_Polygon.xpoints[1] - 1, this.TheRight_Polygon.ypoints[1] + 1);
            Graphics2.setColor(SystemColor.control.darker());
            Graphics2.drawLine(this.TheLeft_Polygon.xpoints[1] - 2, this.TheLeft_Polygon.ypoints[1] - 1, this.TheLeft_Polygon.xpoints[2] + 1, this.TheLeft_Polygon.ypoints[2] - 1);
            Graphics2.drawLine(this.TheRight_Polygon.xpoints[1] - 1, this.TheRight_Polygon.ypoints[1] + 1, this.TheRight_Polygon.xpoints[2] - 1, this.TheRight_Polygon.ypoints[2] - 1);
            if (this.MouseUnder == 203) {
                Rectangle Rect1 = this.TheRight_Polygon.getBounds();
                Rectangle Rect2 = this.TheLeft_Polygon.getBounds();
                Rectangle2D Rectangle2D1 = Rect1.createUnion(Rect2);
                Graphics2.draw(Rectangle2D1);
            } else if (this.MouseUnder == 202) {
                Graphics2.setColor(SystemColor.control.darker().darker());
                Graphics2.drawLine(this.TheLeft_Polygon.xpoints[0] + 1, this.TheLeft_Polygon.ypoints[0] + 2, this.TheLeft_Polygon.xpoints[2] + 1, this.TheLeft_Polygon.ypoints[2] - 1);
                Graphics2.setColor(SystemColor.control);
                Graphics2.drawLine(this.TheLeft_Polygon.xpoints[1] - 2, this.TheLeft_Polygon.ypoints[1] - 1, this.TheLeft_Polygon.xpoints[2] + 1, this.TheLeft_Polygon.ypoints[2] - 1);
            } else if (this.MouseUnder == 201) {
                Graphics2.setColor(SystemColor.control.darker().darker());
                Graphics2.drawLine(this.TheRight_Polygon.xpoints[0] + 1, this.TheRight_Polygon.ypoints[0] + 1, this.TheRight_Polygon.xpoints[1] - 1, this.TheRight_Polygon.ypoints[1] + 1);
                Graphics2.setColor(SystemColor.control);
                Graphics2.drawLine(this.TheRight_Polygon.xpoints[1] - 1, this.TheRight_Polygon.ypoints[1] + 1, this.TheRight_Polygon.xpoints[2] - 1, this.TheRight_Polygon.ypoints[2] - 1);
            }
            Graphics2.setColor(Color.BLACK);
            Graphics2.drawPolygon(this.TheLeft_Polygon);
            Graphics2.drawPolygon(this.TheRight_Polygon);
        }
    }

    private void paintShadowedDots(Graphics g, int[] xCoords, int[] yCoords, int num, Color DarkColor_Arg, Color BrightColor_Arg) {
        for (int s = 0; s < 2; ++s) {
            g.setColor(s == 0 ? BrightColor_Arg : DarkColor_Arg);
            for (int i = 0; i < num; ++i) {
                g.drawLine(xCoords[i] + s, yCoords[i] + s, xCoords[i] + s, yCoords[i] + s);
            }
        }
    }

    private void paintThumb(Graphics graphics_Arg, boolean up, Polygon Thumb_Arg, Color MainColor_Arg, Color DarkColor_Arg, Color BrightColor_Arg) {
        Graphics2D G2 = (Graphics2D)graphics_Arg;
        if (UIManager.getLookAndFeel().getName().equals("Metal") && MetalLookAndFeel.getCurrentTheme().getName().equals("Ocean")) {
            Object BackColor = null;
            Object SliderBackColor = UIManager.getLookAndFeel().getDefaults().get("Slider.gradient");
            if (SliderBackColor != null && SliderBackColor instanceof List) {
                List GradientProperties = (List)SliderBackColor;
                Float Cut1 = (Float)GradientProperties.get(0);
                Float Cut2 = (Float)GradientProperties.get(1);
                Color Color1 = (Color)GradientProperties.get(2);
                Color Color2 = (Color)GradientProperties.get(3);
                Color Color3 = (Color)GradientProperties.get(4);
                float Rem = 1.0f - Cut2.floatValue() - 2.0f * Cut1.floatValue();
                int x1 = up ? Thumb_Arg.xpoints[0] : Thumb_Arg.xpoints[6];
                int y1 = up ? Thumb_Arg.ypoints[0] : Thumb_Arg.ypoints[6];
                int x2 = up ? Thumb_Arg.xpoints[1] : Thumb_Arg.xpoints[5];
                int y2 = up ? Thumb_Arg.ypoints[1] : Thumb_Arg.ypoints[5];
                Shape Shape0 = G2.getClip();
                G2.setClip(Thumb_Arg);
                if (up) {
                    GradientPaint GradientPaint1 = new GradientPaint(x1 - 7, y1, Color3, x1, y1 + (int)(16.0f * Rem), Color1);
                    GradientPaint GradientPaint2 = new GradientPaint(x1, y1 + (int)(16.0f * Rem), Color1, x1, y1 + (int)(16.0f * (Rem + Cut1.floatValue())), Color2);
                    GradientPaint GradientPaint3 = new GradientPaint(x1, y1 + (int)(16.0f * (Rem + Cut1.floatValue() + Cut2.floatValue())), Color2, x1, y1 + 16, Color3);
                    G2.setPaint(GradientPaint1);
                    G2.fillRect(x1 - 7, y1, 15, (int)(16.0f * Rem));
                    G2.setPaint(GradientPaint2);
                    G2.fillRect(x1 - 7, y1 + (int)(16.0f * Rem), 15, (int)(16.0f * Cut1.floatValue()) + 1);
                    G2.setColor(Color2);
                    G2.fillRect(x1 - 7, y1 + (int)(16.0f * (Rem + Cut1.floatValue())), 15, (int)(16.0f * Cut2.floatValue()) + 1);
                    G2.setPaint(GradientPaint3);
                    G2.fillRect(x1 - 7, y1 + (int)(16.0f * (Rem + Cut1.floatValue() + Cut2.floatValue())), 15, (int)(16.0f * Cut1.floatValue()) + 1);
                } else {
                    GradientPaint GradientPaint1 = new GradientPaint(x1 - 7, y1, Color3, x1, y1 - (int)(16.0f * Rem), Color1);
                    GradientPaint GradientPaint2 = new GradientPaint(x1, y1 - (int)(16.0f * Rem), Color1, x1, y1 - (int)(16.0f * (Rem + Cut1.floatValue())), Color2);
                    GradientPaint GradientPaint3 = new GradientPaint(x1, y1 - (int)(16.0f * (Rem + Cut1.floatValue() + Cut2.floatValue())), Color2, x1, y1 - 16, Color3);
                    G2.setPaint(GradientPaint1);
                    G2.fillRect(x1 - 7, y1 - (int)(16.0f * Rem), 15, (int)(16.0f * Rem));
                    G2.setPaint(GradientPaint2);
                    G2.fillRect(x1 - 7, y1 - (int)(16.0f * (Rem + Cut1.floatValue())), 15, (int)(16.0f * Cut1.floatValue()) + 1);
                    G2.setColor(Color2);
                    G2.fillRect(x1 - 7, y1 - (int)(16.0f * (Rem + Cut1.floatValue() + Cut2.floatValue())), 15, (int)(16.0f * Cut2.floatValue()) + 1);
                    G2.setPaint(GradientPaint3);
                    G2.fillRect(x1 - 7, y1 - 16, 15, (int)(16.0f * Cut1.floatValue()) + 1);
                }
                G2.setClip(Shape0);
            }
        } else {
            G2.setColor(new Color(MainColor_Arg.getRed(), MainColor_Arg.getGreen(), MainColor_Arg.getBlue(), 196));
            G2.fillPolygon(Thumb_Arg);
        }
        G2.setColor(Color.BLACK);
        G2.drawPolygon(Thumb_Arg);
        int yy = up ? Thumb_Arg.ypoints[0] + 8 : Thumb_Arg.ypoints[6] - 13;
        int xx = up ? Thumb_Arg.xpoints[0] : Thumb_Arg.xpoints[6];
        int[] xp = new int[]{xx - 5, xx - 1, xx + 3, xx - 3, xx + 1, xx - 5, xx - 1, xx + 3};
        int[] yp = new int[]{yy, yy, yy, yy + 2, yy + 2, yy + 4, yy + 4, yy + 4};
        this.paintShadowedDots(G2, xp, yp, 8, DarkColor_Arg, BrightColor_Arg);
    }

    public void mousePressed(MouseEvent MouseEvent_Arg) {
        this.LastFiveEvents = new Vector();
        this.LastFiveEvents.add(MouseEvent_Arg.getPoint());
        if (this.JTextFieldMin.isVisible()) {
            this.JTextFieldMin.postActionEvent();
            while (this.JTextFieldMin.getActionListeners().length > 0) {
                this.JTextFieldMin.removeActionListener(this.JTextFieldMin.getActionListeners()[0]);
            }
            this.JTextFieldMin.setVisible(false);
            this.Ctrl.requestFocus();
        }
        if (this.JTextFieldMax.isVisible()) {
            this.JTextFieldMax.postActionEvent();
            while (this.JTextFieldMax.getActionListeners().length > 0) {
                this.JTextFieldMax.removeActionListener(this.JTextFieldMax.getActionListeners()[0]);
            }
            this.JTextFieldMax.setVisible(false);
            this.Ctrl.requestFocus();
        }
        if (this.Ctrl.isPrecise() && MouseEvent_Arg.getButton() == 1 && MouseEvent_Arg.getClickCount() > 1 && this.TheLeft_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY())) {
            this.openPrecisionPopup(202, new Point(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()));
            return;
        }
        if (this.Ctrl.isPrecise() && MouseEvent_Arg.getButton() == 1 && MouseEvent_Arg.getClickCount() > 1 && this.TheRight_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY())) {
            this.openPrecisionPopup(201, new Point(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()));
            return;
        }
        if (this.RectFirstLabel != null && MouseEvent_Arg.getClickCount() == 1 && MouseEvent_Arg.getButton() == 1 && this.RectFirstLabel.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) && MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 110;
        } else if (this.RectFirstLabel != null && MouseEvent_Arg.getClickCount() == 1 && MouseEvent_Arg.getButton() == 1 && this.RectFirstLabel.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) && !MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 109;
        } else if (this.TheLeft_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) && MouseEvent_Arg.getButton() == 1 && !MouseEvent_Arg.isAltDown() && !MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 101;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else if (this.TheLeft_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) && MouseEvent_Arg.getButton() == 1 && !MouseEvent_Arg.isAltDown() && MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 103;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else if (this.TheRight_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) && MouseEvent_Arg.getButton() == 1 && !MouseEvent_Arg.isAltDown() && !MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 102;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else if (this.TheRight_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) && MouseEvent_Arg.getButton() == 1 && !MouseEvent_Arg.isAltDown() && MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 104;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else if (MouseEvent_Arg.getX() > this.LeftValue && MouseEvent_Arg.getButton() == 1 && MouseEvent_Arg.getX() < this.RightValue && MouseEvent_Arg.getY() > this.Margin_Ruler_Top && MouseEvent_Arg.getY() < this.Margin_Ruler_Top + this.RulerHeight && !MouseEvent_Arg.isAltDown() && !MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 105;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else if (MouseEvent_Arg.getX() > this.LeftValue && MouseEvent_Arg.getButton() == 1 && MouseEvent_Arg.getX() < this.RightValue && MouseEvent_Arg.getY() > this.Margin_Ruler_Top && MouseEvent_Arg.getY() < this.Margin_Ruler_Top + this.RulerHeight && !MouseEvent_Arg.isAltDown() && MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 106;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else if (this.TheRight_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) && MouseEvent_Arg.getButton() == 1 && MouseEvent_Arg.isAltDown()) {
            this.Dragging = 108;
            this.Center = (this.Ctrl.getMinimumColoredValue() + this.Ctrl.getMaximumColoredValue()) / 2;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else if (this.TheLeft_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) && MouseEvent_Arg.getButton() == 1 && MouseEvent_Arg.isAltDown()) {
            this.Dragging = 107;
            this.Center = (this.Ctrl.getMinimumColoredValue() + this.Ctrl.getMaximumColoredValue()) / 2;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else if (MouseEvent_Arg.isShiftDown() && MouseEvent_Arg.getButton() == 1 && MouseEvent_Arg.getClickCount() > 1 && MouseEvent_Arg.getX() > 10 && MouseEvent_Arg.getX() < 10 + this.RulerWidth && MouseEvent_Arg.getY() > this.Margin_Ruler_Top && MouseEvent_Arg.getY() < this.Margin_Ruler_Top + this.RulerHeight) {
            int d1 = MouseEvent_Arg.getX() - 10;
            int GraduationCount = (int)Math.floor((double)d1 / this.GraduationWidth);
            double Min = this.Ctrl.getMinimumValue() + (double)((float)((double)GraduationCount * this.GraduationWidth * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth));
            double Max = this.Ctrl.getMinimumValue() + (double)((float)((double)(GraduationCount + 1) * this.GraduationWidth * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth));
            if (Max > this.Ctrl.getMaximumValue()) {
                Max = this.Ctrl.getMaximumValue();
            }
            if (Min < (double)this.Ctrl.getMinimumColoredValue()) {
                this.Ctrl.setColoredValues((int)Min, this.Ctrl.getMaximumColoredValue());
            } else if (Max > (double)this.Ctrl.getMaximumColoredValue()) {
                this.Ctrl.setColoredValues(this.Ctrl.getMinimumColoredValue(), (int)Max);
            }
            this.Dragging = 106;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else if (MouseEvent_Arg.getClickCount() > 1 && MouseEvent_Arg.getButton() == 1 && MouseEvent_Arg.getX() > 10 && MouseEvent_Arg.getX() < 10 + this.RulerWidth && MouseEvent_Arg.getY() > this.Margin_Ruler_Top && MouseEvent_Arg.getY() < this.Margin_Ruler_Top + this.RulerHeight) {
            int d1 = MouseEvent_Arg.getX() - 10;
            int GraduationCount = (int)Math.floor((double)d1 / this.GraduationWidth);
            int Min = (int)(this.Ctrl.getMinimumValue() + (double)((float)((double)GraduationCount * this.GraduationWidth * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth)));
            int Max = (int)(this.Ctrl.getMinimumValue() + (double)((float)((double)(GraduationCount + 1) * this.GraduationWidth * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth)));
            if ((double)Max > this.Ctrl.getMaximumValue()) {
                Max = (int)this.Ctrl.getMaximumValue();
            }
            this.Ctrl.setColoredValues(Min, Max);
            this.Dragging = 105;
            this.DeplBef = MouseEvent_Arg.getX() - this.LeftValue;
            this.DeplAft = this.RightValue - MouseEvent_Arg.getX();
            this.JComponent1.repaint();
        } else {
            return;
        }
        MouseEvent_Arg.consume();
    }

    public void mouseDragged(MouseEvent MouseEvent_Arg) {
        if (this.LastFiveEvents.elementAt((int)0).x != MouseEvent_Arg.getX() || this.LastFiveEvents.elementAt((int)0).y != MouseEvent_Arg.getY()) {
            this.LastFiveEvents.add(0, (Point)MouseEvent_Arg.getPoint().clone());
        }
        if (this.LastFiveEvents.size() > 5) {
            this.LastFiveEvents.removeElementAt(5);
        }
        if (MouseEvent_Arg.getX() > this.JComponent1.getSize().width) {
            MouseEvent_Arg.translatePoint(this.JComponent1.getSize().width - MouseEvent_Arg.getX(), 0);
        }
        if (MouseEvent_Arg.getX() < 0) {
            MouseEvent_Arg.translatePoint(MouseEvent_Arg.getX(), 0);
        }
        if (MouseEvent_Arg.getY() > this.JComponent1.getSize().height) {
            MouseEvent_Arg.translatePoint(0, this.JComponent1.getSize().height - MouseEvent_Arg.getY());
        }
        if (MouseEvent_Arg.getY() < 0) {
            MouseEvent_Arg.translatePoint(0, MouseEvent_Arg.getY());
        }
        int MouseX = MouseEvent_Arg.getX();
        if (this.Dragging == 101 && MouseEvent_Arg.isAltDown()) {
            this.Dragging = 107;
            this.Center = (this.Ctrl.getMinimumColoredValue() + this.Ctrl.getMaximumColoredValue()) / 2;
        }
        if (this.Dragging == 102 && MouseEvent_Arg.isAltDown()) {
            this.Dragging = 108;
            this.Center = (this.Ctrl.getMinimumColoredValue() + this.Ctrl.getMaximumColoredValue()) / 2;
        }
        if (this.Dragging == 101 && MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 103;
        }
        if (this.Dragging == 102 && MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 104;
        }
        if (this.Dragging == 106 && !MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 105;
        }
        if (this.Dragging == 105 && MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 106;
        }
        if (this.Dragging == 109 && MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 110;
        }
        if (this.Dragging == 110 && !MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 109;
        }
        if (this.Dragging == 107 && !MouseEvent_Arg.isAltDown()) {
            this.Dragging = 101;
        }
        if (this.Dragging == 108 && !MouseEvent_Arg.isAltDown()) {
            this.Dragging = 102;
        }
        if (this.Dragging == 103 && !MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 101;
        }
        if (this.Dragging == 104 && !MouseEvent_Arg.isShiftDown()) {
            this.Dragging = 102;
        }
        if (this.Dragging == 109) {
            double SegSize = (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) * (double)(MouseX - 10) / (double)this.RulerWidth;
            if ((SegSize = Math.min(SegSize, this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue())) > 0.0) {
                this.Ctrl.setSegmentSize(SegSize);
            }
        } else if (this.Dragging == 110) {
            double SegSize = Math.round((this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) * (double)(MouseX - 10) / (double)this.RulerWidth);
            if (SegSize > 0.0 && SegSize < this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) {
                this.Ctrl.setSegmentSize(SegSize);
            }
        } else if (this.Dragging == 107) {
            int NewValue = (int)(this.Ctrl.getMinimumValue() + (double)(MouseX - this.DeplBef - 10) * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth);
            if (NewValue > this.Center) {
                NewValue = this.Center;
            }
            if ((double)NewValue < this.Ctrl.getMinimumValue()) {
                NewValue = (int)this.Ctrl.getMinimumValue();
            }
            if ((double)(this.Center * 2 - NewValue) > this.Ctrl.getMaximumValue()) {
                NewValue = (int)((double)(2 * this.Center) - this.Ctrl.getMaximumValue());
            }
            this.Ctrl.setColoredValues(NewValue, 2 * this.Center - NewValue);
            this.JComponent1.repaint();
        } else if (this.Dragging == 108) {
            int NewValue = (int)(this.Ctrl.getMinimumValue() + (double)(MouseX + this.DeplAft - 10) * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth);
            if (NewValue < this.Center) {
                NewValue = this.Center;
            }
            if ((double)NewValue > this.Ctrl.getMaximumValue()) {
                NewValue = (int)this.Ctrl.getMaximumValue();
            }
            if ((double)(this.Center * 2 - NewValue) < this.Ctrl.getMinimumValue()) {
                NewValue = (int)((double)(2 * this.Center) - this.Ctrl.getMinimumValue());
            }
            this.Ctrl.setColoredValues(this.Center * 2 - NewValue, NewValue);
            this.JComponent1.repaint();
        } else if (this.Dragging == 101) {
            if (this.Ctrl.isPrecise() && this.isLastFiveEventsUpDown()) {
                this.openPrecisionPopup(202, new Point(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()));
                return;
            }
            if (MouseX - this.DeplBef > this.RightValue) {
                this.Ctrl.setColoredValues(this.Ctrl.getMaximumColoredValue(), this.Ctrl.getMaximumColoredValue());
                this.JComponent1.repaint();
                return;
            }
            if (MouseX - this.DeplBef < 10) {
                this.Ctrl.setColoredValues((int)this.Ctrl.getMinimumValue(), this.Ctrl.getMaximumColoredValue());
                this.JComponent1.repaint();
                return;
            }
            double NewMinValue = this.Ctrl.getMinimumValue() + (double)(MouseX - this.DeplBef - 10) * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth;
            NewMinValue = Math.min(NewMinValue, (double)this.Ctrl.getMaximumColoredValue());
            this.Ctrl.setColoredValues((int)NewMinValue, this.Ctrl.getMaximumColoredValue());
            this.JComponent1.repaint();
        } else if (this.Dragging == 103) {
            double Size = this.Ctrl.getMaximumColoredValue() - this.Ctrl.getMinimumColoredValue();
            if (MouseX - this.DeplBef > this.RightValue) {
                this.Ctrl.setColoredValues(this.Ctrl.getMaximumColoredValue(), this.Ctrl.getMaximumColoredValue());
                this.JComponent1.repaint();
                return;
            }
            if (MouseX - this.DeplBef < 10) {
                this.Ctrl.setColoredValues((int)this.Ctrl.getMinimumValue(), this.Ctrl.getMaximumColoredValue());
                this.JComponent1.repaint();
                return;
            }
            double DMin = (double)(MouseX - this.DeplBef - 10) * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth;
            int NewMin = (int)Math.round(DMin / this.Ctrl.getSegmentSize());
            while (this.Ctrl.getMinimumValue() + this.Ctrl.getSegmentSize() * (double)NewMin < this.Ctrl.getMinimumValue()) {
                ++NewMin;
            }
            this.Ctrl.setColoredValues((int)this.Ctrl.getMinimumValue() + (int)(this.Ctrl.getSegmentSize() * (double)NewMin), this.Ctrl.getMaximumColoredValue());
            this.JComponent1.repaint();
        } else if (this.Dragging == 102) {
            if (this.Ctrl.isPrecise() && this.isLastFiveEventsUpDown()) {
                this.openPrecisionPopup(201, new Point(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()));
                return;
            }
            if (MouseX + this.DeplAft < this.LeftValue) {
                this.Ctrl.setColoredValues(this.Ctrl.getMinimumColoredValue(), this.Ctrl.getMinimumColoredValue());
                this.JComponent1.repaint();
                return;
            }
            if (MouseX + this.DeplAft > 10 + this.RulerWidth) {
                this.Ctrl.setColoredValues(this.Ctrl.getMinimumColoredValue(), (int)this.Ctrl.getMaximumValue());
                this.JComponent1.repaint();
                return;
            }
            double NewMaxValue = this.Ctrl.getMinimumValue() + (double)(MouseX + this.DeplAft - 10) * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth;
            NewMaxValue = Math.max(NewMaxValue, (double)this.Ctrl.getMinimumColoredValue());
            this.Ctrl.setColoredValues(this.Ctrl.getMinimumColoredValue(), (int)NewMaxValue);
            this.JComponent1.repaint();
        } else if (this.Dragging == 104) {
            double Size = this.Ctrl.getMaximumColoredValue() - this.Ctrl.getMinimumColoredValue();
            if (MouseX + this.DeplAft < this.LeftValue) {
                this.Ctrl.setColoredValues(this.Ctrl.getMinimumColoredValue(), (int)this.Ctrl.getMaximumValue());
                this.JComponent1.repaint();
                return;
            }
            if (MouseX + this.DeplAft > 10 + this.RulerWidth) {
                this.Ctrl.setColoredValues(this.Ctrl.getMinimumColoredValue(), (int)this.Ctrl.getMaximumValue());
                this.JComponent1.repaint();
                return;
            }
            double DMax = (double)(MouseX + this.DeplAft + 10) * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth;
            int NewMax = (int)Math.round(DMax / this.Ctrl.getSegmentSize());
            while (this.Ctrl.getMinimumValue() + this.Ctrl.getSegmentSize() * (double)NewMax > this.Ctrl.getMaximumValue()) {
                --NewMax;
            }
            this.Ctrl.setColoredValues(this.Ctrl.getMinimumColoredValue(), (int)(this.Ctrl.getMinimumValue() + this.Ctrl.getSegmentSize() * (double)NewMax));
            this.JComponent1.repaint();
        } else if (this.Dragging == 106) {
            double Size = this.Ctrl.getMaximumColoredValue() - this.Ctrl.getMinimumColoredValue();
            if (MouseX - this.DeplBef <= 10) {
                this.Ctrl.setColoredValues((int)this.Ctrl.getMinimumValue(), (int)(this.Ctrl.getMinimumValue() + Size));
                this.JComponent1.repaint();
                return;
            }
            if (MouseX + this.DeplAft >= 10 + this.RulerWidth) {
                this.Ctrl.setColoredValues((int)(this.Ctrl.getMaximumValue() - Size), (int)this.Ctrl.getMaximumValue());
                this.JComponent1.repaint();
                return;
            }
            double DMin = (double)(MouseX - this.DeplBef - 10) * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth;
            int NewMin = (int)Math.round(DMin / this.Ctrl.getSegmentSize());
            double MagnetEffect = this.Ctrl.getSegmentSize() * (double)NewMin - DMin;
            if (this.Ctrl.getMinimumValue() + DMin + MagnetEffect + Size > this.Ctrl.getMaximumValue()) {
                DMin = this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue() - MagnetEffect - Size;
            }
            this.Ctrl.setColoredValues((int)(this.Ctrl.getMinimumValue() + DMin + MagnetEffect), (int)(this.Ctrl.getMinimumValue() + DMin + MagnetEffect + Size));
            this.JComponent1.repaint();
        } else if (this.Dragging == 105) {
            double Size = this.Ctrl.getMaximumColoredValue() - this.Ctrl.getMinimumColoredValue();
            if (MouseX - this.DeplBef <= 10) {
                this.Ctrl.setColoredValues((int)this.Ctrl.getMinimumValue(), (int)(this.Ctrl.getMinimumValue() + Size));
                this.JComponent1.repaint();
                return;
            }
            if (MouseX + this.DeplAft >= 10 + this.RulerWidth) {
                this.Ctrl.setColoredValues((int)(this.Ctrl.getMaximumValue() - Size), (int)this.Ctrl.getMaximumValue());
                this.JComponent1.repaint();
                return;
            }
            double DMin = (double)(MouseX - this.DeplBef - 10) * (this.Ctrl.getMaximumValue() - this.Ctrl.getMinimumValue()) / (double)this.RulerWidth;
            this.Ctrl.setColoredValues((int)(this.Ctrl.getMinimumValue() + DMin), (int)(this.Ctrl.getMinimumValue() + DMin + Size));
            this.JComponent1.repaint();
        } else {
            return;
        }
        MouseEvent_Arg.consume();
    }

    public void mouseReleased(MouseEvent MouseEvent_Arg) {
        if (this.Dragging != 111 && this.Dragging != 112) {
            this.Dragging = 100;
        }
        this.JComponent1.repaint();
        this.Ctrl.setColoredValues(this.Ctrl.getMinimumColoredValue(), this.Ctrl.getMaximumColoredValue());
    }

    public void mouseMoved(MouseEvent MouseEvent_Arg) {
        int OldMouseUnder = this.MouseUnder;
        Rectangle2D OldRectangleSegment = this.RectangleSegment;
        Rectangle Rect1 = this.TheRight_Polygon.getBounds();
        Rectangle Rect2 = this.TheLeft_Polygon.getBounds();
        Rectangle2D Rectangle2D1 = Rect1.createUnion(Rect2);
        int d1 = MouseEvent_Arg.getX() - 10;
        int GraduationCount = (int)Math.floor((double)d1 / this.GraduationWidth);
        int LeftSegment = 10 + (int)((double)GraduationCount * this.GraduationWidth);
        int RightSegment = 10 + (int)((double)(GraduationCount + 1) * this.GraduationWidth);
        if (RightSegment > 10 + this.RulerWidth) {
            RightSegment = 10 + this.RulerWidth;
        }
        this.RectangleSegment = MouseEvent_Arg.getX() >= 10 && MouseEvent_Arg.getX() <= 10 + this.RulerWidth ? new Rectangle(LeftSegment + 1, this.Margin_Ruler_Top + 1, RightSegment - LeftSegment - 2, this.RulerHeight - 2) : null;
        if (MouseEvent_Arg.isShiftDown() && this.RectangleSegment != null) {
            this.RectangleSegment = Rectangle2D1.createUnion(this.RectangleSegment);
        }
        this.MouseUnder = this.TheRight_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) ? 201 : (this.TheLeft_Polygon.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) ? 202 : (Rectangle2D1.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) ? 203 : (this.RectFirstLabel != null && this.RectFirstLabel.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) ? 204 : (this.RectLastLabel != null && this.RectLastLabel.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) ? 205 : (this.RectangleSegment != null && this.RectangleSegment.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY()) ? 105 : 200)))));
        if (this.MouseUnder != OldMouseUnder) {
            this.JComponent1.repaint();
        }
        if (OldRectangleSegment != null && this.MouseUnder == 105 && !OldRectangleSegment.equals(this.RectangleSegment)) {
            this.JComponent1.repaint();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent MouseWheelEvent_Arg) {
        double min = (double)this.Ctrl.getMinimumColoredValue() - (double)MouseWheelEvent_Arg.getWheelRotation() * this.Ctrl.getSegmentSize();
        double max = (double)this.Ctrl.getMaximumColoredValue() - (double)MouseWheelEvent_Arg.getWheelRotation() * this.Ctrl.getSegmentSize();
        if (min < this.Ctrl.getMinimumValue()) {
            min = this.Ctrl.getMinimumValue();
            max = min + (double)(this.Ctrl.getMaximumColoredValue() - this.Ctrl.getMinimumColoredValue());
        }
        if (max > this.Ctrl.getMaximumValue()) {
            max = this.Ctrl.getMaximumValue();
            min = max - (double)(this.Ctrl.getMaximumColoredValue() - this.Ctrl.getMinimumColoredValue());
        }
        this.Ctrl.setColoredValues((int)min, (int)max);
    }

    private boolean isLastFiveEventsUpDown() {
        if (this.LastFiveEvents.size() > 4) {
            Point PointM0 = this.LastFiveEvents.elementAt(0);
            Point PointM1 = this.LastFiveEvents.elementAt(1);
            Point PointM2 = this.LastFiveEvents.elementAt(2);
            Point PointM3 = this.LastFiveEvents.elementAt(3);
            Point PointM4 = this.LastFiveEvents.elementAt(4);
            int D1x = PointM0.x - PointM1.x;
            int D1y = PointM0.y - PointM1.y;
            int D2x = PointM0.x - PointM2.x;
            int D2y = PointM0.y - PointM2.y;
            int D3x = PointM0.x - PointM3.x;
            int D3y = PointM0.y - PointM3.y;
            int D4x = PointM0.x - PointM4.x;
            int D4y = PointM0.y - PointM4.y;
            return Math.abs(D1x) < 2 && Math.abs(D1y) > 5 || Math.abs(D2x) < 2 && Math.abs(D2y) > 5 || Math.abs(D3x) < 2 && Math.abs(D3y) > 5 || Math.abs(D4x) < 2 && Math.abs(D4y) > 5;
        }
        return false;
    }

    private void openPrecisionPopup(int Thumb_Arg, Point Point_Arg) {
        this.JSlider1.setValue(0);
        this.JLabel1.setBackground(this.Ctrl.getBackground());
        this.JLabel1.setForeground(this.Ctrl.getForeground());
        this.JSlider1.setBackground(this.Ctrl.getSliderBackground());
        Hashtable Hashtable1 = new Hashtable();
        double MiddleVal = this.Ctrl.getMinimumColoredValue();
        if (Thumb_Arg == 201) {
            MiddleVal = this.Ctrl.getMaximumColoredValue();
        }
        double Amplitude = this.Ctrl.getSegmentSize() / (double)this.Ctrl.getSegmentCount();
        if (Thumb_Arg == 201 && MiddleVal - Amplitude < (double)this.Ctrl.getMinimumColoredValue()) {
            MiddleVal = (double)this.Ctrl.getMinimumColoredValue() + Amplitude;
        } else if (Thumb_Arg == 202 && MiddleVal + Amplitude > (double)this.Ctrl.getMaximumColoredValue()) {
            MiddleVal = (double)this.Ctrl.getMaximumColoredValue() - Amplitude;
        } else if (MiddleVal - Amplitude < this.Ctrl.getMinimumValue()) {
            MiddleVal = this.Ctrl.getMinimumValue() + Amplitude;
        } else if (MiddleVal + Amplitude > this.Ctrl.getMaximumValue()) {
            MiddleVal = this.Ctrl.getMaximumValue() - Amplitude;
        }
        for (int i = -100; i <= 100; i += 20) {
            double Val = 0.0;
            Val = MiddleVal + (double)i / 100.0 * Amplitude;
        }
        this.JSlider1.setLabelTable(Hashtable1);
        this.JSlider1.validate();
        PopupFactory PopupFactory1 = PopupFactory.getSharedInstance();
        Point Point1 = (Point)Point_Arg.clone();
        SwingUtilities.convertPointToScreen(Point1, this.Ctrl);
        if (Thumb_Arg == 201) {
            this.JLabel1.setText("");
        } else if (Thumb_Arg == 202) {
            this.JLabel1.setText("");
        }
        Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int CenteredY = Point1.y - this.JSlider1.getPreferredSize().height / 2;
        if (CenteredY + this.JPanel1.getPreferredSize().height > ScreenSize.height) {
            CenteredY = ScreenSize.height - this.JPanel1.getPreferredSize().height;
        }
        if (CenteredY < 0) {
            CenteredY = 0;
        }
        final Popup Popup1 = PopupFactory1.getPopup(this.Ctrl, this.JPanel1, Point1.x - 8, CenteredY);
        Popup1.show();
        this.JSlider1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent MouseEvent_Arg) {
                Popup1.hide();
                BiSliderPresentation.this.JSlider1.removeMouseListener(this);
                double MiddleVal = BiSliderPresentation.this.PreciseOpenedValue;
                double Amplitude = BiSliderPresentation.this.Ctrl.getSegmentSize() / (double)BiSliderPresentation.this.Ctrl.getSegmentCount();
                if (BiSliderPresentation.this.Dragging == 112 && MiddleVal - Amplitude < (double)BiSliderPresentation.this.Ctrl.getMinimumColoredValue()) {
                    MiddleVal = (double)BiSliderPresentation.this.Ctrl.getMinimumColoredValue() + Amplitude;
                } else if (BiSliderPresentation.this.Dragging == 111 && MiddleVal + Amplitude > (double)BiSliderPresentation.this.Ctrl.getMaximumColoredValue()) {
                    MiddleVal = (double)BiSliderPresentation.this.Ctrl.getMaximumColoredValue() - Amplitude;
                } else if (MiddleVal - Amplitude < BiSliderPresentation.this.Ctrl.getMinimumValue()) {
                    MiddleVal = BiSliderPresentation.this.Ctrl.getMinimumValue() + Amplitude;
                } else if (MiddleVal + Amplitude > BiSliderPresentation.this.Ctrl.getMaximumValue()) {
                    MiddleVal = BiSliderPresentation.this.Ctrl.getMaximumValue() - Amplitude;
                }
                double Val = MiddleVal + (double)BiSliderPresentation.this.JSlider1.getValue() / 100.0 * Amplitude;
                if (BiSliderPresentation.this.Dragging == 112) {
                    BiSliderPresentation.this.Ctrl.setMaximumColoredValue((int)Val);
                } else if (BiSliderPresentation.this.Dragging == 111) {
                    BiSliderPresentation.this.Ctrl.setMinimumColoredValue((int)Val);
                }
                BiSliderPresentation.this.Ctrl.repaint();
            }
        });
        try {
            Robot Robot1 = new Robot();
            Robot1.mouseRelease(16);
            Robot1.mouseMove(Point1.x, CenteredY + this.JSlider1.getPreferredSize().height / 2);
            Robot1.mousePress(16);
        }
        catch (AWTException AWTException_Arg) {
            AWTException_Arg.printStackTrace();
        }
        if (Thumb_Arg == 201) {
            this.Dragging = 112;
            this.PreciseOpenedValue = this.Ctrl.getMaximumColoredValue();
        } else if (Thumb_Arg == 202) {
            this.Dragging = 111;
            this.PreciseOpenedValue = this.Ctrl.getMinimumColoredValue();
        }
    }

    public void componentResized(ComponentEvent ComponentEvent_Arg) {
        this.RulerHeight = this.Ctrl.getHeight() - this.Margin_Ruler_Top - 3;
        this.Ctrl.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    protected void changeMinValue(String NewValue_Arg) {
        if (!this.Ctrl.getUnit().equals("alpha")) {
            try {
                double NV = Double.parseDouble(NewValue_Arg);
                if (NV < this.Ctrl.getMaximumValue()) {
                    this.Ctrl.setMinimumValue((int)NV);
                }
                this.JComponent1.repaint();
            }
            catch (Exception Exception_Arg) {
                Exception_Arg.printStackTrace();
            }
        } else {
            double NV = NewValue_Arg.toUpperCase().charAt(0) - 65;
            if (NV < this.Ctrl.getMaximumValue()) {
                this.Ctrl.setMinimumValue((int)NV);
                this.Ctrl.setSegmentSize(1.0);
            }
        }
        this.Ctrl.requestFocus();
    }

    protected void changeMaxValue(String NewValue_Arg) {
        if (!this.Ctrl.getUnit().equals("alpha")) {
            try {
                double NV = Double.parseDouble(NewValue_Arg);
                if (NV > this.Ctrl.getMinimumValue()) {
                    this.Ctrl.setMaximumValue((int)NV);
                }
                this.JComponent1.repaint();
            }
            catch (Exception Exception_Arg) {
                Exception_Arg.printStackTrace();
            }
        } else {
            double NV = NewValue_Arg.toUpperCase().charAt(0) - 65;
            if (NV > this.Ctrl.getMinimumValue()) {
                this.Ctrl.setMaximumValue((int)NV);
            }
        }
        this.Ctrl.requestFocus();
    }

    public void mouseClicked(MouseEvent MouseEvent_Arg) {
        String Unit = this.Ctrl.getUnit();
        if (MouseEvent_Arg.getClickCount() > 1 && this.RectFirstLabel.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY())) {
            this.Dragging = 100;
            String Text = "" + this.Ctrl.getMinimumValue();
            if (Unit.equals("alpha")) {
                Text = "" + (char)((int)this.Ctrl.getMinimumValue() + 65);
            } else if (this.Ctrl.getMinimumValue() == (double)((int)this.Ctrl.getMinimumValue())) {
                Text = "" + this.Ctrl.getMinimumValue();
            }
            this.JTextFieldMin.setText(Text);
            this.JTextFieldMin.setLocation(10, 0);
            this.JTextFieldMin.setSize(this.JTextFieldMin.getPreferredSize().width + 10, this.JTextFieldMin.getPreferredSize().height);
            this.JTextFieldMin.setVisible(true);
            this.JTextFieldMin.requestFocus();
            this.JTextFieldMin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    while (BiSliderPresentation.this.JTextFieldMin.getActionListeners().length > 0) {
                        BiSliderPresentation.this.JTextFieldMin.removeActionListener(BiSliderPresentation.this.JTextFieldMin.getActionListeners()[0]);
                    }
                    BiSliderPresentation.this.changeMinValue(BiSliderPresentation.this.JTextFieldMin.getText());
                    BiSliderPresentation.this.JTextFieldMin.setVisible(false);
                }
            });
            this.JComponent1.repaint();
        } else if (MouseEvent_Arg.getClickCount() > 1 && this.RectLastLabel.contains(MouseEvent_Arg.getX(), MouseEvent_Arg.getY())) {
            this.Dragging = 100;
            String Text = "" + this.Ctrl.getMaximumValue();
            if (Unit.equals("alpha")) {
                Text = "" + (char)((int)this.Ctrl.getMaximumValue() + 65);
            } else if (this.Ctrl.getMaximumValue() == (double)((int)this.Ctrl.getMaximumValue())) {
                Text = "" + (int)this.Ctrl.getMaximumValue();
            }
            this.JTextFieldMax.setText(Text);
            this.JTextFieldMax.setLocation(this.JComponent1.getWidth() - this.JTextFieldMax.getPreferredSize().width - 10 - 10, 0);
            this.JTextFieldMax.setSize(this.JTextFieldMax.getPreferredSize().width + 10, this.JTextFieldMax.getPreferredSize().height);
            this.JTextFieldMax.setVisible(true);
            this.JTextFieldMax.requestFocus();
            this.JTextFieldMax.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    while (BiSliderPresentation.this.JTextFieldMax.getActionListeners().length > 0) {
                        BiSliderPresentation.this.JTextFieldMax.removeActionListener(BiSliderPresentation.this.JTextFieldMax.getActionListeners()[0]);
                    }
                    BiSliderPresentation.this.changeMaxValue(BiSliderPresentation.this.JTextFieldMax.getText());
                    BiSliderPresentation.this.JTextFieldMax.setVisible(false);
                }
            });
        } else {
            return;
        }
        MouseEvent_Arg.consume();
    }

    public void mouseEntered(MouseEvent MouseEvent_Arg) {
    }

    public void mouseExited(MouseEvent MouseEvent_Arg) {
        this.MouseUnder = 200;
        this.JComponent1.repaint();
    }
}

