/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import javalain.algorithmegenetique.Genome;
import javalain.algorithmegenetique.ParametreAG;
import javalain.algorithmegenetique.genome.GenomeFct;
import javalain.ea.EnsembleSolutionEA;
import javalain.ea.operator.Ranking_NSGAII;
import javalain.ea.operator.comparator.CrowdingComparator_NSGAII;
import javalain.ea.operator.comparator.CrowdingDistanceComparator;

public class Population
implements Serializable {
    private Genome[] tabGenome;
    private int nbGenome;
    private int nbGenomeInitial;
    private Genome pere;
    private ParametreAG paramAG;
    private boolean estInitialisee;
    private double noteMax;
    private double noteMin;
    private double noteMoyenne;
    private int positionMax;
    private boolean enrgStat;
    private int lgStat;
    private int indiceStat;
    private double[] statMax;
    private double[] statMoyenne;
    private long[] temps = new long[7];
    private String algorithme;
    private double tauxMutation;
    private double tauxCroisement;
    private int selection;
    private int nbPartTournoi;
    private boolean scaling;
    private boolean sharing;
    private double alpha;
    private double sigmashare;
    private boolean crowding;
    private boolean croisementRestreint;
    private boolean elitisme;
    private int nbMeilleurs;
    private int remplacement;
    private int nbOverlap;
    private int tdom;
    private double marge;
    private double ecart;

    public Population(Genome g, int nbG, ParametreAG p) {
        if (nbG <= 0) {
            throw new IllegalArgumentException("Population, Population (Genome g, int nbG, ParametreAG p) : la taille initiale de la population doit \u00eatre > 0.");
        }
        this.nbGenomeInitial = nbG;
        this.tabGenome = new Genome[nbG];
        this.pere = g;
        this.paramAG = p;
        this.nbGenome = 0;
        this.estInitialisee = false;
        this.enrgStat = false;
    }

    public synchronized void initialise() {
        int i;
        this.nbGenome = 0;
        for (i = 0; i < this.nbGenomeInitial; ++i) {
            this.add(this.pere.creer());
        }
        for (i = 0; i < this.nbGenomeInitial; ++i) {
            this.tabGenome[i].fitness();
        }
        this.statistique();
        this.estInitialisee = true;
        this.updateParametreAG();
        if (this.algorithme.equals("Nondominated Sorting GA 2")) {
            GenomeFct[] tabFct = new GenomeFct[this.nbGenome];
            System.arraycopy(this.tabGenome, 0, tabFct, 0, this.nbGenome);
            Ranking_NSGAII rk = new Ranking_NSGAII(tabFct);
            for (int i2 = 0; i2 < rk.getNbFrontsPareto(); ++i2) {
                rk.getFront(i2).crowdingDistance();
            }
        }
    }

    public void setParametreAG(ParametreAG p) {
        this.paramAG = p;
    }

    public ParametreAG getParametreAG() {
        return this.paramAG;
    }

    private void updateParametreAG() {
        this.algorithme = this.paramAG.getAlgorithme();
        this.tauxMutation = this.paramAG.getTauxMutation();
        this.tauxCroisement = this.paramAG.getTauxCroisement();
        this.selection = this.paramAG.getSelection();
        this.nbPartTournoi = this.paramAG.getNbPartTournoi();
        this.scaling = this.paramAG.getScaling();
        this.sharing = this.paramAG.getSharing();
        this.alpha = this.paramAG.getAlpha();
        this.sigmashare = this.paramAG.getSigmaShare();
        this.crowding = this.paramAG.getCrowding();
        this.croisementRestreint = this.paramAG.getCroisementRestreint();
        this.elitisme = this.paramAG.getElitisme();
        this.nbMeilleurs = this.paramAG.getNbMeilleurs();
        this.remplacement = this.paramAG.getRemplacement();
        this.nbOverlap = this.paramAG.getNbOverlap();
        this.tdom = this.paramAG.getTdom();
    }

    public synchronized void addIndividu() {
        int taille = this.tabGenome.length;
        if (this.nbGenome == taille) {
            int n_taille = taille * 105 / 100 + 1;
            Genome[] tab = this.tabGenome;
            this.tabGenome = new Genome[n_taille];
            System.arraycopy(tab, 0, this.tabGenome, 0, taille);
        }
        Genome g = this.pere.creer();
        g.population = this;
        this.tabGenome[this.nbGenome++] = g;
        g.fitness();
    }

    public synchronized void addIndividu(Genome g) {
        if (this.nbGenome != 0 && !this.pere.getClass().isInstance(g)) {
            throw new IllegalArgumentException("Population, addIndividu (Genome g) : tous les genomes doivent etre de meme type.");
        }
        int taille = this.tabGenome.length;
        if (this.nbGenome == taille) {
            int n_taille = taille * 105 / 100 + 1;
            Genome[] tab = this.tabGenome;
            this.tabGenome = new Genome[n_taille];
            System.arraycopy(tab, 0, this.tabGenome, 0, taille);
        }
        g.population = this;
        this.tabGenome[this.nbGenome++] = g;
        g.fitness();
    }

    private void add(Genome g) {
        g.population = this;
        this.tabGenome[this.nbGenome++] = g;
    }

    public synchronized Genome getIndividu(int i) {
        if (i > this.nbGenome || i < 0) {
            throw new IndexOutOfBoundsException("Population, getGenome (int i) : indice 'i' hors des limites.");
        }
        return this.tabGenome[i];
    }

    public synchronized Genome removeIndividu(int i) {
        if (i >= this.nbGenome || i < 0) {
            throw new IndexOutOfBoundsException("Population, removeIndividu (int i) : indice 'i' hors des limites.");
        }
        Genome g = this.tabGenome[i];
        --this.nbGenome;
        for (int j = i; j < this.nbGenome; ++j) {
            this.tabGenome[j] = this.tabGenome[j + 1];
        }
        this.tabGenome[this.nbGenome] = null;
        return g;
    }

    public synchronized Genome setIndividu(int i, Genome ge) {
        if (i >= this.nbGenome || i < 0) {
            throw new IndexOutOfBoundsException("Population, setIndividu (int i, Genome ge) : indice 'i' hors des limites.");
        }
        if (this.nbGenome != 0 && !this.tabGenome[0].getClass().isInstance(ge)) {
            throw new IllegalArgumentException("Population, setIndividu (int i, Genome ge) : tous les genomes doivent etre de meme type.");
        }
        Genome g = this.tabGenome[i];
        this.tabGenome[i] = ge;
        return g;
    }

    public Genome getParent() {
        return this.pere;
    }

    public void setEnrgStat(int taille) {
        this.enrgStat = true;
        this.lgStat = taille;
        this.statMax = new double[taille];
        this.statMoyenne = new double[taille];
        this.indiceStat = 0;
        this.statMax[0] = this.noteMax;
        this.statMoyenne[0] = this.noteMoyenne;
    }

    public boolean estInitialisee() {
        return this.estInitialisee;
    }

    public int size() {
        return this.nbGenome;
    }

    public synchronized void fitnessPopulation() {
        for (int i = 0; i < this.nbGenome; ++i) {
            this.tabGenome[i].fitness();
        }
        this.statistique();
        if (this.enrgStat) {
            this.indiceStat = (this.indiceStat + 1) % this.lgStat;
            this.statMax[this.indiceStat] = this.noteMax;
            this.statMoyenne[this.indiceStat] = this.noteMoyenne;
        }
    }

    private int resteStochastique(double[] tab_somme, int numero) {
        int binf = 0;
        int bsup = this.nbGenome - 1;
        double nb = this.ecart * (double)numero + this.marge;
        while (binf < bsup) {
            int ctr = binf + bsup >> 1;
            double d = tab_somme[ctr];
            if (d < nb) {
                binf = ctr + 1;
                continue;
            }
            if (d > nb) {
                bsup = ctr - 1;
                continue;
            }
            return ctr;
        }
        return binf;
    }

    private int roulettePipee(double[] tab_somme) {
        int binf = 0;
        int bsup = this.nbGenome - 1;
        double nb = Math.random() * tab_somme[bsup];
        while (binf < bsup) {
            int ctr = binf + bsup >> 1;
            double d = tab_somme[ctr];
            if (d < nb) {
                binf = ctr + 1;
                continue;
            }
            if (d > nb) {
                bsup = ctr - 1;
                continue;
            }
            return ctr;
        }
        return binf;
    }

    private int tournoi(double[] tab_note) {
        int choix;
        int indmax = choix = (int)(Math.random() * (double)this.nbGenome);
        double notemax = tab_note[choix];
        for (int i = 1; i < this.nbPartTournoi; ++i) {
            choix = (int)(Math.random() * (double)this.nbGenome);
            double note = tab_note[choix];
            if (!(note > notemax)) continue;
            notemax = note;
            indmax = choix;
        }
        return indmax;
    }

    private int tournoiInverse(double[] tab_note) {
        int choix;
        int indmin = choix = (int)(Math.random() * (double)this.nbGenome);
        double notemin = tab_note[choix];
        for (int i = 1; i < this.nbPartTournoi; ++i) {
            choix = (int)(Math.random() * (double)this.nbGenome);
            double note = tab_note[choix];
            if (!(note < notemin)) continue;
            notemin = note;
            indmin = choix;
        }
        return indmin;
    }

    public synchronized void generation() {
        block92: {
            Genome[] p2;
            int j;
            int k;
            int i;
            int nb_ind_pi;
            block91: {
                int[] p1;
                boolean[] tab_copie;
                block90: {
                    double[] tab_share;
                    double[] tab_somme;
                    double[] tab_note;
                    block89: {
                        this.temps[0] = System.currentTimeMillis();
                        tab_note = new double[this.nbGenome];
                        tab_copie = new boolean[this.nbGenome];
                        tab_somme = new double[this.nbGenome];
                        this.updateParametreAG();
                        this.temps[1] = System.currentTimeMillis();
                        if (!this.algorithme.equals("Generational GA") && !this.algorithme.equals("Steady-State GA")) break block89;
                        nb_ind_pi = this.algorithme.equals("Steady-State GA") ? this.nbOverlap : this.nbGenome;
                        for (i = 0; i < this.nbGenome; ++i) {
                            tab_note[i] = this.tabGenome[i].getNote();
                        }
                        if (this.scaling) {
                            this.fctScaling(tab_note);
                        }
                        if (this.sharing) {
                            tab_share = this.share();
                            for (i = 0; i < this.nbGenome; ++i) {
                                int n = i;
                                tab_note[n] = tab_note[n] / tab_share[i];
                            }
                        }
                        switch (this.selection) {
                            case 1: {
                                break;
                            }
                            case 0: {
                                System.arraycopy(tab_note, 0, tab_somme, 0, this.nbGenome);
                                Arrays.sort(tab_somme);
                                for (i = 0; i < this.nbGenome; ++i) {
                                    for (k = Arrays.binarySearch(tab_somme, tab_note[i]); k != 0 && tab_somme[k] == tab_somme[k - 1]; --k) {
                                    }
                                    tab_note[i] = k;
                                }
                                tab_somme[0] = tab_note[0];
                                for (i = 1; i < this.nbGenome; ++i) {
                                    tab_somme[i] = tab_somme[i - 1] + tab_note[i];
                                }
                                break;
                            }
                            case 2: {
                                if (this.noteMin < 0.0) {
                                    throw new IllegalArgumentException("Population, generation () : la selection par roulette pipee ne peut s'appliquer que sur un ensemble de notes positives.");
                                }
                                tab_somme[0] = tab_note[0];
                                for (i = 1; i < this.nbGenome; ++i) {
                                    tab_somme[i] = tab_somme[i - 1] + tab_note[i];
                                }
                                break;
                            }
                            case 3: {
                                if (this.noteMin < 0.0) {
                                    throw new IllegalArgumentException("Population, generation () : la selection par reste stochastique ne peut s'appliquer que sur un ensemble de notes positives.");
                                }
                                tab_somme[0] = tab_note[0];
                                for (i = 1; i < this.nbGenome; ++i) {
                                    tab_somme[i] = tab_somme[i - 1] + tab_note[i];
                                }
                                this.ecart = tab_somme[this.nbGenome - 1] / (double)this.nbGenome;
                                this.marge = Math.random() * this.ecart;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Population, generation () : methode de selection inconnue.");
                            }
                        }
                        switch (this.selection) {
                            case 1: {
                                p1 = new int[nb_ind_pi];
                                i = nb_ind_pi;
                                while (i-- > 0) {
                                    p1[i] = this.tournoi(tab_note);
                                }
                                break block90;
                            }
                            case 0: 
                            case 2: {
                                p1 = new int[nb_ind_pi];
                                i = nb_ind_pi;
                                while (i-- > 0) {
                                    p1[i] = this.roulettePipee(tab_somme);
                                }
                                break block90;
                            }
                            case 3: {
                                p1 = new int[this.nbGenome];
                                i = this.nbGenome;
                                while (i-- > 0) {
                                    p1[i] = this.resteStochastique(tab_somme, i);
                                }
                                for (i = 0; i < nb_ind_pi; ++i) {
                                    j = (int)(Math.random() * (double)(this.nbGenome - i)) + i;
                                    k = p1[i];
                                    p1[i] = p1[j];
                                    p1[j] = k;
                                }
                                break block90;
                            }
                            default: {
                                throw new IllegalArgumentException("Population, generation () : methode de selection inconnue.");
                            }
                        }
                    }
                    if (this.algorithme.equals("Niched Pareto GA")) {
                        nb_ind_pi = this.nbGenome;
                        p1 = new int[nb_ind_pi];
                        tab_share = this.share();
                        if (this.scaling) {
                            this.fctScaling(tab_share);
                        }
                        i = this.nbGenome;
                        while (i-- > 0) {
                            p1[i] = this.NPGA(tab_share);
                        }
                    } else if (this.algorithme.equals("MultiObjective GA")) {
                        nb_ind_pi = this.nbGenome;
                        Arrays.fill(tab_note, 1.0);
                        for (i = 0; i < this.nbGenome; ++i) {
                            for (j = 0; j < this.nbGenome; ++j) {
                                if (!this.tabGenome[j].dominePareto(this.tabGenome[i])) continue;
                                int n = i;
                                tab_note[n] = tab_note[n] + 1.0;
                            }
                        }
                        this.fctTransfMoga(tab_note);
                        if (this.scaling) {
                            this.fctScaling(tab_note);
                        }
                        if (this.sharing) {
                            tab_share = this.share();
                            for (i = 0; i < this.nbGenome; ++i) {
                                int n = i;
                                tab_note[n] = tab_note[n] / tab_share[i];
                            }
                        }
                        tab_somme[0] = tab_note[0];
                        for (i = 1; i < this.nbGenome; ++i) {
                            tab_somme[i] = tab_somme[i - 1] + tab_note[i];
                        }
                        p1 = new int[nb_ind_pi];
                        i = nb_ind_pi;
                        while (i-- > 0) {
                            p1[i] = this.roulettePipee(tab_somme);
                        }
                    } else if (this.algorithme.equals("Vector Evaluated GA")) {
                        nb_ind_pi = this.nbGenome;
                        p1 = new int[nb_ind_pi];
                        int nb_obj = this.tabGenome[0].getNbObjectif();
                        int taille_partie = this.nbGenome / nb_obj;
                        k = 0;
                        block42: do {
                            int taille_sous_pop = k < nb_obj - 1 ? taille_partie : this.nbGenome - k * taille_partie;
                            for (i = 0; i < this.nbGenome; ++i) {
                                tab_note[i] = this.tabGenome[i].getNote(k + 1);
                            }
                            switch (this.selection) {
                                case 1: {
                                    break;
                                }
                                case 0: {
                                    System.arraycopy(tab_note, 0, tab_somme, 0, this.nbGenome);
                                    Arrays.sort(tab_somme);
                                    for (i = 0; i < this.nbGenome; ++i) {
                                        for (j = Arrays.binarySearch(tab_somme, tab_note[i]); j != 0 && tab_somme[j] == tab_somme[j - 1]; --j) {
                                        }
                                        tab_note[i] = j;
                                    }
                                    tab_somme[0] = tab_note[0];
                                    for (i = 1; i < this.nbGenome; ++i) {
                                        tab_somme[i] = tab_somme[i - 1] + tab_note[i];
                                    }
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    if (this.noteMin < 0.0) {
                                        throw new IllegalArgumentException("Population, generation () : la selection par roulette pipee ne peut s'appliquer que sur un ensemble de notes positives.");
                                    }
                                    tab_somme[0] = tab_note[0];
                                    for (i = 1; i < this.nbGenome; ++i) {
                                        tab_somme[i] = tab_somme[i - 1] + tab_note[i];
                                    }
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Population, generation () : methode de selection inconnue.");
                                }
                            }
                            i = taille_sous_pop;
                            switch (this.selection) {
                                case 1: {
                                    while (i-- > 0) {
                                        p1[i + k * taille_partie] = this.tournoi(tab_note);
                                    }
                                    continue block42;
                                }
                                case 0: 
                                case 2: 
                                case 3: {
                                    while (i-- > 0) {
                                        p1[i + k * taille_partie] = this.roulettePipee(tab_somme);
                                    }
                                    continue block42;
                                }
                                default: {
                                    throw new IllegalArgumentException("Population, generation () : methode de selection inconnue.");
                                }
                            }
                        } while (++k < nb_obj);
                        i = this.nbGenome;
                        while (i > 0) {
                            j = (int)(Math.random() * (double)i--);
                            k = p1[i];
                            p1[i] = p1[j];
                            p1[j] = k;
                        }
                    } else if (this.algorithme.equals("Nondominated Sorting GA 2")) {
                        nb_ind_pi = this.nbGenome;
                        p1 = new int[nb_ind_pi];
                        CrowdingComparator_NSGAII comparateur = new CrowdingComparator_NSGAII();
                        i = nb_ind_pi;
                        while (i-- > 0) {
                            int indice2;
                            int indice1 = (int)(Math.random() * (double)nb_ind_pi);
                            int choix = comparateur.compare((GenomeFct)this.tabGenome[indice1], (GenomeFct)this.tabGenome[indice2 = (int)(Math.random() * (double)nb_ind_pi)]);
                            p1[i] = choix == -1 ? indice2 : indice1;
                        }
                    } else {
                        throw new IllegalArgumentException("Population, generation () : methode evolutionnaire inconnue.");
                    }
                }
                this.temps[2] = System.currentTimeMillis();
                p2 = new Genome[nb_ind_pi];
                boolean[] tab_change = new boolean[nb_ind_pi];
                i = nb_ind_pi;
                int cpt = 0;
                if (i % 2 == 1) {
                    j = p1[--i];
                    p2[cpt++] = this.tabGenome[j].copier();
                    tab_change[0] = p2[0].mutation(1.0);
                }
                int nb = this.algorithme.equals("Steady-State GA") ? this.nbOverlap : (int)((double)this.nbGenome * this.tauxCroisement);
                if (this.algorithme.equals("Nondominated Sorting GA 2")) {
                    Arrays.fill(tab_copie, true);
                }
                while (i > 0) {
                    j = p1[--i];
                    Genome parent1 = this.tabGenome[j];
                    k = p1[--i];
                    Genome parent2 = this.tabGenome[k];
                    if (cpt < nb && (!this.croisementRestreint || this.croisementRestreint && this.voisinCroisRestreint(parent1, parent2))) {
                        Genome[] enfant = parent1.croisement(parent2);
                        if (this.crowding) {
                            p2[cpt] = enfant[0];
                            tab_change[cpt++] = true;
                            p2[cpt] = enfant[1];
                            tab_change[cpt++] = true;
                            continue;
                        }
                        p2[cpt] = enfant[0];
                        tab_change[cpt++] = true;
                        p2[cpt] = enfant[1];
                        tab_change[cpt++] = true;
                        continue;
                    }
                    if (tab_copie[j]) {
                        p2[cpt++] = parent1.copier();
                    } else {
                        p2[cpt++] = parent1;
                        tab_copie[j] = true;
                    }
                    if (tab_copie[k]) {
                        p2[cpt++] = parent2.copier();
                        continue;
                    }
                    p2[cpt++] = parent2;
                    tab_copie[k] = true;
                }
                this.temps[3] = System.currentTimeMillis();
                for (i = 0; i < nb_ind_pi; ++i) {
                    int n = i;
                    tab_change[n] = tab_change[n] | p2[i].mutation(this.tauxMutation);
                }
                this.temps[4] = System.currentTimeMillis();
                for (i = 0; i < nb_ind_pi; ++i) {
                    if (!tab_change[i]) continue;
                    p2[i].fitness();
                }
                if (!this.algorithme.equals("Steady-State GA")) break block91;
                i = nb_ind_pi;
                switch (this.remplacement) {
                    case 22: 
                    case 24: 
                    case 25: {
                        Genome[] p3 = new Genome[this.nbGenome + this.nbOverlap];
                        System.arraycopy(this.tabGenome, 0, p3, 0, this.nbGenome);
                        System.arraycopy(p2, 0, p3, this.nbGenome, this.nbOverlap);
                        Arrays.sort(p3, this.tabGenome[0]);
                        System.arraycopy(p3, this.nbOverlap, this.tabGenome, 0, this.nbGenome);
                        break block92;
                    }
                    case 21: {
                        while (i-- > 0) {
                            this.tabGenome[(int)(Math.random() * (double)this.nbGenome)] = p2[i];
                        }
                        break block92;
                    }
                    case 23: {
                        while (i-- > 0) {
                            this.tabGenome[this.tournoiInverse((double[])tab_note)] = p2[i];
                        }
                        break block92;
                    }
                    default: {
                        throw new IllegalArgumentException("Population, generation () : methode de remplacement inconnue.");
                    }
                }
            }
            if (this.algorithme.equals("Nondominated Sorting GA 2")) {
                GenomeFct[] Rt = new GenomeFct[this.nbGenome + nb_ind_pi];
                System.arraycopy(this.tabGenome, 0, Rt, 0, this.nbGenome);
                System.arraycopy(p2, 0, Rt, this.nbGenome, nb_ind_pi);
                Ranking_NSGAII rkn = new Ranking_NSGAII(Rt);
                i = this.nbGenomeInitial;
                k = 0;
                EnsembleSolutionEA front = rkn.getFront(k);
                while (i >= front.size()) {
                    front.crowdingDistance();
                    i -= front.size();
                    for (j = front.size() - 1; j >= 0; --j) {
                        this.tabGenome[i + j] = (GenomeFct)front.get(j);
                    }
                    front = rkn.getFront(++k);
                }
                if (i > 0) {
                    front.crowdingDistance();
                    front.sort(new CrowdingDistanceComparator());
                    for (j = i - 1; j >= 0; --j) {
                        this.tabGenome[j] = (GenomeFct)front.get(j);
                    }
                }
            } else {
                if (this.elitisme && this.algorithme.equals("Generational GA")) {
                    i = 5;
                    do {
                        j = (int)(Math.random() * (double)nb_ind_pi);
                    } while (i-- > 0 && p2[j].getNote() > this.noteMax);
                    p2[j] = this.tabGenome[this.positionMax].copier();
                    tab_change[j] = false;
                }
                this.tabGenome = p2;
            }
        }
        this.temps[5] = System.currentTimeMillis();
        this.statistique();
        if (this.enrgStat) {
            this.indiceStat = (this.indiceStat + 1) % this.lgStat;
            this.statMax[this.indiceStat] = this.noteMax;
            this.statMoyenne[this.indiceStat] = this.noteMoyenne;
        }
        this.temps[6] = System.currentTimeMillis();
    }

    public double getNoteMax() {
        return this.noteMax;
    }

    public double getNoteMin() {
        return this.noteMin;
    }

    public double getNoteMoyenne() {
        return this.noteMoyenne;
    }

    public int getPositionMax() {
        return this.positionMax;
    }

    public double statMax(int i) {
        if (i >= this.lgStat) {
            throw new IndexOutOfBoundsException("Population, statMax (int i) : statistique indisponible (tableau trop petit ou indice mal gere).");
        }
        int indice = this.indiceStat - i;
        if (indice < 0) {
            indice += this.lgStat;
        }
        return this.statMax[indice];
    }

    public double statMoyenne(int i) {
        if (i >= this.lgStat) {
            throw new IndexOutOfBoundsException("Population, statMoyenne (int i) : statistique indisponible (tableau trop petit ou indice mal gere).");
        }
        int indice = this.indiceStat - i;
        if (indice < 0) {
            indice += this.lgStat;
        }
        return this.statMoyenne[indice];
    }

    private void statistique() {
        double somme = 0.0;
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        int pos = 0;
        for (int i = 0; i < this.nbGenome; ++i) {
            double valeur = this.tabGenome[i].getNote();
            somme += valeur;
            if (valeur > max) {
                max = valeur;
                pos = i;
            }
            if (!(valeur < min)) continue;
            min = valeur;
        }
        this.noteMax = max;
        this.noteMin = min;
        this.positionMax = pos;
        this.noteMoyenne = somme / (double)this.nbGenome;
    }

    public void affStatistique() {
        DecimalFormat df = new DecimalFormat("0.0000000");
        StringBuilder sb = new StringBuilder("Notes : Max  ");
        sb.append(df.format(this.noteMax));
        sb.append("\tMoyenne  ");
        sb.append(df.format(this.noteMoyenne));
        System.out.println(sb.toString());
    }

    public long getDureeGeneration() {
        return this.temps[6] - this.temps[0];
    }

    public long getDureeSelection() {
        return this.temps[2] - this.temps[1];
    }

    public long getDureeCroisement() {
        return this.temps[3] - this.temps[2];
    }

    public long getDureeMutation() {
        return this.temps[4] - this.temps[3];
    }

    public long getDureeFitness() {
        return this.temps[5] - this.temps[4];
    }

    public void affStatTpsGeneration() {
        StringBuilder sb;
        DecimalFormat df = new DecimalFormat("0.00");
        double d = this.temps[6] - this.temps[0];
        if (d == 0.0) {
            sb = new StringBuilder("Temps : ?");
        } else {
            sb = new StringBuilder("Temps : S ");
            sb.append(df.format((double)(this.temps[2] - this.temps[1]) * 100.0 / d));
            sb.append("%  C ");
            sb.append(df.format((double)(this.temps[3] - this.temps[2]) * 100.0 / d));
            sb.append("%  M ");
            sb.append(df.format((double)(this.temps[4] - this.temps[3]) * 100.0 / d));
            sb.append("%  N ");
            sb.append(df.format((double)(this.temps[5] - this.temps[4]) * 100.0 / d));
            sb.append("%");
        }
        System.out.println(sb.toString());
    }

    public synchronized void affMeilleurIndividu() {
        StringBuilder sb = new StringBuilder("Meilleur Individu : \n");
        sb.append((CharSequence)this.tabGenome[this.positionMax].afficher());
        System.out.println(sb.toString());
    }

    public void fctScaling(double[] tab) {
    }

    public boolean voisinCroisRestreint(Genome g1, Genome g2) {
        return true;
    }

    public boolean voisinSharing(Genome g1, Genome g2) {
        return g1.distance(g2) <= this.sigmashare;
    }

    private double[] share() {
        int taille = this.nbGenome;
        double[] tab = new double[taille];
        Arrays.fill(tab, 1.0);
        for (int i = taille - 2; i >= 0; --i) {
            Genome g = this.tabGenome[i];
            for (int j = i + 1; j < taille; ++j) {
                double distance = g.distance(this.tabGenome[j]);
                if (!(distance <= this.sigmashare)) continue;
                distance = 1.0 - Math.pow(distance / this.sigmashare, this.alpha);
                int n = i;
                tab[n] = tab[n] + distance;
                int n2 = j;
                tab[n2] = tab[n2] + distance;
            }
        }
        return tab;
    }

    private double[] sharePareto() {
        int i;
        int taille = this.nbGenome;
        double[] tab = new double[taille];
        Genome g = this.tabGenome[0];
        tab[0] = g.distance(this.tabGenome[1]);
        tab[1] = tab[0];
        for (i = 2; i < this.nbGenome; ++i) {
            tab[i] = g.distance(this.tabGenome[i]);
            if (!(tab[i] < tab[0])) continue;
            tab[0] = tab[i];
        }
        for (i = this.nbGenome - 2; i > 0; --i) {
            g = this.tabGenome[i];
            for (int j = i + 1; j < this.nbGenome; ++j) {
                double distance = g.distance(this.tabGenome[j]);
                if (distance < tab[i]) {
                    tab[i] = distance;
                }
                if (!(distance < tab[j])) continue;
                tab[j] = distance;
            }
        }
        return tab;
    }

    private int NPGA(double[] tab_share) {
        int a = (int)(Math.random() * (double)this.nbGenome);
        int b = (int)(Math.random() * (double)this.nbGenome);
        boolean a_est_domine = false;
        boolean b_est_domine = false;
        for (int cpt = this.tdom; cpt > 0; --cpt) {
            Genome g = this.tabGenome[(int)(Math.random() * (double)this.nbGenome)];
            if (g.dominePareto(this.tabGenome[a])) {
                a_est_domine = true;
            }
            if (!g.dominePareto(this.tabGenome[b])) continue;
            b_est_domine = true;
        }
        if (a_est_domine) {
            if (b_est_domine) {
                return tab_share[a] < tab_share[b] ? a : b;
            }
            return b;
        }
        if (b_est_domine) {
            return a;
        }
        return tab_share[a] < tab_share[b] ? a : b;
    }

    public void fctTransfMoga(double[] tab) {
        int i;
        double max = 0.0;
        for (i = 0; i < this.nbGenome; ++i) {
            if (!(tab[i] > max)) continue;
            max = tab[i];
        }
        max += 1.0;
        for (i = 0; i < this.nbGenome; ++i) {
            tab[i] = max - tab[i];
        }
    }
}

