/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.gene;

import java.text.DecimalFormat;
import javalain.algorithmegenetique.DomaineReel;
import javalain.algorithmegenetique.Gene;
import javalain.algorithmegenetique.gene.ReelDouble;
import util.GuiUtils;

public final class IntervalleReel
extends Gene {
    private static DecimalFormat df = GuiUtils.DECIMAL_3;
    private DomaineReel domaine;
    private double borne_inf;
    private double borne_sup;

    public IntervalleReel(DomaineReel i) {
        double taille = i.getTaille();
        double min = i.getMin();
        this.domaine = i;
        this.borne_inf = Math.random() * taille + min;
        this.borne_sup = Math.random() * taille + min;
        if (this.borne_inf > this.borne_sup) {
            min = this.borne_inf;
            this.borne_inf = this.borne_sup;
            this.borne_sup = min;
        }
    }

    private IntervalleReel(DomaineReel i, double inf, double sup) {
        this.domaine = i;
        this.borne_inf = inf;
        this.borne_sup = sup;
    }

    public double getBorneInf() {
        return this.borne_inf;
    }

    public double getBorneSup() {
        return this.borne_sup;
    }

    public DomaineReel getDomaineDefinition() {
        return this.domaine;
    }

    public void setDecimalFormat(DecimalFormat df) {
        IntervalleReel.df = df;
    }

    public Gene melanger(Gene g) {
        switch ((int)(Math.random() * 3.0)) {
            case 0: {
                return new IntervalleReel(this.domaine, this.borne_inf, this.borne_sup);
            }
            case 1: {
                IntervalleReel ir = (IntervalleReel)g;
                return new IntervalleReel(this.domaine, ir.borne_inf, ir.borne_sup);
            }
        }
        IntervalleReel ir = (IntervalleReel)g;
        double aux = Math.random() * 1.5 - 0.25;
        double inf = aux * this.borne_inf + (1.0 - aux) * ir.borne_inf;
        double sup = aux * this.borne_sup + (1.0 - aux) * ir.borne_sup;
        if (inf > sup) {
            aux = inf;
            inf = sup;
            sup = aux;
        }
        if (inf < (aux = this.domaine.getMin())) {
            if (sup < aux) {
                return new IntervalleReel(this.domaine);
            }
            inf = aux;
        }
        if (sup > (aux = this.domaine.getMax())) {
            if (inf > aux) {
                return new IntervalleReel(this.domaine);
            }
            sup = aux;
        }
        return new IntervalleReel(this.domaine, inf, sup);
    }

    public void mutation() {
        switch ((int)(Math.random() * 8.0)) {
            case 0: {
                this.borne_inf += Math.random() * Math.min(this.domaine.getRayon(), this.borne_sup - this.borne_inf);
                break;
            }
            case 1: {
                this.borne_inf += Math.random() * (this.borne_sup - this.borne_inf);
                break;
            }
            case 2: {
                this.borne_inf -= Math.random() * Math.min(this.domaine.getRayon(), this.borne_inf - this.domaine.getMin());
                break;
            }
            case 3: {
                this.borne_inf -= Math.random() * Math.min(this.borne_sup - this.borne_inf, this.borne_inf - this.domaine.getMin());
                break;
            }
            case 4: {
                this.borne_sup += Math.random() * Math.min(this.domaine.getRayon(), this.domaine.getMax() - this.borne_sup);
                break;
            }
            case 5: {
                this.borne_sup += Math.random() * Math.min(this.borne_sup - this.borne_inf, this.domaine.getMax() - this.borne_sup);
                break;
            }
            case 6: {
                this.borne_sup -= Math.random() * Math.min(this.domaine.getRayon(), this.borne_sup - this.borne_inf);
                break;
            }
            case 7: {
                this.borne_sup -= Math.random() * (this.borne_sup - this.borne_inf);
                break;
            }
        }
    }

    public Gene copier() {
        return new IntervalleReel(this.domaine, this.borne_inf, this.borne_sup);
    }

    public Gene creer() {
        return new IntervalleReel(this.domaine);
    }

    public Gene creer(Gene g) {
        if (g instanceof ReelDouble) {
            double rd = ((ReelDouble)g).get();
            double dmin = this.domaine.getMin();
            double dmax = this.domaine.getMax();
            if (dmin <= rd && rd <= dmax) {
                double diff_inf = rd - dmin;
                double diff_sup = dmax - rd;
                return new IntervalleReel(this.domaine, rd - Math.random() * diff_inf, rd + Math.random() * diff_sup);
            }
            throw new IllegalArgumentException("IntervalleReel, creer (Gene g) : le ReelDouble passe en parametre n'est pas inclus dans le domaine de definition de this.");
        }
        if (g instanceof IntervalleReel) {
            IntervalleReel ir = (IntervalleReel)g;
            double binf = ir.borne_inf;
            double bsup = ir.borne_sup;
            double dmin = this.domaine.getMin();
            double dmax = this.domaine.getMax();
            if (dmin <= binf && bsup <= dmax) {
                double diff_inf = binf - dmin;
                double diff_sup = dmax - bsup;
                return new IntervalleReel(this.domaine, dmin + Math.random() * diff_inf, dmax - Math.random() * diff_sup);
            }
            throw new IllegalArgumentException("IntervalleReel, creer (Gene g) : l'IntervalleReel passe en parametre n'est pas inclus dans le domaine de definition de this.");
        }
        throw new IllegalArgumentException("IntervalleReel, creer (Gene g) : g doit etre une instance de ReelDouble ou IntervalleReel.");
    }

    public boolean estEgalA(Gene g) {
        if (g instanceof IntervalleReel) {
            IntervalleReel ir = (IntervalleReel)g;
            return this.borne_inf == ir.borne_inf && this.borne_sup == ir.borne_sup;
        }
        return false;
    }

    public boolean estPlusGeneralQue(Gene g) {
        if (g instanceof ReelDouble) {
            double rd = ((ReelDouble)g).get();
            return this.borne_inf <= rd && rd <= this.borne_sup;
        }
        if (g instanceof IntervalleReel) {
            IntervalleReel ir = (IntervalleReel)g;
            return this.borne_inf <= ir.borne_inf && ir.borne_sup <= this.borne_sup;
        }
        return false;
    }

    public StringBuilder afficher() {
        return new StringBuilder("[").append(df.format(this.borne_inf)).append(",").append(df.format(this.borne_sup)).append("]");
    }
}

