/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.ContainerPointSet;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;

public class BakerTransformedPointSet
extends ContainerPointSet {
    public BakerTransformedPointSet(PointSet pointSet) {
        this.init(pointSet);
    }

    public double getCoordinate(int n, int n2) {
        double d = this.P.getCoordinate(n, n2);
        if (d < 0.5) {
            return 2.0 * d;
        }
        return 2.0 * (1.0 - d);
    }

    public PointSetIterator iterator() {
        return new BakerTransformedPointSetIterator();
    }

    public String toString() {
        return "Baker transformed point set of: {\n" + this.P.toString() + "\n}";
    }

    public String formatPoints() {
        try {
            return super.formatPoints();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return "The values are Baker transformed for each coordinate:\n {" + this.P.formatPoints() + "\n}";
        }
    }

    protected class BakerTransformedPointSetIterator
    extends ContainerPointSet.ContainerPointSetIterator {
        protected BakerTransformedPointSetIterator() {
            super(BakerTransformedPointSet.this);
        }

        public double nextCoordinate() {
            double d = this.innerIterator.nextCoordinate();
            if (d < 0.5) {
                return 2.0 * d;
            }
            return 2.0 * (1.0 - d);
        }

        public double nextDouble() {
            double d = this.innerIterator.nextCoordinate();
            if (d < 0.5) {
                return 2.0 * d;
            }
            return 2.0 * (1.0 - d);
        }

        public void nextCoordinates(double[] dArray, int n) {
            this.innerIterator.nextCoordinates(dArray, n);
            for (int i = 0; i < n; ++i) {
                if (dArray[i] < 0.5) {
                    int n2 = i;
                    dArray[n2] = dArray[n2] * 2.0;
                    continue;
                }
                dArray[i] = 2.0 * (1.0 - dArray[i]);
            }
        }

        public int nextPoint(double[] dArray, int n) {
            this.innerIterator.nextPoint(dArray, n);
            for (int i = 0; i < n; ++i) {
                if (dArray[i] < 0.5) {
                    int n2 = i;
                    dArray[n2] = dArray[n2] * 2.0;
                    continue;
                }
                dArray[i] = 2.0 * (1.0 - dArray[i]);
            }
            return this.getCurPointIndex();
        }
    }
}

