/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;

public class NormalDist
extends ContinuousDistribution {
    protected double mu;
    protected double sigma;
    private static final int COEFFMAX = 24;
    private static final double[] NORMAL2_A = new double[]{0.6101430819232004, -0.4348412727125775, 0.1763511936436055, -0.06071079560924941, 0.017712068995694115, -0.004321119385567294, 8.542166768870987E-4, -1.2715509060916275E-4, 1.1248167243671189E-5, 3.1306388542182096E-7, -2.70988068537762E-7, 3.073762270140769E-8, 2.515620384817623E-9, -1.0289299213203192E-9, 2.994405211994994E-11, 2.6051789687266936E-11, -2.6348399241719693E-12, -6.434045098906365E-13, 1.1245740180166345E-13, 1.7281533389986097E-14, -4.264101694942375E-15, -5.45371977880191E-16, 1.58697607761671E-16, 2.0899837844334E-17, -5.900526869409E-18, -9.41893387554E-19, 2.1497735647E-19, 4.6660985008E-20, -7.243011862E-21, -2.387966824E-21, 1.91177535E-22, 1.20482568E-22, -6.72377E-25, -5.747997E-24, -4.28493E-25, 2.44856E-25, 4.3793E-26, -8.151E-27, -3.089E-27, 9.3E-29, 1.74E-28, 1.6E-29, -8.0E-30, -2.0E-30};
    private static final double[] InvNormal2P1 = new double[]{16.030495584406623, -90.78495926296033, 186.44914861620987, -169.0014273464238, 65.45466284794487, -8.642130115872478, 0.176058782139059};
    private static final double[] InvNormal2Q1 = new double[]{14.780647071513831, -91.37416702426032, 210.1579048620532, -222.10254121855132, 107.60453916055124, -20.601073032826545, 1.0};
    private static final double[] InvNormal2P2 = new double[]{-0.015238926344072612, 0.3444556924136125, -2.9344398672542478, 11.763505705217828, -22.655292823101103, 19.12133439658033, -5.478927619598319, 0.237516689024448};
    private static final double[] InvNormal2Q2 = new double[]{-0.010846516960205995, 0.2610628885843079, -2.406831810439376, 10.695129973387015, -23.71671552159658, 24.640158943917285, -10.01437634978307, 1.0};
    private static final double[] InvNormal2P3 = new double[]{5.6451977709864484E-5, 0.005350414748789302, 0.12969550099727353, 1.0426158549298266, 2.830267790175449, 2.6255672879448073, 2.078974263017492, 0.7271880623155681, 0.066816807711805, -0.01779100457511176, 0.0022419563223346345};
    private static final double[] InvNormal2Q3 = new double[]{5.645169986276065E-5, 0.005350558706793065, 0.12986615416911648, 1.0542932232626492, 3.0379331173522206, 3.763116853640503, 3.878285827704201, 2.0372431817412178, 1.0};

    public NormalDist() {
        this.setParams(0.0, 1.0);
    }

    public NormalDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        double d2 = d - this.mu;
        return Math.exp(-d2 * d2 / (2.0 * this.sigma * this.sigma)) / (Math.sqrt(Math.PI * 2) * this.sigma);
    }

    public double cdf(double d) {
        return NormalDist.cdf01((d - this.mu) / this.sigma);
    }

    public double barF(double d) {
        return NormalDist.barF01((d - this.mu) / this.sigma);
    }

    public double inverseF(double d) {
        return this.mu + this.sigma * NormalDist.inverseF01(d);
    }

    public double getMean() {
        return NormalDist.getMean(this.mu, this.sigma);
    }

    public double getVariance() {
        return NormalDist.getVariance(this.mu, this.sigma);
    }

    public double getStandardDeviation() {
        return NormalDist.getStandardDeviation(this.mu, this.sigma);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double d4 = d3 - d;
        return Math.exp(-d4 * d4 / (2.0 * d2 * d2)) / (Math.sqrt(Math.PI * 2) * d2);
    }

    public static double cdf01(double d) {
        double d2;
        if (d <= -100.0) {
            return 0.0;
        }
        if (d >= 100.0) {
            return 1.0;
        }
        if ((d = -d / 1.4142135623730951) < 0.0) {
            d = -d;
            double d3 = (d - 3.75) / (d + 3.75);
            d2 = 1.0 - 0.5 * Math.exp(-d * d) * Num.evalCheby(NORMAL2_A, 24, d3);
        } else {
            double d4 = (d - 3.75) / (d + 3.75);
            d2 = 0.5 * Math.exp(-d * d) * Num.evalCheby(NORMAL2_A, 24, d4);
        }
        return d2;
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return NormalDist.cdf01((d3 - d) / d2);
    }

    public static double barF01(double d) {
        boolean bl;
        double[] dArray = new double[]{0.6101430819232004, -0.4348412727125775, 0.1763511936436055, -0.06071079560924941, 0.017712068995694115, -0.004321119385567294, 8.542166768870987E-4, -1.2715509060916275E-4, 1.1248167243671189E-5, 3.1306388542182096E-7, -2.70988068537762E-7, 3.073762270140769E-8, 2.515620384817623E-9, -1.0289299213203192E-9, 2.994405211994994E-11, 2.6051789687266936E-11, -2.6348399241719693E-12, -6.434045098906365E-13, 1.1245740180166345E-13, 1.7281533389986097E-14, -4.2641016949424E-15, -5.4537197788E-16, 1.5869760776E-16, 2.08998378E-17, -5.9E-18};
        if (d >= 100.0) {
            return 0.0;
        }
        if (d <= -100.0) {
            return 1.0;
        }
        if (d >= 0.0) {
            bl = false;
        } else {
            bl = true;
            d = -d;
        }
        double d2 = (d - 5.303300858899107) / (d + 5.303300858899107);
        double d3 = Num.evalCheby(dArray, 24, d2);
        d3 = d3 * Math.exp(-d * d / 2.0) / 2.0;
        if (bl) {
            return 1.0 - d3;
        }
        return d3;
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return NormalDist.barF01((d3 - d) / d2);
    }

    public static double inverseF01(double d) {
        boolean bl;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("u is not in [0, 1]");
        }
        if (d <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = d;
        if ((d = 2.0 * d - 1.0) > 0.9999999999999998) {
            return 8.2;
        }
        if (d < 0.0) {
            d = -d;
            bl = true;
        } else {
            bl = false;
        }
        if (d <= 0.75) {
            double d3 = d * d - 0.5625;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 6; i >= 0; --i) {
                d5 = d5 * d3 + InvNormal2P1[i];
                d4 = d4 * d3 + InvNormal2Q1[i];
            }
            d2 = d * d5 / d4;
        } else if (d <= 0.9375) {
            double d6 = d * d - 0.87890625;
            double d7 = 0.0;
            double d8 = 0.0;
            for (int i = 7; i >= 0; --i) {
                d8 = d8 * d6 + InvNormal2P2[i];
                d7 = d7 * d6 + InvNormal2Q2[i];
            }
            d2 = d * d8 / d7;
        } else {
            int n;
            double d9 = d2 > 1.0E-8 ? 1.0 / Math.sqrt(-Math.log(1.0 - d)) : 1.0 / Math.sqrt(-Math.log(2.0 * d2));
            double d10 = 0.0;
            double d11 = 0.0;
            for (n = 10; n >= 0; --n) {
                d11 = d11 * d9 + InvNormal2P3[n];
            }
            for (n = 8; n >= 0; --n) {
                d10 = d10 * d9 + InvNormal2Q3[n];
            }
            d2 = 1.0 / d9 * d11 / d10;
        }
        if (bl) {
            return -d2 * 1.4142135623730951;
        }
        return d2 * 1.4142135623730951;
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return d + d2 * NormalDist.inverseF01(d3);
    }

    public static double[] getMLE(double[] dArray, int n) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray2 = new double[2];
        double d = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            d += dArray[n2];
        }
        dArray2[0] = d / (double)n;
        d = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            d += (dArray[n2] - dArray2[0]) * (dArray[n2] - dArray2[0]);
        }
        dArray2[1] = Math.sqrt(d / (double)n);
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return NormalDist.getMLE(dArray, n);
    }

    public static NormalDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = NormalDist.getMaximumLikelihoodEstimate(dArray, n);
        return new NormalDist(dArray2[0], dArray2[1]);
    }

    public static double getMean(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return d;
    }

    public static double getVariance(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return d2 * d2;
    }

    public static double getStandardDeviation(double d, double d2) {
        return d2;
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setParams(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = d;
        this.sigma = d2;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.mu, this.sigma};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : mu = " + this.mu + ", sigma = " + this.sigma;
    }
}

