% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lqvarFilter}
\alias{lqvarFilter}
\title{Filtering 'low quality' variables from the original dataset}
\usage{
lqvarFilter(data, threshold = 0.5, exclude = T)
}
\arguments{
\item{data}{a n x p data frame with n observations and p columns. While the first two columns usually represent the names of the samples and the
class labels related to each sample respectively, the remaining columns represent metabolite concentrations measured by 1H NMR or bins of 1H NMR spectra}

\item{threshold}{the percentage of zero values of a variable above which it will be eliminated from the dataset (default: 0.50)}

\item{exclude}{a logical variable which stores a simple True / False setting. If set to True the filtering method will exclude the first two columns.}
}
\value{
a list containing the filtered dataset, a vector with the names of the varables excluded and a vector with the indexes of the variables eliminated
}
\description{
This function takes the original dataset and filters those variables with a definite (usually relevant) percentage of zero-values
}
\examples{
## load the included example dataset
data(cachexiaData)
## call lqvarFilter with the parameter exclude set to TRUE (default)
## in order to exclude the first two columns of the dataset from scaling
res <- lqvarFilter(cachexiaData, threshold = 0.4, exclude = TRUE)
data.filtered <- res$filtered_dataset
}
\author{
Piergiorgio Palla
}

