/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.runframe;

import freak.core.control.Actions;
import freak.core.control.FreakFile;
import freak.core.control.GenerationIndex;
import freak.core.control.Replay;
import freak.core.control.RunControl;
import freak.core.control.RunIndex;
import freak.core.control.Schedule;
import freak.core.control.StateListener;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.observer.Observer;
import freak.core.view.View;
import freak.core.view.swingsupport.FreakLabelModel;
import freak.core.view.swingsupport.FreakSliderModel;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.gui.HelpWindow;
import freak.gui.PropertyDialog;
import freak.gui.gpas.GPASDialog;
import freak.gui.runframe.AboutDialog;
import freak.gui.runframe.FreakInternalFrame;
import freak.gui.runframe.GoToDialog;
import freak.gui.runframe.InfoPanelSpinnerModel;
import freak.gui.runframe.InternalFrameActionListener;
import freak.gui.runframe.LoadSaveManager;
import freak.gui.runframe.RunFrameUI;
import freak.gui.scheduleeditor.ScheduleEditor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class RunFrame
extends RunFrameUI
implements StateListener {
    private HelpWindow helpWindow;
    private ScheduleEditor scheduleEditor;
    private boolean editingNewSchedule;
    private GPASDialog gpasDialog;
    public RunControl runControl = new RunControl(this);
    private LoadSaveManager loadSaveManager = new LoadSaveManager(this);
    private Actions.Action lastSent;
    private Schedule displayedSchedule;
    private InfoPanelSpinnerModel batchSpinnerModel = new InfoPanelSpinnerModel();
    private InfoPanelSpinnerModel runSpinnerModel = new InfoPanelSpinnerModel();
    private InfoPanelSpinnerModel generationSpinnerModel = new InfoPanelSpinnerModel();
    private FreakSliderModel generationSliderModel = new FreakSliderModel();
    private FreakLabelModel searchSpaceModel = new FreakLabelModel();
    private FreakLabelModel fitnessFunctionModel = new FreakLabelModel();
    private boolean firstClick = true;
    private int batch;
    private int run;
    private static NumberFormat speedFormat = NumberFormat.getNumberInstance();
    private boolean ignoreSlider;
    private double speed = 10.0;
    private HashMap frameIDs = new HashMap();
    private ConfigureViewAction configureViewAction = new ConfigureViewAction();

    static {
        speedFormat.setMinimumFractionDigits(2);
        speedFormat.setMaximumFractionDigits(2);
    }

    public RunFrame() {
        this.setViews();
        this.addActions();
        this.modeNoSchedule();
        this.runControl.setSpeedLimit(10.0);
    }

    public void setScheduleEditor(ScheduleEditor schedEd) {
        this.scheduleEditor = schedEd;
    }

    private void setViews() {
        this.generationSliderModel.setMinimum(this.jSliderGeneration.getMinimum());
        this.generationSliderModel.setMaximum(this.jSliderGeneration.getMaximum());
        this.generationSliderModel.setValue(this.jSliderGeneration.getValue());
        this.generationSliderModel.setAutoTicks(true);
        this.searchSpaceModel.setText(this.jLabelSearchSpace.getText());
        this.fitnessFunctionModel.setText(this.jLabelFitnessFunction.getText());
        this.batchSpinnerModel.setView(this.jSpinnerBatch);
        this.runSpinnerModel.setView(this.jSpinnerRun);
        this.generationSpinnerModel.setView(this.jSpinnerGeneration);
        this.generationSliderModel.setView(this.jSliderGeneration);
        this.searchSpaceModel.setView(this.jLabelSearchSpace);
        this.fitnessFunctionModel.setView(this.jLabelFitnessFunction);
    }

    private void addActions() {
        this.jMenuItemNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.newClicked();
            }
        });
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.openClicked();
            }
        });
        this.jMenuItemSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.saveClicked();
            }
        });
        this.jMenuItemSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.saveAsClicked();
            }
        });
        this.jMenuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.quitClicked();
            }
        });
        this.jMenuItemEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.editClicked();
            }
        });
        this.jMenuItemStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.startClicked();
            }
        });
        this.jMenuItemSuspend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.suspendClicked();
            }
        });
        this.jMenuItemSkipToStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.skipToStartClicked();
            }
        });
        this.jMenuItemSkipBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.skipBackClicked();
            }
        });
        this.jMenuItemSkipForward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.skipForwardClicked();
            }
        });
        this.jMenuItemSkipToEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.skipToEndClicked();
            }
        });
        this.jMenuItemGoTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.goToClicked();
            }
        });
        this.jMenuItemTile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.tileClicked();
            }
        });
        this.jMenuItemCascade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.cascadeClicked();
            }
        });
        this.jMenuItemMinimize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.minimizeAllClicked();
            }
        });
        this.jMenuItemRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.restoreAllClicked();
            }
        });
        this.jMenuItemClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.closeAllClicked();
            }
        });
        this.jMenuItemHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.helpClicked();
            }
        });
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.aboutClicked();
            }
        });
        this.jMenuItemConfigureView.setAction(this.configureViewAction);
        this.jButtonStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.startClicked();
            }
        });
        this.jButtonSuspend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.suspendClicked();
            }
        });
        this.jButtonSkipToStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.skipToStartClicked();
            }
        });
        this.jButtonSkipBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.skipBackClicked();
            }
        });
        this.jButtonSkipForward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.skipForwardClicked();
            }
        });
        this.jButtonSkipToEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.skipToEndClicked();
            }
        });
        this.jButtonQuickStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.quickStartClicked();
            }
        });
        this.batchSpinnerModel.setListener(new InfoPanelSpinnerModel.InfoPanelSpinnerModelListener(){

            public void absoluteChangeRequest(int newValue) {
                RunFrame.this.batchAbsoluteChangeRequest(newValue);
            }

            public void relativeChangeRequest(int change) {
                RunFrame.this.batchRelativeChangeRequest(change);
            }
        });
        this.runSpinnerModel.setListener(new InfoPanelSpinnerModel.InfoPanelSpinnerModelListener(){

            public void absoluteChangeRequest(int newValue) {
                RunFrame.this.runAbsoluteChangeRequest(newValue);
            }

            public void relativeChangeRequest(int change) {
                RunFrame.this.runRelativeChangeRequest(change);
            }
        });
        this.generationSpinnerModel.setListener(new InfoPanelSpinnerModel.InfoPanelSpinnerModelListener(){

            public void absoluteChangeRequest(int newValue) {
                RunFrame.this.generationAbsoluteChangeRequest(newValue);
            }

            public void relativeChangeRequest(int change) {
                RunFrame.this.generationRelativeChangeRequest(change);
            }
        });
        this.jSliderGeneration.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RunFrame.this.generationSliderClicked();
            }
        });
        this.speedLimitCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.speedCheckBoxClicked();
            }
        });
        this.jTextFieldSpeed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunFrame.this.speedTextFieldClicked();
            }
        });
        this.jTextFieldSpeed.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                RunFrame.this.speedTextFieldClicked();
            }
        });
        this.jSliderSpeed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RunFrame.this.speedSliderClicked();
            }
        });
    }

    private void modeNoSchedule() {
        this.enableMode(true, false, false, false, false);
        this.enableWindowMode(false);
    }

    private void modeRunning() {
        this.enableMode(false, false, false, true, true);
    }

    private void modeSuspended() {
        this.enableMode(true, true, true, true, false);
    }

    private void modeEdit() {
        this.enableMode(true, true, false, false, false);
    }

    private void enableMode(boolean newOpen, boolean saveEdit, boolean config, boolean controls, boolean blink) {
        this.jButtonStart.setEnabled(controls);
        this.jButtonSuspend.setEnabled(controls);
        this.jButtonSkipToStart.setEnabled(controls);
        this.jButtonSkipBack.setEnabled(controls);
        this.jButtonSkipForward.setEnabled(controls);
        this.jButtonSkipToEnd.setEnabled(controls);
        this.jSliderGeneration.setEnabled(controls);
        this.speedLimitCheckBox.setEnabled(controls);
        this.jSliderSpeed.setEnabled(controls && this.speedLimitCheckBox.isSelected());
        this.jTextFieldSpeed.setEnabled(controls && this.speedLimitCheckBox.isSelected());
        this.jSpinnerBatch.setEnabled(controls);
        this.jSpinnerRun.setEnabled(controls);
        this.jSpinnerGeneration.setEnabled(controls);
        this.jButtonQuickStart.setEnabled(newOpen);
        this.jMenuItemNew.setEnabled(newOpen);
        this.jMenuItemOpen.setEnabled(newOpen);
        this.jMenuItemSave.setEnabled(saveEdit);
        this.jMenuItemSaveAs.setEnabled(saveEdit);
        this.jMenuItemEdit.setEnabled(saveEdit);
        this.jMenuItemStart.setEnabled(controls);
        this.jMenuItemSuspend.setEnabled(controls);
        this.jMenuItemSkipToStart.setEnabled(controls);
        this.jMenuItemSkipBack.setEnabled(controls);
        this.jMenuItemSkipForward.setEnabled(controls);
        this.jMenuItemSkipToEnd.setEnabled(controls);
        this.jMenuItemGoTo.setEnabled(controls);
        this.configureViewAction.setEnabledFromRunControl(config);
        this.blinkingR.setBlink(blink);
    }

    private void enableWindowMode(boolean windows) {
        this.jMenuItemTile.setEnabled(windows);
        this.jMenuItemCascade.setEnabled(windows);
        this.jMenuItemMinimize.setEnabled(windows);
        this.jMenuItemClose.setEnabled(windows);
        this.jMenuItemRestore.setEnabled(windows);
    }

    private void newClicked() {
        if (this.scheduleEditor != null) {
            if (this.editingNewSchedule) {
                return;
            }
            this.scheduleEditor.cancel();
        }
        this.scheduleEditor = new ScheduleEditor(this, null);
        this.scheduleEditor.setVisible(true);
        if (this.runControl.getSchedule() != null) {
            this.modeEdit();
        }
        this.editingNewSchedule = true;
    }

    private void editClicked() {
        if (this.scheduleEditor != null) {
            if (this.editingNewSchedule) {
                this.scheduleEditor.cancel();
            } else {
                return;
            }
        }
        this.scheduleEditor = new ScheduleEditor(this, this.runControl.getSchedule());
        this.scheduleEditor.setVisible(true);
        this.modeEdit();
        this.editingNewSchedule = false;
    }

    private void openClicked() {
        FreakFile file;
        if (this.scheduleEditor != null) {
            this.scheduleEditor.cancel();
        }
        if ((file = this.loadSaveManager.load()) != null) {
            this.runControl.fromFile(file);
        }
    }

    private void saveClicked() {
        if (this.scheduleEditor != null) {
            this.scheduleEditor.cancel();
        }
        this.loadSaveManager.save(this.runControl.toFile());
    }

    private void saveAsClicked() {
        if (this.scheduleEditor != null) {
            this.scheduleEditor.cancel();
        }
        this.loadSaveManager.saveAs(this.runControl.toFile());
    }

    public void editorClosed() {
        Schedule schedule = this.scheduleEditor.getSchedule();
        this.scheduleEditor = null;
        if (schedule != null) {
            schedule.modulesEdited();
            if (this.editingNewSchedule) {
                this.loadSaveManager.newObject();
                this.runControl.setNewSchedule(schedule);
            } else {
                this.runControl.scheduleEdited(schedule);
            }
        } else if (this.runControl.getSchedule() != null) {
            this.modeSuspended();
        }
    }

    private void quitClicked() {
        System.exit(0);
    }

    private void startClicked() {
        this.requestAction(new Actions.StartAction());
    }

    private void suspendClicked() {
        this.requestAction(new Actions.SuspendAction());
    }

    private void skipToStartClicked() {
        this.requestAction(new Actions.SeekToStartAction());
    }

    private void skipBackClicked() {
        this.requestAction(new Actions.stepBackAction());
    }

    private void skipForwardClicked() {
        this.requestAction(new Actions.StepForwardAction());
    }

    private void skipToEndClicked() {
        this.requestAction(new Actions.SeekToReplayEndAction());
    }

    private void quickStartClicked() {
        if (this.gpasDialog != null) {
            this.gpasDialog.cancel();
        }
        this.gpasDialog = new GPASDialog(this);
        this.gpasDialog.setVisible(true);
    }

    private void goToClicked() {
        int batch = (Integer)this.jSpinnerBatch.getValue();
        int run = (Integer)this.jSpinnerRun.getValue();
        int generation = (Integer)this.jSpinnerGeneration.getValue();
        GenerationIndex aboutNow = new GenerationIndex(batch, run, generation);
        GoToDialog dialog = new GoToDialog((Frame)this, aboutNow);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        dialog.dispose();
        GenerationIndex target = dialog.goTo;
        if (target != null) {
            this.requestAction(new Actions.SeekToTargetAction(target));
        }
    }

    private void batchAbsoluteChangeRequest(int newValue) {
        int run = Math.max(1, (Integer)this.jSpinnerRun.getValue());
        int generation = Math.max(1, (Integer)this.jSpinnerGeneration.getValue());
        if (newValue <= 0) {
            this.requestAction(new Actions.SeekToTargetAction(GenerationIndex.START));
        } else {
            this.requestAction(new Actions.SeekToTargetAction(new GenerationIndex(newValue, run, generation)));
        }
    }

    private void batchRelativeChangeRequest(int change) {
        if (change == -1) {
            this.requestAction(new Actions.SeekToLastBatchAction());
        } else if (change == 1) {
            this.requestAction(new Actions.SeekToNextBatchAction());
        }
    }

    private void runAbsoluteChangeRequest(int newValue) {
        int batch = (Integer)this.jSpinnerBatch.getValue();
        int generation = (Integer)this.jSpinnerGeneration.getValue();
        if (batch > 0 && newValue > 0) {
            this.requestAction(new Actions.SeekToTargetAction(new GenerationIndex(batch, newValue, generation)));
        }
    }

    private void runRelativeChangeRequest(int change) {
        if (change == -1) {
            this.requestAction(new Actions.SeekToLastRunAction());
        } else if (change == 1) {
            this.requestAction(new Actions.SeekToNextRunAction());
        }
    }

    private void generationAbsoluteChangeRequest(int newValue) {
        int batch = (Integer)this.jSpinnerBatch.getValue();
        int run = (Integer)this.jSpinnerRun.getValue();
        if (batch > 0 && newValue > 0) {
            this.requestAction(new Actions.SeekToTargetAction(new GenerationIndex(batch, run, newValue)));
        }
    }

    private void generationRelativeChangeRequest(int change) {
        if (change == -1) {
            this.requestAction(new Actions.SeekToLastGenerationAction());
        } else if (change == 1) {
            this.requestAction(new Actions.SeekToNextGenerationAction());
        }
    }

    private void generationSliderClicked() {
        if (this.generationSliderModel.isProgrammaticalChange()) {
            return;
        }
        if (this.firstClick) {
            this.requestAction(new Actions.StartSeekSequenceAction());
            this.batch = (Integer)this.jSpinnerBatch.getValue();
            this.run = (Integer)this.jSpinnerRun.getValue();
            this.firstClick = false;
        } else if (!this.jSliderGeneration.getValueIsAdjusting()) {
            this.requestAction(new Actions.EndSeekSequenceAction());
            this.firstClick = true;
        }
        GenerationIndex target = new GenerationIndex(this.batch, this.run, this.jSliderGeneration.getValue());
        this.requestAction(new Actions.SeekToTargetAction(target));
    }

    private void speedCheckBoxClicked() {
        boolean clicked = this.speedLimitCheckBox.isSelected();
        this.jSliderSpeed.setEnabled(clicked);
        this.jTextFieldSpeed.setEnabled(clicked);
        if (clicked) {
            this.requestAction(new Actions.SetSpeedAction(this.speed));
        } else {
            this.requestAction(new Actions.SetSpeedAction(Double.POSITIVE_INFINITY));
        }
    }

    private void speedSliderClicked() {
        if (this.ignoreSlider) {
            return;
        }
        this.speed = this.sliderToSpeed(this.jSliderSpeed.getValue());
        this.jTextFieldSpeed.setText(speedFormat.format(this.speed));
        this.requestAction(new Actions.SetSpeedAction(this.speed));
    }

    private void speedTextFieldClicked() {
        String speedText = this.jTextFieldSpeed.getText();
        try {
            this.speed = speedFormat.parse(speedText).doubleValue();
            if (this.speed <= 0.0) {
                throw new ParseException(null, 0);
            }
            this.jTextFieldSpeed.setText(speedFormat.format(this.speed));
            this.ignoreSlider = true;
            this.jSliderSpeed.setValue(this.speedToSlider(this.speed));
            this.ignoreSlider = false;
            this.requestAction(new Actions.SetSpeedAction(this.speed));
        }
        catch (ParseException exc) {
            this.jTextFieldSpeed.setText(speedFormat.format(this.speed));
        }
    }

    private double sliderToSpeed(int slider) {
        return Math.pow(10.0, (double)slider / 100.0);
    }

    private int speedToSlider(double speed) {
        int slider = (int)Math.round(100.0 * Math.log(speed) / Math.log(10.0));
        if (slider < -100) {
            return -100;
        }
        if (slider > 500) {
            return 500;
        }
        return slider;
    }

    private void requestAction(Actions.Action action) {
        this.lastSent = action;
        this.runControl.request(action);
        this.modeRunning();
    }

    public void simulationCompleted(final Actions.Action lastProcessed) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (RunFrame.this.lastSent != lastProcessed) {
                    return;
                }
                if (RunFrame.this.runControl.getSchedule() == null) {
                    RunFrame.this.modeNoSchedule();
                } else {
                    RunFrame.this.modeSuspended();
                }
                UpdateManager.flushAll();
            }
        });
    }

    public void simulationException(final Exception exc) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(RunFrame.this, exc, "Exception in Simulation", 0);
            }
        });
        exc.printStackTrace();
    }

    public void terminated(Actions.Action lastProcessedBeforeTermination) {
    }

    public void synchroneousFeedback(Schedule activeSchedule, Replay replay) {
        if (activeSchedule != this.displayedSchedule) {
            this.createInternalFrames(activeSchedule);
            this.updateLabels(activeSchedule);
            this.displayedSchedule = activeSchedule;
        }
        this.updateTimeIndexComponents(activeSchedule, replay);
        if (activeSchedule != null) {
            this.modeSuspended();
            this.blinkingR.setVisible(this.isReplayMode(activeSchedule, replay));
        } else {
            this.modeNoSchedule();
            this.blinkingR.setVisible(false);
        }
        UpdateManager.flushAll();
    }

    public void asynchroneousFeedback(Schedule activeSchedule, Replay replay) {
        if (activeSchedule != this.displayedSchedule) {
            this.invokeAndWaitCreateInternalFrames(activeSchedule);
            this.updateLabels(activeSchedule);
            this.displayedSchedule = activeSchedule;
        }
        this.blinkingR.setVisible(this.isReplayMode(activeSchedule, replay));
        this.updateTimeIndexComponents(activeSchedule, replay);
    }

    private boolean isReplayMode(Schedule schedule, Replay replay) {
        if (schedule == null) {
            return false;
        }
        return schedule.getCurrentTimeIndex().isBefore(replay.getLastPoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabels(Schedule schedule) {
        if (schedule == null) {
            return;
        }
        FreakLabelModel freakLabelModel = this.searchSpaceModel;
        synchronized (freakLabelModel) {
            this.searchSpaceModel.setText(schedule.getPhenotypeSearchSpace().getName());
        }
        UpdateManager.markDirty(this.searchSpaceModel);
        freakLabelModel = this.fitnessFunctionModel;
        synchronized (freakLabelModel) {
            this.fitnessFunctionModel.setText(schedule.getRealFitnessFunction().getName());
        }
        UpdateManager.markDirty(this.fitnessFunctionModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimeIndexComponents(Schedule schedule, Replay replay) {
        int maximum;
        int minimum;
        if (schedule == null) {
            return;
        }
        InfoPanelSpinnerModel infoPanelSpinnerModel = this.batchSpinnerModel;
        synchronized (infoPanelSpinnerModel) {
            this.batchSpinnerModel.setSimulationValue(schedule.getCurrentBatch());
        }
        UpdateManager.markDirty(this.batchSpinnerModel);
        infoPanelSpinnerModel = this.runSpinnerModel;
        synchronized (infoPanelSpinnerModel) {
            this.runSpinnerModel.setSimulationValue(schedule.getCurrentRun());
        }
        UpdateManager.markDirty(this.runSpinnerModel);
        GenerationIndex now = schedule.getCurrentTimeIndex();
        int currentGeneration = now.generation;
        if (now.batch == 0) {
            minimum = 0;
            maximum = 0;
        } else {
            minimum = 1;
            maximum = replay.getLastPointInRun((RunIndex)now.toRunIndex()).generation;
        }
        FreakSwingModel freakSwingModel = this.generationSpinnerModel;
        synchronized (freakSwingModel) {
            this.generationSpinnerModel.setSimulationValue(currentGeneration);
        }
        UpdateManager.markDirty(this.generationSpinnerModel);
        freakSwingModel = this.generationSliderModel;
        synchronized (freakSwingModel) {
            this.generationSliderModel.setMinimum(minimum);
            this.generationSliderModel.setMaximum(maximum);
            this.generationSliderModel.setValue(currentGeneration);
        }
        UpdateManager.markDirty(this.generationSliderModel);
    }

    public void helpClicked() {
        this.showHelpPage("index.html");
    }

    public void showHelpPage(String page) {
        if (this.helpWindow == null) {
            this.helpWindow = new HelpWindow(this);
            this.helpWindow.pack();
            this.helpWindow.setLocationRelativeTo(this);
        }
        this.helpWindow.goToPage(page);
        this.helpWindow.setVisible(true);
    }

    public void aboutClicked() {
        AboutDialog d = new AboutDialog(this, true);
        d.setLocationRelativeTo(this);
        d.setVisible(true);
    }

    private void tileClicked() {
        this.desktop.tile();
    }

    private void cascadeClicked() {
        this.desktop.cascade();
    }

    private void minimizeAllClicked() {
        this.desktop.minimizeAll();
    }

    private void restoreAllClicked() {
        this.desktop.restoreAll();
    }

    private void closeAllClicked() {
        this.desktop.closeAll();
    }

    private void invokeAndWaitCreateInternalFrames(final Schedule schedule) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    RunFrame.this.createInternalFrames(schedule);
                }
            });
        }
        catch (InterruptedException exc) {
            throw new RuntimeException(exc);
        }
        catch (InvocationTargetException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void createInternalFrames(Schedule newSchedule) {
        if (newSchedule == null) {
            this.desktop.getDelegate().removeAll();
            this.desktop.getDelegate().repaint();
            this.frameIDs.clear();
            this.configureViewAction.setActiveView(null);
            return;
        }
        Iterator observerIterator = newSchedule.getObserverManager().getActiveObservers().iterator();
        HashSet<Integer> foundViewIDs = new HashSet<Integer>();
        while (observerIterator.hasNext()) {
            Observer observer = (Observer)observerIterator.next();
            for (View view : observer.getViews()) {
                FreakInternalFrame frame;
                Integer viewId = new Integer(view.getIdentificationNumber());
                foundViewIDs.add(viewId);
                if (this.frameIDs.containsKey(viewId)) {
                    frame = (FreakInternalFrame)this.frameIDs.get(viewId);
                    frame.setView(observer, view);
                    continue;
                }
                frame = new FreakInternalFrame();
                this.frameIDs.put(viewId, frame);
                frame.setView(observer, view);
                this.desktop.add(frame);
                frame.setVisible(true);
                this.configureViewAction.setActiveView((FreakInternalFrame)this.desktop.getDelegate().getSelectedFrame());
                frame.addInternalFrameListener(new InternalFrameAdapter(){

                    public void internalFrameActivated(InternalFrameEvent evt) {
                        RunFrame.this.configureViewAction.setActiveView((FreakInternalFrame)RunFrame.this.desktop.getDelegate().getSelectedFrame());
                    }

                    public void internalFrameDeactivated(InternalFrameEvent evt) {
                        RunFrame.this.configureViewAction.setActiveView((FreakInternalFrame)RunFrame.this.desktop.getDelegate().getSelectedFrame());
                    }
                });
            }
        }
        this.jMenuViews.removeAll();
        ButtonGroup viewButtonGroup = new ButtonGroup();
        int counter = 1;
        Iterator frames = this.frameIDs.values().iterator();
        while (frames.hasNext()) {
            FreakInternalFrame currentFrame = (FreakInternalFrame)frames.next();
            Integer viewId = new Integer(currentFrame.getViewId());
            if (foundViewIDs.contains(viewId)) {
                JRadioButtonMenuItem m = new JRadioButtonMenuItem();
                viewButtonGroup.add(m);
                m.setText(currentFrame.getTitle());
                m.addActionListener(new InternalFrameActionListener(currentFrame));
                this.jMenuViews.add(m);
                m.setSelected(currentFrame == this.desktop.getDelegate().getSelectedFrame());
                currentFrame.addInternalFrameListener(new RadioButtonMenuItemInternalFrameAdapter(m));
                if (counter <= 9) {
                    m.setAccelerator(KeyStroke.getKeyStroke("alt " + counter));
                }
                ++counter;
                continue;
            }
            this.desktop.remove(currentFrame);
            this.desktop.getDelegate().setSelectedFrame(null);
            this.configureViewAction.setActiveView((FreakInternalFrame)this.desktop.getDelegate().getSelectedFrame());
            currentFrame.dispose();
            frames.remove();
        }
        int viewCount = foundViewIDs.size();
        if (viewCount > 0) {
            this.jMenuViews.addSeparator();
        }
        this.jMenuViews.add(this.jMenuItemTile);
        this.jMenuViews.add(this.jMenuItemCascade);
        this.jMenuViews.add(this.jMenuItemMinimize);
        this.jMenuViews.add(this.jMenuItemRestore);
        this.jMenuViews.add(this.jMenuItemClose);
        this.enableWindowMode(viewCount > 0);
        this.configureViewAction.setActiveView((FreakInternalFrame)this.desktop.getDelegate().getSelectedFrame());
        this.desktop.getDelegate().revalidate();
        this.desktop.getDelegate().repaint();
    }

    class RadioButtonMenuItemInternalFrameAdapter
    extends InternalFrameAdapter {
        private JMenuItem menuItem;

        public RadioButtonMenuItemInternalFrameAdapter(JMenuItem menuItem) {
            this.menuItem = menuItem;
        }

        public void internalFrameActivated(InternalFrameEvent evt) {
            this.menuItem.setSelected(true);
        }

        public void internalFrameDeactivated(InternalFrameEvent evt) {
            this.menuItem.setSelected(false);
        }
    }

    class ConfigureViewAction
    extends AbstractAction {
        private boolean enabledFromRunControl;
        private FreakInternalFrame activeView;

        ConfigureViewAction() {
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
            this.putValue("Name", "Configure Selected View...");
            this.putValue("ShortDescription", "Configure the selected view");
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.activeView != null) {
                View view = this.activeView.getView();
                if (view instanceof Configurable) {
                    PropertyDialog pd = new PropertyDialog(RunFrame.this, RunFrame.this.runControl.getSchedule().getEventController(), (Module)this.activeView.getView(), null, RunFrame.this.runControl.getSchedule().getBatchList());
                    pd.setVisible(true);
                    RunFrame.this.runControl.scheduleEdited(RunFrame.this.runControl.getSchedule());
                    this.activeView.revalidate();
                    this.activeView.repaint();
                } else {
                    JOptionPane.showMessageDialog(RunFrame.this, "Selected view is not configurable.", "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(RunFrame.this, "No view selected.", "Error", 0);
            }
        }

        public void setEnabledFromRunControl(boolean enabled) {
            this.enabledFromRunControl = enabled;
            this.updateEnabled();
        }

        public void setActiveView(FreakInternalFrame frame) {
            this.activeView = frame;
            this.updateEnabled();
        }

        public void unsetActiveView(FreakInternalFrame frame) {
            if (this.activeView == frame) {
                this.activeView = null;
            }
            this.updateEnabled();
        }

        public FreakInternalFrame getActiveView() {
            return this.activeView;
        }

        private void updateEnabled() {
            super.setEnabled(this.enabledFromRunControl && this.activeView != null && this.activeView.getView() instanceof Configurable);
            if (!this.enabledFromRunControl) {
                RunFrame.this.jMenuItemConfigureView.setToolTipText("Configuring is only permitted in suspended mode");
            } else if (this.activeView == null) {
                RunFrame.this.jMenuItemConfigureView.setToolTipText("No view selected");
            } else if (!(this.activeView.getView() instanceof Configurable)) {
                RunFrame.this.jMenuItemConfigureView.setToolTipText("Selected view is not configurable");
            } else {
                RunFrame.this.jMenuItemConfigureView.setToolTipText("Configure the selected view");
            }
        }
    }
}

