/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class SP2
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable {
    private int k = 1;

    public SP2(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        BitSet tbs;
        BitSet bs = ((BitStringGenotype)genotype).getBitSet();
        int cardinality = bs.cardinality();
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int maxOnes = (int)Math.ceil((double)n / (double)(3 * this.k)) * this.k;
        if (cardinality % this.k == 0 && cardinality <= maxOnes) {
            tbs = new BitSet(n);
            tbs.set(0, cardinality);
            if (bs.equals(tbs)) {
                return n * (cardinality + 1);
            }
        }
        if (cardinality % this.k == 0 && cardinality <= maxOnes - this.k) {
            tbs = new BitSet(n);
            tbs.set(n - cardinality, n);
            if (bs.equals(tbs)) {
                return n * (cardinality + 1);
            }
        }
        return n - cardinality;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        return (double)n * (Math.ceil((double)n / (double)(3 * this.k)) * (double)this.k + 1.0);
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(n);
        bs.set(0, (int)Math.ceil((double)n / (double)(3 * this.k)) * this.k);
        return new BitStringGenotype(bs, n);
    }

    public void setPropertyK(Integer k) {
        if (k > 0) {
            this.k = k;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public String getLongDescriptionForK() {
        return "k";
    }

    public String getShortDescriptionForK() {
        return "k";
    }

    public String getDescription() {
        return "Two Short Paths k is very similar to Short Path k but with two short paths, both starting in 0^n. One of the form 1^i0^(n-i) leading to the unique global optimum, the other of the form 0i1n-i leading to a local optimum. For symmetry reasons, the (1+1) EA will reach the local optimum in about half of the runs. Then, a direct mutation of at least (2/3)n - k bits is necessary to reach the optimum. Thus, the (1+1) EA is very efficient in about half of the runs and very inefficient in about the other half of the runs and thus very inefficient on average.";
    }

    public String getName() {
        return "Two Short Paths k";
    }
}

