/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.SearchSpace;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.Cycle;
import freak.module.searchspace.Permutation;
import freak.module.searchspace.PermutationGenotype;

public class OrderCrossover
extends MultiPairwiseCrossover
implements CompatibleWithDifferentSearchSpaces {
    public OrderCrossover(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof Permutation) && !(searchspace instanceof Cycle)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int[] gt1 = ((PermutationGenotype)ind1.getGenotype()).getIntArray();
        int[] gt2 = ((PermutationGenotype)ind2.getGenotype()).getIntArray();
        int[] newGt = new int[gt1.length];
        boolean[] visited = new boolean[gt1.length];
        int numVis = 0;
        int i = 0;
        while (i < gt1.length) {
            visited[i] = false;
            ++i;
        }
        int xover1 = re.choose(0, gt1.length - 2);
        int xover2 = re.choose(xover1 + 1, gt1.length - 1);
        int i2 = 0;
        while (i2 < xover2 - xover1) {
            newGt[i2] = gt1[xover1 + i2 + 1];
            visited[gt1[xover1 + i2 + 1] - 1] = true;
            ++i2;
        }
        numVis = xover2 - xover1;
        i2 = xover2;
        while (numVis < gt1.length) {
            i2 = i2 == gt1.length - 1 ? 0 : ++i2;
            if (visited[gt2[i2] - 1]) continue;
            visited[gt2[i2] - 1] = true;
            newGt[numVis] = gt2[i2];
            ++numVis;
        }
        return new Individual(this.graph.getSchedule(), new PermutationGenotype(newGt), new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        return "Order crossover is based on 2 point crossover.  At first, 2 crossing points are chosen at random. These crossing points divide each individual in 3 parts.\nFor example, 12|3456|789 and 84|1593|627. The information in the middle part of the first individual is taken over, so we get the permutation ??|3456|??? \nThe remaining values (1,2,7,8,9) are inserted (starting in the right part) in the order (2,7,8,1,9) in which they appear in the second individual starting in the right part. So, the created child is: 193456278.";
    }

    public String getName() {
        return "Order Crossover";
    }
}

