/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.SearchSpace;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.Cycle;
import freak.module.searchspace.Permutation;
import freak.module.searchspace.PermutationGenotype;

public class PartiallyMappedCrossover
extends MultiPairwiseCrossover
implements CompatibleWithDifferentSearchSpaces {
    public PartiallyMappedCrossover(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof Permutation) && !(searchspace instanceof Cycle)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    private int[] calculateInverse(int[] perm) {
        int[] inv = new int[perm.length];
        int i = 0;
        while (i < perm.length) {
            inv[perm[i] - 1] = i;
            ++i;
        }
        return inv;
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int[] gt1 = ((PermutationGenotype)ind1.getGenotype()).getIntArray();
        int[] gt2 = ((PermutationGenotype)ind2.getGenotype()).getIntArray();
        int[] newGt = new int[gt1.length];
        int[] gt2Inv = this.calculateInverse(gt2);
        int xover1 = re.choose(0, gt1.length - 2);
        int xover2 = re.choose(xover1 + 1, gt1.length - 1);
        boolean[] inserted = new boolean[gt1.length];
        int i = 0;
        while (i < gt1.length) {
            inserted[i] = false;
            ++i;
        }
        i = xover1 + 1;
        while (i <= xover2) {
            newGt[i] = gt1[i];
            inserted[newGt[i] - 1] = true;
            ++i;
        }
        i = xover1 + 1;
        while (i <= xover2) {
            if (!inserted[gt2[i] - 1]) {
                int pos = i;
                while (xover1 < pos && pos <= xover2) {
                    pos = gt2Inv[gt1[pos] - 1];
                }
                newGt[pos] = gt2[i];
            }
            ++i;
        }
        i = 0;
        while (i <= xover1) {
            if (!inserted[gt2[i] - 1]) {
                newGt[i] = gt2[i];
            }
            ++i;
        }
        i = xover2 + 1;
        while (i < gt1.length) {
            if (!inserted[gt2[i] - 1]) {
                newGt[i] = gt2[i];
            }
            ++i;
        }
        return new Individual(this.graph.getSchedule(), new PermutationGenotype(newGt), new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        return "Partially Mapped (or Matched) Crossover (PMX) is a well known crossover operator for cycles. It works with different semantic on cycles and permutations, but it actually is designed to work on cycles.";
    }

    public String getName() {
        return "Partially Mapped Crossover";
    }
}

