/*
 * Decompiled with CFR 0.152.
 */
package freak.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class StreamCopy {
    public static Serializable copy(Serializable source) throws NotSerializableException {
        return StreamCopy.read(StreamCopy.serialize(source));
    }

    public static byte[] serialize(Serializable source) throws NotSerializableException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(source);
            return baos.toByteArray();
        }
        catch (NotSerializableException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static Serializable read(byte[] serializedObject) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedObject);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (Serializable)ois.readObject();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException(exc);
        }
    }
}

