/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.HeldKarpChristofides;

import edu.ucsb.cs.jicos.applications.branchandbound.tsp.HeldKarpChristofides.MSOneTPrim;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;

public class HeldKarpIterative
implements Serializable {
    private boolean tour = false;
    private int bound;
    private int upperbound;
    private MSOneTPrim onetree;
    private int iterations;
    private int iter;
    private double t;
    private double t0;
    private int[][] distance;
    private int[] included;
    private int[] includedT;
    private int[] excluded;
    private int[] excludedT;
    private double[] weight;
    public int[] degree;
    private int[] lastdegree;

    private void setOneTree(MSOneTPrim mSOneTPrim) {
        this.onetree = mSOneTPrim;
    }

    private MSOneTPrim getOneTree() {
        return this.onetree;
    }

    public HeldKarpIterative(int[][] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n, double[] dArray, int n2) {
        this.iterations = n;
        this.included = nArray2;
        this.includedT = nArray3;
        this.excluded = nArray4;
        this.excludedT = nArray5;
        this.weight = dArray;
        this.upperbound = n2;
        this.distance = nArray;
        this.degree = new int[this.distance.length];
        this.lastdegree = new int[this.distance.length];
        int n3 = 0;
        while (n3 < this.distance.length) {
            this.lastdegree[n3] = 2;
            ++n3;
        }
    }

    public int getMaxAttachedFree(int n) {
        return this.getOneTree().getMaxAttachedFree(n);
    }

    public ArrayList[] getArrayListRepresentation() {
        return this.getOneTree().getArrayListRepresentation();
    }

    private void initT0() {
        this.t0 = (double)this.getOneTree().getUnweightedCost() / (2.0 * (double)this.distance.length);
    }

    public boolean isTour() {
        return this.tour;
    }

    public void whyNotTour() {
        this.getOneTree().whyNotTour();
    }

    public String getTour() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getOneTree().debugDump());
        return new String(stringBuffer);
    }

    public void compute() {
        this.doMST();
        this.updateBound();
        this.iter = 1;
        while (this.iter < this.iterations && !this.isTour() && this.getBound() <= this.upperbound) {
            this.updateWeights();
            this.doMST();
            this.updateBound();
            if (this.getBound() > this.upperbound) {
                System.out.println("Bound: " + this.getBound() + " is greater than " + this.upperbound);
            }
            if (this.getBound() == 5567) {
                // empty if block
            }
            ++this.iter;
        }
        if (this.getBound() <= this.upperbound) {
            // empty if block
        }
    }

    private void updateBound() {
        int n = this.getOneTree().getUnweightedCost();
        if (n >= this.bound) {
            if (this.getOneTree().isTour()) {
                if (this.getOneTree().getReevaluatedTourCost() != n) {
                    System.out.println("\n*** Aggregious Error ***\n");
                    System.out.println(n + " should have been evaluated as " + this.getOneTree().getReevaluatedTourCost());
                }
                this.tour = true;
            }
        } else if (this.getOneTree().isTour()) {
            System.out.println("Tour found with bound: " + n + ". Best is " + this.bound + ". WTF?");
            System.out.println(this.getOneTree().debugDump());
            System.exit(0);
            this.tour = true;
        }
        this.bound = n > this.bound ? n : this.bound;
    }

    public int getBound() {
        return this.bound;
    }

    private void doMST() {
        System.arraycopy(this.degree, 0, this.lastdegree, 0, this.degree.length);
        this.setOneTree(new MSOneTPrim(this.distance, this.included, this.includedT, this.excluded, this.excludedT, this.weight, this.degree));
        this.getOneTree().compute();
    }

    private void updateWeights() {
        this.computeT();
        int n = 1;
        while (n < this.weight.length) {
            if (this.degree[n] != 2) {
                this.weight[n] = this.weight[n] + (0.6 * this.t * (double)(this.degree[n] - 2) + 0.4 * this.t * (double)(this.lastdegree[n] - 2));
            }
            ++n;
        }
    }

    private void computeT() {
        if (this.iter == 1) {
            this.initT0();
            this.t = this.t0;
        } else {
            this.t = (double)(this.iter - 1) * ((double)(2 * this.iterations - 5) / (2.0 * (double)(this.iterations - 1))) * this.t0 - (double)(this.iter - 2) * this.t0 + (double)((this.iter - 1) * (this.iter - 2)) / (2.0 * (double)(this.iterations - 1) * (double)(this.iterations - 2)) * this.t0;
        }
    }

    public String debugDump() {
        return this.getOneTree().debugDump();
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{};
        int n = 0;
        while (n < 10) {
            System.out.print("Seed: ");
            System.out.println(n);
            Random random = new Random(n);
            int n2 = 100;
            int[][] nArray2 = new int[n2][n2];
            double[] dArray = new double[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray2[n3][n3] = Integer.MAX_VALUE;
                int n4 = n3 + 1;
                while (n4 < n2) {
                    nArray2[n3][n4] = random.nextInt(100000);
                    nArray2[n4][n3] = nArray2[n3][n4];
                    ++n4;
                }
                ++n3;
            }
            HeldKarpIterative heldKarpIterative = new HeldKarpIterative(nArray2, nArray, nArray, nArray, nArray, 500, dArray, Integer.MAX_VALUE);
            heldKarpIterative.compute();
            ++n;
        }
    }
}

