/*
 * Decompiled with CFR 0.152.
 */
package freak.core.fitness;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractMultiObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;

public abstract class AbstractStaticMultiObjectiveFitnessFunction
extends AbstractMultiObjectiveFitnessFunction {
    public AbstractStaticMultiObjectiveFitnessFunction(Schedule schedule) {
        super(schedule);
    }

    public final double[] evaluate(Individual individual, IndividualList list) {
        Double[] d = individual.getLatestKnownFitnessValue();
        if (d != null) {
            int bound = d.length;
            double[] result = new double[bound];
            int i = 0;
            while (i < bound) {
                result[i] = d[i];
                ++i;
            }
            return result;
        }
        double[] fitness = this.evaluate(individual.getPhenotype());
        int bound = fitness.length;
        Double[] cache = new Double[bound];
        int i = 0;
        while (i < bound) {
            cache[i] = new Double(fitness[i]);
            ++i;
        }
        individual.setLatestKnownFitnessValue(cache);
        return fitness;
    }

    protected abstract double[] evaluate(Genotype var1);
}

