/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.runframe;

import freak.core.view.swingsupport.FreakSwingModel;
import java.beans.PropertyChangeEvent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class InfoPanelSpinnerModel
extends SpinnerNumberModel
implements FreakSwingModel {
    private InfoPanelSpinnerModelListener listener;
    private int simulationValue;
    private boolean flushing;
    private boolean textChanging;
    private boolean textReset;

    InfoPanelSpinnerModel() {
    }

    public void setView(JSpinner spinner) {
        spinner.setModel(this);
        spinner.setEditor(new InfoPanelSpinnerEditor(spinner));
    }

    public void setValue(Object value) {
        if (this.flushing || this.textReset) {
            return;
        }
        int oldValue = this.getNumber().intValue();
        int newValue = (Integer)value;
        if (this.textChanging) {
            this.listener.absoluteChangeRequest(newValue);
            this.textReset = true;
            this.fireStateChanged();
            this.textReset = false;
        } else {
            this.listener.relativeChangeRequest(newValue - oldValue);
        }
    }

    public void setSimulationValue(int simulationValue) {
        this.simulationValue = simulationValue;
    }

    public void flush() {
        this.flushing = true;
        super.setValue(new Integer(this.simulationValue));
        this.flushing = false;
    }

    public void setListener(InfoPanelSpinnerModelListener listener) {
        this.listener = listener;
    }

    class InfoPanelSpinnerEditor
    extends JSpinner.NumberEditor {
        public InfoPanelSpinnerEditor(JSpinner spinner) {
            super(spinner);
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() instanceof JFormattedTextField && e.getPropertyName().equals("value")) {
                InfoPanelSpinnerModel.this.textChanging = true;
                super.propertyChange(e);
                InfoPanelSpinnerModel.this.textChanging = false;
            } else {
                super.propertyChange(e);
            }
        }
    }

    static interface InfoPanelSpinnerModelListener {
        public void absoluteChangeRequest(int var1);

        public void relativeChangeRequest(int var1);
    }
}

