/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.control.EventController;
import freak.core.control.Schedule;
import freak.core.modulesupport.ModuleCollector;
import freak.gui.scheduleeditor.ScheduleDependencyChecker;
import freak.gui.scheduleeditor.ScheduleEditor;
import freak.gui.scheduleeditor.Util;
import javax.swing.JPanel;

public abstract class ScheduleEditorPanel
extends JPanel {
    protected Schedule schedule;
    protected ScheduleEditor scheduleEditor;
    protected ScheduleDependencyChecker scheduleDependencyChecker;
    protected ModuleCollector moduleCollector;
    protected EventController eventController;

    public ScheduleEditorPanel(ScheduleEditor scheduleEditor) {
        this.scheduleEditor = scheduleEditor;
        this.schedule = scheduleEditor.getSchedule();
        this.scheduleDependencyChecker = scheduleEditor.getScheduleDependencyChecker();
        this.moduleCollector = new ModuleCollector(this.schedule);
        this.eventController = this.schedule.getEventController();
    }

    protected void initForStartedSchedule() {
    }

    public void enter() {
        if (Util.scheduleStarted(this.schedule)) {
            this.initForStartedSchedule();
        }
    }

    public boolean mayAdvance() {
        return true;
    }

    public boolean mayStepBack() {
        return true;
    }

    public boolean advanceVeto() {
        return false;
    }

    public boolean stepBackVeto() {
        return false;
    }

    public static String getDescription() {
        return "no description";
    }

    public String getHelpURL() {
        if (Util.scheduleStarted(this.schedule)) {
            return "node5.html#SECTION00530000000000000000";
        }
        return "node4.html";
    }
}

