/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo;

import edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo.Complet;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo.Controller;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo.Model;
import edu.ucsb.cs.jicos.applications.utilities.graph.GraphEuclidean;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

final class View
extends JPanel
implements Observer {
    private static final int OFFSET = 10;
    private static final int SIZE = 670;
    static final int MAXSIZE = 700;
    static final int WORK = 25000;
    private static final int CODE = -16777216;
    private int b;
    private int c;
    private int colorBits;
    private int colr;
    private int pixel;
    private int[] p = new int[490000];
    private int[] colors = new int[24];
    private Model model;

    public View(Model model, Controller controller) {
        this.model = model;
        this.setSize(700, 700);
        model.addObserver(this);
        this.addMouseListener(controller);
        int n = 0;
        while (n < 24) {
            this.colors[n] = 1 << n;
            ++n;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(700, 700);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawCappello3(graphics);
        this.drawVertices(graphics);
        graphics.setColor(Color.black);
        graphics.drawRect(10, 10, 680, 680);
    }

    void drawCappello3(Graphics graphics) {
        GraphEuclidean graphEuclidean = this.model.getGraph();
        graphEuclidean.drawCappello3(graphics, 10, 10, 670);
    }

    void drawMatching(Graphics graphics) {
        GraphEuclidean graphEuclidean = this.model.getGraph();
        graphEuclidean.drawMatching(graphics, 10, 10, 670);
    }

    void drawTour(Graphics graphics) {
        GraphEuclidean graphEuclidean = this.model.getGraph();
        graphEuclidean.drawTour(graphics, 10, 10, 670);
    }

    void drawVertices(Graphics graphics) {
        GraphEuclidean graphEuclidean = this.model.getGraph();
        graphics.drawRect(10, 10, 680, 680);
        graphEuclidean.drawVertices(graphics, 10, 10, 670);
    }

    private final int encodePixel(int n, int n2) {
        this.pixel = -16777216;
        int n3 = 1 << 3 * n2;
        if (n != n3) {
            this.b = 0;
            while (this.b < 3) {
                this.c = 0;
                while (this.c < n2) {
                    this.colr = (n & 1) == 1 ? this.colors[8 - n2 + (this.b << 3) + this.c] : 0;
                    this.pixel |= this.colr;
                    n >>= 1;
                    ++this.c;
                }
                ++this.b;
            }
        }
        return this.pixel;
    }

    private int[][] parCompute(double d, double d2, double d3, int n, int n2) {
        int n3 = Math.max(1, n * n2 / 25000);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n3) {
                Complet complet = new Complet(d, d2, d3, n, n2);
                ++n5;
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < n3) {
            int n7 = 0;
            while (n7 < n3) {
                ++n7;
            }
            ++n6;
        }
        int[][] nArray = new int[n][n];
        return nArray;
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }
}

