/*
 * Decompiled with CFR 0.152.
 */
package freak.core.view.swingsupport;

import freak.core.view.swingsupport.FreakTableModel;
import freak.core.view.swingsupport.UpdateManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class FreakSmallTableModel
implements FreakTableModel {
    private transient ReadCopyModel readCopy;
    private transient JTable table;
    private String[] columnNames;
    private List data = new LinkedList();
    private Object defaultValue = "";
    private boolean structureChanged = true;

    public FreakSmallTableModel(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setView(JTable view) {
        this.table = view;
        this.readCopy = new ReadCopyModel();
        this.flush();
        this.table.setModel(this.readCopy);
    }

    public void addRow(Object[] rowData) {
        this.data.add(rowData);
    }

    public void removeFirstRow() {
        this.data.remove(0);
    }

    public Object[] getRow(int rowNumber) {
        return (Object[])this.data.get(rowNumber);
    }

    public void clear() {
        this.data.clear();
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.structureChanged = true;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public void flush() {
        if (this.readCopy == null) {
            return;
        }
        if (this.table.getTableHeader().getDraggedColumn() != null) {
            UpdateManager.markDirty(this);
            return;
        }
        this.readCopy.data = (Object[][])this.data.toArray((T[])new Object[this.data.size()][]);
        this.readCopy.columnNames = this.columnNames;
        this.readCopy.defaultValue = this.defaultValue;
        if (this.structureChanged) {
            this.readCopy.fireTableStructureChanged();
            this.structureChanged = false;
        } else {
            this.readCopy.fireTableDataChanged();
        }
    }

    private static class ReadCopyModel
    extends AbstractTableModel {
        Object[][] data;
        String[] columnNames;
        Object defaultValue;

        private ReadCopyModel() {
        }

        public int getRowCount() {
            return this.data.length;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object[] rowData = this.data[rowIndex];
            if (columnIndex < rowData.length) {
                return rowData[columnIndex];
            }
            return this.defaultValue;
        }
    }
}

