/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace.logictree;

import com.Ostermiller.util.CSVParser;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.Freak;
import freak.core.control.Schedule;
import freak.module.searchspace.logictree.OperatorNodeVector;
import freak.module.searchspace.logictree.RData;
import freak.module.searchspace.logictree.StaticCompareNode;
import freak.module.searchspace.logictree.StaticConstantNode;
import freak.module.searchspace.logictree.StaticInputNode;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;

public class Data
implements Serializable {
    public static int compareNodeSet = 1;
    public static boolean csvDisable = false;
    public static RData testData = null;
    public static RData trainingData = null;
    public static BitSet lineValues;
    private static String path;
    private static boolean valid;
    private static boolean read;
    private static int numVars;
    private static int numRows;
    private static int num1Rows;
    private static int[][] values;
    private static int[][] cvalues;
    private static boolean[] results;
    private static BitSet resultsBS;
    private static String[] names;
    private static int[] minValue;
    private static int[] maxValue;
    private static OperatorNodeVector compareSubtrees;
    private static boolean exclude;
    private static boolean debug;
    private static Schedule schedule;
    private static RandomElement randGen;

    static {
        valid = false;
        read = false;
        exclude = true;
        debug = false;
    }

    public static void clear() {
        csvDisable = false;
        testData = null;
        trainingData = null;
    }

    public static void setRandomElement(Schedule se) {
        schedule = se;
        randGen = schedule.getRandomElement();
    }

    public static int getNumVar() {
        if (read) {
            return numVars;
        }
        return -1;
    }

    public static int getNumRows() {
        if (read) {
            return numRows;
        }
        return -1;
    }

    public static int getNum1Rows() {
        if (read) {
            return num1Rows;
        }
        return -1;
    }

    public static int getNum0Rows() {
        if (read) {
            return numRows - num1Rows;
        }
        return -1;
    }

    public static int[] getRowByNumber(int nr) {
        if (read) {
            return values[nr];
        }
        return null;
    }

    public static boolean getResultOfNr(int nr) {
        if (read) {
            return results[nr];
        }
        return false;
    }

    public static BitSet getResultBitSet() {
        return (BitSet)resultsBS.clone();
    }

    public static int getMaxValue(int var) {
        if (read && var < numVars) {
            return maxValue[var];
        }
        return -1;
    }

    public static int getMinValue(int var) {
        if (read && var < numVars) {
            return minValue[var];
        }
        return -1;
    }

    public static String getVarName(int var) {
        return names[var];
    }

    public static String getDataLocation() {
        return path;
    }

    public static boolean setDataLocation(String pathV) {
        boolean change;
        try {
            new FileReader(pathV);
            change = true;
        }
        catch (IOException e) {
            if (!csvDisable) {
                System.out.println("The given path to a datasheet was not valid!");
                System.out.println("The path will not be changed, it remains " + path);
                System.out.println("Current path valid: " + valid);
            }
            change = false;
        }
        if (change) {
            path = pathV;
            valid = true;
            Freak.debug("Path was changed to the valid path " + pathV, 1);
        }
        return change;
    }

    private static void setMaxAsThree() {
        maxValue = new int[numVars];
        int i = 0;
        while (i < numVars) {
            Data.maxValue[i] = 3;
            ++i;
        }
    }

    private static void constructCompares() {
        if (compareNodeSet != 1) {
            exclude = false;
        }
        compareSubtrees = new OperatorNodeVector();
        int i = 0;
        while (i < numVars) {
            int minI = Data.getMinValue(i);
            int maxI = Data.getMaxValue(i);
            int j = minI;
            while (j <= maxI) {
                if (!exclude || j != minI + 1) {
                    StaticConstantNode cn1 = new StaticConstantNode(j);
                    StaticInputNode in1 = new StaticInputNode(i);
                    StaticCompareNode com1 = new StaticCompareNode(cn1, in1, false, true, false, numRows, values);
                    Freak.debug(com1.toString(), 4);
                    compareSubtrees.add(com1);
                    StaticConstantNode cn3 = new StaticConstantNode(j);
                    StaticInputNode in3 = new StaticInputNode(i);
                    StaticCompareNode com3 = new StaticCompareNode(cn3, in3, true, false, true, numRows, values);
                    Freak.debug(com3.toString(), 4);
                    compareSubtrees.add(com3);
                    if (j != minI && j != minI + 1 && j != maxI && compareNodeSet < 3) {
                        StaticConstantNode cn2 = new StaticConstantNode(j);
                        StaticInputNode in2 = new StaticInputNode(i);
                        StaticCompareNode com2 = new StaticCompareNode(cn2, in2, false, true, true, numRows, values);
                        Freak.debug(com2.toString(), 4);
                        compareSubtrees.add(com2);
                    }
                    if (j != minI && j != maxI - 1 && j != maxI && compareNodeSet < 3) {
                        StaticConstantNode cn4 = new StaticConstantNode(j);
                        StaticInputNode in4 = new StaticInputNode(i);
                        StaticCompareNode com4 = new StaticCompareNode(cn4, in4, true, true, false, numRows, values);
                        Freak.debug(com4.toString(), 4);
                        compareSubtrees.add(com4);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static int nextRandInt(int max) {
        int zz = randGen.choose(0, max - 1);
        return zz;
    }

    public static boolean nextRandBoolean() {
        return randGen.choose(0, 1) == 1;
    }

    public static OperatorNodeVector getCompareSubtrees() {
        if (read) {
            return compareSubtrees;
        }
        return null;
    }

    public static boolean compareNodeValid(StaticCompareNode cn) {
        return compareSubtrees.contains(cn);
    }

    public static int getIndexOfCompareNode(StaticCompareNode cn) {
        int index = -1;
        Iterator it = compareSubtrees.iterator();
        while (it.hasNext()) {
            ++index;
            if (!((StaticCompareNode)it.next()).toString().equals(cn.toString())) continue;
            return index;
        }
        return index;
    }

    public static StaticCompareNode getCompareNode(int i) {
        return (StaticCompareNode)compareSubtrees.get(i);
    }

    public static int getNumCompareNodes() {
        return compareSubtrees.size();
    }

    public static StaticCompareNode getExistingCompareNodeRandomly() {
        if (read) {
            if (compareSubtrees.size() == 0) {
                return null;
            }
            int nr = Data.nextRandInt(compareSubtrees.size());
            return (StaticCompareNode)compareSubtrees.get(nr);
        }
        return null;
    }

    private static int convertObjToInt(String obj) {
        int result = 0;
        if (obj.equals("true") || obj.equals("case") || obj.equals("wahr") || obj.equals("Fall")) {
            return 1;
        }
        if (obj.equals("false") || obj.equals("control") || obj.equals("Kontrolle") || obj.equals("falsch")) {
            return 0;
        }
        try {
            result = new Integer(obj);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("The string '" + obj + "' was contained in the input table and is unknown!");
        }
        return result;
    }

    public static void readData() throws IOException {
        if (!csvDisable) {
            int j;
            FileReader in;
            if (valid) {
                try {
                    in = new FileReader(path);
                }
                catch (IOException e) {
                    throw new IOException("Path to datasheet is no longer valid! (" + path + ")");
                }
            } else {
                throw new IOException("Before reading data, a valid path must be set! (" + path + ")");
            }
            String[][] svalues = CSVParser.parse((Reader)in, (char)';');
            numRows = svalues.length - 1;
            num1Rows = 0;
            numVars = svalues[0].length - 1;
            values = new int[numRows][];
            cvalues = new int[numVars][];
            int[] iresults = new int[numRows];
            results = new boolean[numRows];
            maxValue = new int[numVars];
            minValue = new int[numVars];
            names = new String[numVars];
            int i = 1;
            while (i <= numVars) {
                Data.names[i - 1] = svalues[0][i];
                ++i;
            }
            Freak.debug("Tabular has " + numRows + " rows and " + numVars + " variables.", 2);
            if (debug) {
                System.out.print("       ");
                i = 0;
                while (i < numVars) {
                    System.out.print(names[i].charAt(names[i].length() - 2));
                    System.out.print(String.valueOf(names[i].charAt(names[i].length() - 1)) + " ");
                    ++i;
                }
                System.out.println();
            }
            i = 1;
            while (i <= numVars) {
                Data.cvalues[i - 1] = new int[numRows];
                ++i;
            }
            lineValues = new BitSet(numRows);
            i = 1;
            while (i <= numRows) {
                Data.values[i - 1] = new int[numVars];
                iresults[i - 1] = Data.convertObjToInt(svalues[i][0]);
                Data.results[i - 1] = iresults[i - 1] == 1;
                lineValues.set(i - 1, results[i - 1]);
                if (results[i - 1]) {
                    ++num1Rows;
                }
                if (debug) {
                    System.out.print("Row " + i + ": ");
                }
                j = 1;
                while (j <= numVars) {
                    Data.values[i - 1][j - 1] = new Integer(svalues[i][j]);
                    Data.cvalues[j - 1][i - 1] = new Integer(svalues[i][j]);
                    if (debug) {
                        System.out.print(" " + values[i - 1][j - 1] + " ");
                    }
                    ++j;
                }
                if (debug) {
                    System.out.println(results[i - 1]);
                }
                ++i;
            }
            int j2 = 0;
            while (j2 < numVars) {
                if (numRows == 0) {
                    Data.maxValue[j2] = -1;
                    Data.minValue[j2] = -1;
                } else {
                    Data.maxValue[j2] = cvalues[j2][0];
                    Data.minValue[j2] = cvalues[j2][0];
                }
                int i2 = 0;
                while (i2 < numRows) {
                    if (cvalues[j2][i2] > maxValue[j2]) {
                        Data.maxValue[j2] = cvalues[j2][i2];
                    }
                    if (cvalues[j2][i2] < minValue[j2]) {
                        Data.minValue[j2] = cvalues[j2][i2];
                    }
                    ++i2;
                }
                ++j2;
            }
            if (debug) {
                j2 = 0;
                while (j2 < numVars) {
                    System.out.print(names[j2].charAt(names[j2].length() - 2));
                    System.out.print(String.valueOf(names[j2].charAt(names[j2].length() - 1)) + " ");
                    ++j2;
                }
                System.out.println();
                i = 0;
                while (i < numRows) {
                    System.out.print("Row " + i + ":  ");
                    j = 0;
                    while (j < numVars) {
                        System.out.print(String.valueOf(cvalues[j][i]) + "  ");
                        ++j;
                    }
                    System.out.println(results[i]);
                    ++i;
                }
                j2 = 0;
                while (j2 < numVars) {
                    System.out.print("---");
                    ++j2;
                }
                System.out.println("-------------");
                System.out.print("max     ");
                j2 = 0;
                while (j2 < numVars) {
                    System.out.print(String.valueOf(maxValue[j2]) + "  ");
                    ++j2;
                }
                System.out.println();
                System.out.print("min     ");
                j2 = 0;
                while (j2 < numVars) {
                    System.out.print(String.valueOf(minValue[j2]) + "  ");
                    ++j2;
                }
                System.out.println();
            }
            read = true;
            Freak.debug("0-Rows: " + Data.getNum0Rows() + ", 1-Rows: " + Data.getNum1Rows(), 2);
            Data.constructCompares();
            Freak.viewFilenameInTitle(path);
            resultsBS = new BitSet(results.length);
            i = 0;
            while (i < results.length) {
                if (results[i]) {
                    resultsBS.set(i);
                } else {
                    resultsBS.clear(i);
                }
                ++i;
            }
        }
    }

    public static void setRData(RData data) {
        Data.rReadData(data.getValues(), data.getDim(), data.getNames());
    }

    public static void rReadData(int[] rValues, int[] rDim, String[] rNames) {
        int j;
        int i;
        Freak.debug("\nrValues[0]: " + rValues[0] + "\nrDim[0] " + rDim[0] + "\nrDim[1] " + rDim[1] + "\nrNames[0] " + rNames[0], 2);
        String[][] svalues = new String[rDim[0] + 1][rDim[1]];
        int j2 = 0;
        while (j2 <= rDim[1] - 1) {
            svalues[0][j2] = rNames[j2];
            ++j2;
        }
        int rValuesIndex = 0;
        int j3 = 0;
        while (j3 <= svalues[0].length - 1) {
            i = 1;
            while (i <= svalues.length - 1) {
                svalues[i][j3] = Integer.toString(rValues[rValuesIndex]);
                ++rValuesIndex;
                ++i;
            }
            ++j3;
        }
        numRows = svalues.length - 1;
        num1Rows = 0;
        numVars = svalues[0].length - 1;
        values = new int[numRows][];
        cvalues = new int[numVars][];
        int[] iresults = new int[numRows];
        results = new boolean[numRows];
        maxValue = new int[numVars];
        minValue = new int[numVars];
        names = new String[numVars];
        int i2 = 1;
        while (i2 <= numVars) {
            Data.names[i2 - 1] = svalues[0][i2];
            ++i2;
        }
        Freak.debug("Tabular has " + numRows + " rows and " + numVars + " variables.", 2);
        if (debug) {
            System.out.print("       ");
            i2 = 0;
            while (i2 < numVars) {
                System.out.print(names[i2].charAt(names[i2].length() - 2));
                System.out.print(String.valueOf(names[i2].charAt(names[i2].length() - 1)) + " ");
                ++i2;
            }
            System.out.println();
        }
        i2 = 1;
        while (i2 <= numVars) {
            Data.cvalues[i2 - 1] = new int[numRows];
            ++i2;
        }
        lineValues = new BitSet(numRows);
        i2 = 1;
        while (i2 <= numRows) {
            Data.values[i2 - 1] = new int[numVars];
            iresults[i2 - 1] = Data.convertObjToInt(svalues[i2][0]);
            Data.results[i2 - 1] = iresults[i2 - 1] == 1;
            lineValues.set(i2 - 1, results[i2 - 1]);
            if (results[i2 - 1]) {
                ++num1Rows;
            }
            if (debug) {
                System.out.print("Row " + i2 + ": ");
            }
            j = 1;
            while (j <= numVars) {
                Data.values[i2 - 1][j - 1] = new Integer(svalues[i2][j]);
                Data.cvalues[j - 1][i2 - 1] = new Integer(svalues[i2][j]);
                if (debug) {
                    System.out.print(" " + values[i2 - 1][j - 1] + " ");
                }
                ++j;
            }
            if (debug) {
                System.out.println(results[i2 - 1]);
            }
            ++i2;
        }
        j3 = 0;
        while (j3 < numVars) {
            if (numRows == 0) {
                Data.maxValue[j3] = -1;
                Data.minValue[j3] = -1;
            } else {
                Data.maxValue[j3] = cvalues[j3][0];
                Data.minValue[j3] = cvalues[j3][0];
            }
            i = 0;
            while (i < numRows) {
                if (cvalues[j3][i] > maxValue[j3]) {
                    Data.maxValue[j3] = cvalues[j3][i];
                }
                if (cvalues[j3][i] < minValue[j3]) {
                    Data.minValue[j3] = cvalues[j3][i];
                }
                ++i;
            }
            ++j3;
        }
        if (debug) {
            j3 = 0;
            while (j3 < numVars) {
                System.out.print(names[j3].charAt(names[j3].length() - 2));
                System.out.print(String.valueOf(names[j3].charAt(names[j3].length() - 1)) + " ");
                ++j3;
            }
            System.out.println();
            i2 = 0;
            while (i2 < numRows) {
                System.out.print("Row " + i2 + ":  ");
                j = 0;
                while (j < numVars) {
                    System.out.print(String.valueOf(cvalues[j][i2]) + "  ");
                    ++j;
                }
                System.out.println(results[i2]);
                ++i2;
            }
            j3 = 0;
            while (j3 < numVars) {
                System.out.print("---");
                ++j3;
            }
            System.out.println("-------------");
            System.out.print("max     ");
            j3 = 0;
            while (j3 < numVars) {
                System.out.print(String.valueOf(maxValue[j3]) + "  ");
                ++j3;
            }
            System.out.println();
            System.out.print("min     ");
            j3 = 0;
            while (j3 < numVars) {
                System.out.print(String.valueOf(minValue[j3]) + "  ");
                ++j3;
            }
            System.out.println();
        }
        read = true;
        Freak.debug("0-Rows: " + Data.getNum0Rows() + ", 1-Rows: " + Data.getNum1Rows(), 2);
        Data.constructCompares();
        Freak.viewFilenameInTitle(path);
        resultsBS = new BitSet(results.length);
        i2 = 0;
        while (i2 < results.length) {
            if (results[i2]) {
                resultsBS.set(i2);
            } else {
                resultsBS.clear(i2);
            }
            ++i2;
        }
    }

    public static void setRMode() {
        csvDisable = true;
        Freak.debug("Setting class \"Data\" to R-Mode", 4);
    }

    public static void setNormalMode() {
        csvDisable = false;
        Freak.debug("Setting class \"Data\" to Normal Mode", 4);
    }

    public static int[][] getValues() {
        return values;
    }

    public static void setTestData(RData testData) {
        Data.testData = testData;
    }

    public static void setTrainingData(RData trainingData) {
        Data.trainingData = trainingData;
    }

    public static void printTable() {
        int j = 0;
        while (j < numVars) {
            System.out.print(names[j].charAt(names[j].length() - 2));
            System.out.print(String.valueOf(names[j].charAt(names[j].length() - 1)) + " ");
            ++j;
        }
        System.out.println();
        int i = 0;
        while (i < numRows) {
            System.out.print("Row " + i + ":  ");
            int j2 = 0;
            while (j2 < numVars) {
                System.out.print(String.valueOf(cvalues[j2][i]) + "  ");
                ++j2;
            }
            System.out.println(results[i]);
            ++i;
        }
        j = 0;
        while (j < numVars) {
            System.out.print("---");
            ++j;
        }
        System.out.println("-------------");
        System.out.print("max     ");
        j = 0;
        while (j < numVars) {
            System.out.print(String.valueOf(maxValue[j]) + "  ");
            ++j;
        }
        System.out.println();
        System.out.print("min     ");
        j = 0;
        while (j < numVars) {
            System.out.print(String.valueOf(minValue[j]) + "  ");
            ++j;
        }
        System.out.println();
    }

    public static void setCompareNodeSet(int compareNodeSet) {
        Data.compareNodeSet = compareNodeSet;
    }
}

