/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.services;

import edu.ucsb.cs.jicos.foundation.ServiceName;
import edu.ucsb.cs.jicos.services.HostTaskStats;
import edu.ucsb.cs.jicos.services.ServiceTaskStats;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class Invoice
implements Serializable {
    private long beginTime;
    private long endTime;
    private ServiceTaskStats hspTaskStats;
    private static String[] labels = new String[]{"\n___________________________________________\n", "\n JANET Invoice \n"};

    Invoice(long l, long l2, ServiceTaskStats serviceTaskStats) {
        this.beginTime = l;
        this.endTime = l2;
        this.hspTaskStats = serviceTaskStats;
    }

    public long beginTime() {
        return this.beginTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public ServiceTaskStats hspTaskStats() {
        return this.hspTaskStats;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(labels[0]);
        stringBuffer.append(labels[1]);
        stringBuffer.append("\n Invoice date/time: ");
        stringBuffer.append(DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        stringBuffer.append("\n Registered:   ");
        Date date = new Date(this.beginTime);
        stringBuffer.append(DateFormat.getDateTimeInstance(0, 0).format(date));
        stringBuffer.append("\n Unregistered: ");
        date = new Date(this.endTime);
        stringBuffer.append(DateFormat.getDateTimeInstance(0, 0).format(date));
        stringBuffer.append("\n Start time = " + this.beginTime / 1000L + "." + this.beginTime % 1000L);
        long l = this.endTime - this.beginTime;
        stringBuffer.append("\n Elapsed compute time = " + l / 1000L + "." + l % 1000L + " seconds \n");
        stringBuffer.append("\n Task Statistics\n");
        ServiceName serviceName = this.hspTaskStats.serviceName();
        HostTaskStats hostTaskStats = new HostTaskStats(serviceName, false);
        List list = this.hspTaskStats.serviceTaskStats();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceTaskStats serviceTaskStats = (ServiceTaskStats)iterator.next();
            ServiceName serviceName2 = serviceTaskStats.serviceName();
            HostTaskStats hostTaskStats2 = new HostTaskStats(serviceName2, false);
            List list2 = serviceTaskStats.serviceTaskStats();
            n += list2.size() - 1;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                HostTaskStats hostTaskStats3 = (HostTaskStats)iterator2.next();
                stringBuffer.append("\n     Host ");
                stringBuffer.append(hostTaskStats3.toString("         "));
                hostTaskStats2.add(hostTaskStats3);
            }
            stringBuffer.append("\n   Task Server total ");
            stringBuffer.append("Hosts: ");
            stringBuffer.append(list2.size() - 1);
            stringBuffer.append(" ");
            stringBuffer.append(hostTaskStats2.toString("       "));
            stringBuffer.append("\n");
            hostTaskStats.add(hostTaskStats2);
        }
        stringBuffer.append("\n HSP total ");
        stringBuffer.append("Hosts: ");
        stringBuffer.append(n);
        stringBuffer.append(" ");
        stringBuffer.append(hostTaskStats.toString("    "));
        stringBuffer.append("\n");
        stringBuffer.append(labels[0]);
        return new String(stringBuffer);
    }
}

