/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.population.Genotype;

public class GeneralStringGenotype
extends Genotype {
    private int numChars;
    private int[] genotype;

    public GeneralStringGenotype(int[] gen, int num) {
        this.genotype = gen;
        this.numChars = num;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GeneralStringGenotype)) {
            return false;
        }
        int[] genotype2 = ((GeneralStringGenotype)o).genotype;
        if (genotype2.length != this.genotype.length) {
            return false;
        }
        int i = 0;
        while (i < this.genotype.length) {
            if (this.genotype[i] != genotype2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 261376721;
        int i = 0;
        while (i < this.genotype.length) {
            hash = (hash << 2) + this.genotype[i] + hash / 31;
            ++i;
        }
        return hash;
    }

    public String toString() {
        StringBuffer s;
        if (this.numChars < 11) {
            s = new StringBuffer(this.genotype.length);
            int i = 0;
            while (i < this.genotype.length) {
                s.append(this.genotype[i]);
                ++i;
            }
        } else {
            s = new StringBuffer(this.genotype.length * 2 - 1);
            s.append(this.genotype[0]);
            int i = 1;
            while (i < this.genotype.length) {
                s.append("," + this.genotype[i]);
                ++i;
            }
        }
        return s.toString();
    }

    public int[] getIntArray() {
        return this.genotype;
    }

    public void set(int index, int value) {
        this.genotype[index] = value;
    }

    public int get(int index) {
        return this.genotype[index];
    }

    public void flip(int index, RandomElement re) {
        int newvalue = re.choose(0, this.numChars - 2);
        if (newvalue == this.genotype[index]) {
            newvalue = this.numChars - 1;
        }
        this.genotype[index] = newvalue;
    }

    public Object clone() {
        GeneralStringGenotype copy;
        try {
            copy = (GeneralStringGenotype)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.toString());
        }
        copy.genotype = (int[])this.genotype.clone();
        return copy;
    }
}

