% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/goals.R
\name{list_goals}
\alias{list_goals}
\title{Lists goals which the user has access to}
\usage{
list_goals(account.id = "~all", webproperty.id = "~all",
  profile.id = "~all", start.index = NULL, max.results = NULL, token)
}
\arguments{
\item{account.id}{integer or character. The account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all the accounts that user has access to.}

\item{webproperty.id}{character. Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which refers to all the web properties that user has access to. Requires specified \code{account.id}.}

\item{profile.id}{ineger or character. View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or '~all', which refers to all the views (profiles) that user has access to. Requires specified \code{account.id} and \code{webproperty.id}.}

\item{start.index}{integer. An index of the first goal to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of goals to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
A goal collection lists Analytics goals to which the user has access. Each view (profile) can have a set of goals. Each resource in the Goal collection corresponds to a single Analytics goal.
\item{id}{Goal ID (number).}
\item{account.id}{Account ID which this goal belongs to.}
\item{webproperty.id}{Web property ID which this goal belongs to. The web property ID is of the form UA-XXXXX-YY.}
\item{profile.id}{View (Profile) ID to which this goal belongs.}
\item{name}{Goal name.}
\item{value}{Goal value.}
\item{active}{Determines whether this goal is active.}
\item{type}{Goal type. Acceptable values are: "EVENT", "URL_DESTINATION", "VISIT_NUM_PAGES", "VISIT_TIME_ON_SITE"}
\item{created}{Time this goal was created.}
\item{updated}{Time this goal was last modified.}
}
\description{
Lists goals which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/goals}{Management API - Goals}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_goal}}; \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_upload}}; \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_profiles}};
  \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_uploads}};
  \code{\link{list_webproperties}}
}

