% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.stability.R
\name{plot.stability}
\alias{plot.stability}
\title{Plot a rgcca_stability object.}
\usage{
\method{plot}{stability}(x, ...)
}
\arguments{
\item{x}{Object of type "stability" produced by rgcca_stability.}

\item{...}{Arguments for the plot.rgcca function.}
}
\value{
A ggplot2 plot object.
}
\description{
The fitted RGCCA model returned by rgcca_stability is plotted.
All arguments are forwarded to the plot.rgcca function.
}
\examples{
data(Russett)
blocks <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = Russett[, 6:11]
)
fit.sgcca <- rgcca(blocks, sparsity = c(.8, .9, .6))
res <- rgcca_stability(
  fit.sgcca, n_boot = 10, verbose = TRUE, keep = rep(.1, 3)
)
plot(res, type = "weights")
}
