% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_chromatograms.R
\name{join_chromatograms}
\alias{join_chromatograms}
\title{Join multiple two-dimensional chromatograms into a single R object}
\usage{
join_chromatograms(x, y, groups, ...)
}
\arguments{
\item{x, y}{a GCxGC object, either single or batch chromatograms.}

\item{groups}{a data.frame containing the metadata. It must have a column
named as \emph{Names} to merge with the imported chromatograms.}

\item{...}{other GCxGC objects to be merged}
}
\description{
`join_chromatograms` save the chromatograms in a
 named list slot. Also, it saves information like metadata and 
 retention times.
}
\examples{

GB08_fl <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
GB09_fl <- system.file("extdata", "09GB.cdf", package = "RGCxGC")
GB08 <- read_chrom(GB08_fl, 5L)
GB09 <- read_chrom(GB09_fl, 5L)
join_gc <- join_chromatograms(GB08, GB09)
metadata <- data.frame(Names = c("GB08", "GB09"),
                       Type = c("Control", "Treatment"))
join_metadata <- join_chromatograms(GB08, GB09, groups = metadata)
}
