#include <RGtk2/gobject.h>
#include "RGtk2/libglade.h"

#include "libgladeFuncs.h"


USER_OBJECT_
S_glade_require(USER_OBJECT_ s_library)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  const gchar* library = ((const gchar*)asCString(s_library));


  glade_require(library);


  return(_result);
}
 

USER_OBJECT_
S_glade_provide(USER_OBJECT_ s_library)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  const gchar* library = ((const gchar*)asCString(s_library));


  glade_provide(library);


  return(_result);
}
 

USER_OBJECT_
S_glade_xml_get_type(void)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;

  GType ans;

  ans = glade_xml_get_type();

  _result = asRGType(ans);

  return(_result);
}
 

USER_OBJECT_
S_glade_xml_new(USER_OBJECT_ s_fname, USER_OBJECT_ s_root, USER_OBJECT_ s_domain)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  const char* fname = ((const char*)asCString(s_fname));
  const char* root = GET_LENGTH(s_root) == 0 ? NULL : ((const char*)asCString(s_root));
  const char* domain = GET_LENGTH(s_domain) == 0 ? NULL : ((const char*)asCString(s_domain));

  GladeXML* ans;

  ans = glade_xml_new(fname, root, domain);

  _result = toRPointerWithFinalizer(ans, "GladeXML", (RPointerFinalizer) g_object_unref);

  return(_result);
}
 

USER_OBJECT_
S_glade_xml_new_from_buffer(USER_OBJECT_ s_buffer, USER_OBJECT_ s_size, USER_OBJECT_ s_root, USER_OBJECT_ s_domain)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  const char* buffer = ((const char*)asCString(s_buffer));
  int size = ((int)asCInteger(s_size));
  const char* root = GET_LENGTH(s_root) == 0 ? NULL : ((const char*)asCString(s_root));
  const char* domain = GET_LENGTH(s_domain) == 0 ? NULL : ((const char*)asCString(s_domain));

  GladeXML* ans;

  ans = glade_xml_new_from_buffer(buffer, size, root, domain);

  _result = toRPointerWithFinalizer(ans, "GladeXML", (RPointerFinalizer) g_object_unref);

  return(_result);
}
 

USER_OBJECT_
S_glade_xml_signal_connect_full(USER_OBJECT_ s_object, USER_OBJECT_ s_handler_name, USER_OBJECT_ s_func, USER_OBJECT_ s_user_data)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  GladeXMLConnectFunc func = ((GladeXMLConnectFunc)S_GladeXMLConnectFunc);
  R_CallbackData* user_data = R_createCBData(s_func, s_user_data);
  GladeXML* object = GLADE_XML(getPtrValue(s_object));
  const gchar* handler_name = ((const gchar*)asCString(s_handler_name));


  glade_xml_signal_connect_full(object, handler_name, func, user_data);

  R_freeCBData(user_data);

  return(_result);
}
 

USER_OBJECT_
S_glade_xml_signal_autoconnect_full(USER_OBJECT_ s_object, USER_OBJECT_ s_func, USER_OBJECT_ s_user_data)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  GladeXMLConnectFunc func = ((GladeXMLConnectFunc)S_GladeXMLConnectFunc);
  R_CallbackData* user_data = R_createCBData(s_func, s_user_data);
  GladeXML* object = GLADE_XML(getPtrValue(s_object));


  glade_xml_signal_autoconnect_full(object, func, user_data);

  R_freeCBData(user_data);

  return(_result);
}
 

USER_OBJECT_
S_glade_xml_get_widget(USER_OBJECT_ s_object, USER_OBJECT_ s_name)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  GladeXML* object = GLADE_XML(getPtrValue(s_object));
  const char* name = ((const char*)asCString(s_name));

  GtkWidget* ans;

  ans = glade_xml_get_widget(object, name);

  _result = toRPointerWithSink(ans, "GtkWidget");

  return(_result);
}
 

USER_OBJECT_
S_glade_xml_get_widget_prefix(USER_OBJECT_ s_object, USER_OBJECT_ s_name)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  GladeXML* object = GLADE_XML(getPtrValue(s_object));
  const char* name = ((const char*)asCString(s_name));

  GList* ans;

  ans = glade_xml_get_widget_prefix(object, name);

  _result = asRGListWithSink(ans, "GtkWidget");

  return(_result);
}
 

USER_OBJECT_
S_glade_get_widget_name(USER_OBJECT_ s_widget)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  GtkWidget* widget = GTK_WIDGET(getPtrValue(s_widget));

  const char* ans;

  ans = glade_get_widget_name(widget);

  _result = asRString(ans);

  return(_result);
}
 

USER_OBJECT_
S_glade_get_widget_tree(USER_OBJECT_ s_widget)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  GtkWidget* widget = GTK_WIDGET(getPtrValue(s_widget));

  GladeXML* ans;

  ans = glade_get_widget_tree(widget);

  _result = toRPointerWithRef(ans, "GladeXML");

  return(_result);
}
 

USER_OBJECT_
S_glade_set_custom_handler(USER_OBJECT_ s_handler, USER_OBJECT_ s_user_data)
{
  USER_OBJECT_ _result = NULL_USER_OBJECT;
  GladeXMLCustomWidgetHandler handler = ((GladeXMLCustomWidgetHandler)S_GladeXMLCustomWidgetHandler);
  R_CallbackData* user_data = R_createCBData(s_handler, s_user_data);


  glade_set_custom_handler(handler, user_data);

  R_freeCBData(user_data);

  return(_result);
}
 

