/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import org.h2.message.DbException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystem;
import org.h2.store.fs.FileSystemSplit;
import org.h2.util.IOUtils;

public class FileObjectSplit
implements FileObject {
    private final String name;
    private final String mode;
    private final long maxLength;
    private FileObject[] list;
    private long filePointer;
    private long length;

    FileObjectSplit(String string, String string2, FileObject[] fileObjectArray, long l, long l2) {
        this.name = string;
        this.mode = string2;
        this.list = fileObjectArray;
        this.length = l;
        this.maxLength = l2;
    }

    public void close() throws IOException {
        for (FileObject fileObject : this.list) {
            fileObject.close();
        }
    }

    public long getFilePointer() {
        return this.filePointer;
    }

    public long length() {
        return this.length;
    }

    private int read(byte[] byArray, int n, int n2) throws IOException {
        long l = this.filePointer % this.maxLength;
        int n3 = (int)Math.min((long)n2, this.maxLength - l);
        FileObject fileObject = this.getFileObject();
        fileObject.seek(l);
        fileObject.readFully(byArray, n, n3);
        this.filePointer += (long)n3;
        return n3;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.filePointer + (long)n2 > this.length) {
            throw new EOFException();
        }
        int n3;
        while ((n2 -= (n3 = this.read(byArray, n, n2))) > 0) {
            n += n3;
        }
        return;
    }

    public void seek(long l) {
        this.filePointer = l;
    }

    private FileObject getFileObject() throws IOException {
        int n = (int)(this.filePointer / this.maxLength);
        while (n >= this.list.length) {
            int n2 = this.list.length;
            FileObject[] fileObjectArray = new FileObject[n2 + 1];
            System.arraycopy(this.list, 0, fileObjectArray, 0, n2);
            String string = FileSystemSplit.getFileName(this.name, n2);
            fileObjectArray[n2] = FileSystem.getInstance(string).openFileObject(string, this.mode);
            this.list = fileObjectArray;
        }
        return this.list[n];
    }

    public void setFileLength(long l) throws IOException {
        this.filePointer = Math.min(this.filePointer, l);
        int n = 1 + (int)(l / this.maxLength);
        if (n == this.list.length) {
            long l2 = l - this.maxLength * (long)(n - 1);
            this.list[this.list.length - 1].setFileLength(l2);
        } else {
            int n2;
            FileObject[] fileObjectArray = new FileObject[n];
            int n3 = Math.max(n, this.list.length);
            long l3 = l;
            for (n2 = this.list.length - 1; n2 >= n; --n2) {
                this.list[n2].setFileLength(0L);
                this.list[n2].close();
                try {
                    IOUtils.delete(this.list[n2].getName());
                    continue;
                }
                catch (DbException dbException) {
                    throw DbException.convertToIOException(dbException);
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Object object;
                long l4 = Math.min(l3, this.maxLength);
                l3 -= l4;
                if (n2 >= n) continue;
                if (n2 >= this.list.length) {
                    object = FileSystemSplit.getFileName(this.name, n2);
                    FileObject fileObject = FileSystem.getInstance((String)object).openFileObject((String)object, this.mode);
                    fileObject.setFileLength(l4);
                    fileObjectArray[n2] = fileObject;
                    continue;
                }
                object = this.list[n2];
                if (object.length() != l4) {
                    object.setFileLength(l4);
                }
                fileObjectArray[n2] = this.list[n2];
            }
            this.list = fileObjectArray;
        }
        this.length = l;
    }

    public void sync() throws IOException {
        for (FileObject fileObject : this.list) {
            fileObject.sync();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        while ((n2 -= (n3 = this.writePart(byArray, n, n2))) > 0) {
            n += n3;
        }
        return;
    }

    private int writePart(byte[] byArray, int n, int n2) throws IOException {
        long l = this.filePointer % this.maxLength;
        int n3 = (int)Math.min((long)n2, this.maxLength - l);
        FileObject fileObject = this.getFileObject();
        fileObject.seek(l);
        fileObject.write(byArray, n, n3);
        this.filePointer += (long)n3;
        this.length = Math.max(this.length, this.filePointer);
        return n3;
    }

    public String getName() {
        return "split:" + this.name;
    }

    public boolean tryLock() {
        return this.list[0].tryLock();
    }

    public void releaseLock() {
        this.list[0].releaseLock();
    }
}

