% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRT.R
\name{calcTS}
\alias{calcTS}
\alias{calcTS,HRT-method}
\title{Calculate TS parameters}
\usage{
calcTS(HRTObj, normalising = FALSE, IL = c_normIL, normIL = c_normIL)

\S4method{calcTS}{HRT}(HRTObj, normalising = FALSE, IL = c_normIL, normIL = c_normIL)
}
\arguments{
\item{HRTObj}{(HRT) The HRT object, for which TS should be calculated}

\item{normalising}{(Boolean) Should the normalised TS be calculated?}

\item{IL}{(Numeric) The overall arithmetic mean of the interval length of the
measurement to normalise TS}

\item{normIL}{(Numeric) The interval length to which TS should be normalised}
}
\value{
(HRT) An HRT object with (re)calculated TS+intercept or nTS+nintercept
}
\description{
Calculates all TS parameters (TS itself, its index TT (turbulence timing)
and the intercept for the plot) and saves them in the corresponding slots.
Can also calculate normalised TS and intercept.
}
