/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.util.ProcessTree;
import org.apache.hadoop.util.Shell;

public class DefaultTaskController
extends TaskController {
    private static final Log LOG = LogFactory.getLog(DefaultTaskController.class);

    @Override
    void launchTaskJVM(TaskController.TaskControllerContext context) throws IOException {
        Shell.ShellCommandExecutor shexec;
        this.initializeTask(context);
        JvmManager.JvmEnv env = context.env;
        List<String> wrappedCommand = TaskLog.captureOutAndError(env.setup, env.vargs, env.stdout, env.stderr, env.logSize, true);
        context.shExec = shexec = new Shell.ShellCommandExecutor(wrappedCommand.toArray(new String[0]), env.workDir, env.env);
        shexec.execute();
    }

    @Override
    void initializeTask(TaskController.TaskControllerContext context) {
    }

    @Override
    void initializeJob(TaskController.JobInitializationContext context) {
    }

    @Override
    void terminateTask(TaskController.TaskControllerContext context) {
        Shell.ShellCommandExecutor shexec = context.shExec;
        if (shexec != null) {
            Process process = shexec.getProcess();
            if (Shell.WINDOWS) {
                if (process != null) {
                    process.destroy();
                }
            } else {
                String pid = context.pid;
                if (pid != null) {
                    if (ProcessTree.isSetsidAvailable) {
                        ProcessTree.terminateProcessGroup(pid);
                    } else {
                        ProcessTree.terminateProcess(pid);
                    }
                }
            }
        }
    }

    @Override
    void killTask(TaskController.TaskControllerContext context) {
        Shell.ShellCommandExecutor shexec = context.shExec;
        if (shexec != null) {
            if (Shell.WINDOWS) {
                return;
            }
            String pid = context.pid;
            if (pid != null) {
                if (ProcessTree.isSetsidAvailable) {
                    ProcessTree.killProcessGroup(pid);
                } else {
                    ProcessTree.killProcess(pid);
                }
            }
        }
    }

    @Override
    void enableTaskForCleanup(CleanupQueue.PathDeletionContext context) throws IOException {
        this.enablePathForCleanup(context);
    }

    @Override
    void enableJobForCleanup(CleanupQueue.PathDeletionContext context) throws IOException {
        this.enablePathForCleanup(context);
    }

    private void enablePathForCleanup(CleanupQueue.PathDeletionContext context) throws IOException {
        try {
            FileUtil.chmod(context.fullPath, "u+rwx", true);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Interrupted while setting permissions for " + context.fullPath + " for deletion."));
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Unable to change permissions of " + context.fullPath));
        }
    }

    @Override
    public void initializeDistributedCacheFile(TaskController.DistributedCacheFileContext context) throws IOException {
        Path localizedUniqueDir = context.getLocalizedUniqueDir();
        try {
            LOG.info((Object)("Doing chmod on localdir :" + localizedUniqueDir));
            FileUtil.chmod(localizedUniqueDir.toString(), "+x", true);
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Exception in doing chmod on" + localizedUniqueDir), (Throwable)ie);
            throw new IOException(ie);
        }
    }

    @Override
    public void initializeUser(TaskController.InitializationContext context) {
    }
}

