% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_HybridFinder_results.R
\name{export_HybridFinder_results}
\alias{export_HybridFinder_results}
\title{export_HybridFinder_results}
\usage{
export_HybridFinder_results(results_list, export_dir)
}
\arguments{
\item{results_list}{the results list obtained with the HybridFinder() function.}

\item{export_dir}{the export directory}
}
\value{
exports a folder containing three files
\enumerate{
           \item the HybridFinder output - the spectra that made it to the end
           with their respective columns (ALC, m/z, RT, Fraction, Scan) and a
           categorization column which denotes their potential splice type
           (-cis, -trans) or whether they are linear (the entire sequence was
           matched in proteins in the proteome database). Potential cis- &
           trans-spliced peptide are peptides whose fragments were matched with
           fragments within one protein, or two proteins, respectively.
           \item list of potential hybrid peptides (excluding the linear peptides)
           (.csv file)
           \item the merged proteome consisting of the reference proteome along
           with the hybrid proteome added at the end of the file with the sequence
           names following the pattern "sp|denovo_HF_fake_protein" along with
           a digit at the end (1,2,3,4,4,etc.) (.fasta file)}
}
\description{
this function allows to export the results list obtained in the
HybridFinder() function.
}
\details{
In order to be able to have the HybridFinder() results list exported,
this function will come in handy. Please note that this function is also part
of the HybridFinder() function, therefore if you set export_files=TRUE and you
indicate the export directory in export_dir in the HybridFinder() function,
you would have the exact same outcome.
}
\examples{
\dontrun{
 export_results(results_HybridFinder_Human_Liver_AUTD17,folder_Human_Liver_AUTD17)
}
}
\seealso{
\code{\link[seqinr]{write.fasta}}
}
