% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateResults.R
\name{readResultsAndComputeErrors}
\alias{readResultsAndComputeErrors}
\title{Function to read the result files and compute performance measures to create customized plots afterwards}
\usage{
readResultsAndComputeErrors(
  workingDir = getwd(),
  algoName = NULL,
  subset = "all",
  cutoffZ = 5,
  ...
)
}
\arguments{
\item{workingDir}{(character) specifying the working directory: Plots will be stored in workingDir/evalFolder and results will be used from workingDir/Results/algoName/biomarker;}

\item{algoName}{(character) vector specifying one algorithm for which the performance measures should be evaluated}

\item{subset}{(character, numeric, or data.frame) to specify for which subset the algorithm should be executed. 
character options:    'all' (default) for all test sets,
                    a distribution type: 'normal', 'skewed', 'heavilySkewed', 'shifted';
                    a biomarker: 'Hb', 'Ca', 'FT4', 'AST', 'LACT', 'GGT', 'TSH', 'IgE', 'CRP', 'LDH'; 
                    'runtime' for runtime analysis subset;                             
numeric option: number of test sets per biomarker, e.g. 10;
data.frame: customized subset of table with test set specifications}

\item{cutoffZ}{(integer) specifying if and if so which cutoff for the absolute z-score deviation should be used to 
classify results as implausible and exclude them from the overall benchmark score (default: 5)}

\item{...}{additional arguments to be passed to the method
truncNormal     (logical) specifying if a normal distribution truncated at zero shall be assumed}
}
\value{
(list) with (data frame) and a (list) with the computed performance measures
}
\description{
Function to read the result files and compute performance measures to create customized plots afterwards
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
