% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateData.R
\name{generateBiomarkerTestSets}
\alias{generateBiomarkerTestSets}
\title{Convenience function to generate simulated data and save each test set as a separate file}
\usage{
generateBiomarkerTestSets(
  workingDir = "",
  subset = "all",
  rounding = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{workingDir}{(character) specifying the working directory where 'workingDir/Data/biomarker' folders will be generated containing the simulated data}

\item{subset}{(character, numeric, or data.frame) to specify for which subset the data should be generated and the algorithms later applied to.
character options:    'all' (default) for all test sets;
                a distribution type: 'normal', 'skewed', 'heavilySkewed', 'shifted'; 
                a biomarker: 'Hb', 'Ca', 'FT4', 'AST', 'LACT', 'GGT', 'TSH', 'IgE', 'CRP', 'LDH'; 
                'Runtime' for runtime analysis subset;                     
numeric option: number of test sets per biomarker, e.g. 10;
data.frame: customized subset of table with test set specification}

\item{rounding}{(logical) indicating whether decimal places stated in test set specification should be applied (default, TRUE), 
if FALSE, data will be rounded to 5 decimal places to mimic unrounded data}

\item{verbose}{(logical) indicating if the progress counter should be shown (default: TRUE)}
}
\value{
No return value, instead the data files are generated and saved in the workingDir
}
\description{
Convenience function to generate simulated data and save each test set as a separate file
}
\examples{

\dontrun{
workingDir <- "C:\\\\Temp\\\\RIbench\\\\"
generateBiomarkerTestSets(workingDir = workingDir)
}

\donttest{
# example generating a subset of 2 test sets per biomarker 
generateBiomarkerTestSets(workingDir = tempdir(), subset =  2)
}


}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
