% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design.R
\name{HB08}
\alias{HB08}
\title{Adjusted & combined differences as in Hansen & Bowers (2008)}
\usage{
HB08(alignedcovs)
}
\arguments{
\item{alignedcovs}{A CovsAlignedToADesign object}
}
\value{
list with components:
\describe{
  \item{z}{First item}
  \item{p}{Second item}
  \item{Msq}{Squared Mahalanobis distance of combined differences from origin}
  \item{DF}{degrees of freedom}
  \item{adj.diff.of.totals}{Vector of sum statistics z't - E(Z't), where t represents cluster totals of the product of the covariate with unit weights.  Hansen & Bowers (2008) refer to this as the adjusted difference vector, or d(z,x). }
  \item{tcov}{Matrix of null covariances of Z'x-tilde vector, as above.}
}
}
\description{
Adjusted & combined differences as in Hansen & Bowers (2008)
}
\references{
Hansen, B.B. and Bowers, J. (2008), ``Covariate
  Balance in Simple, Stratified and Clustered Comparative
  Studies,'' \emph{Statistical Science} \bold{23}.
}
\seealso{
\code{\link{balanceTest}}, \code{\link{alignDesignsByStrata}}
}
\keyword{internal}
