/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.design.Algorithm;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.ForeFilter;
import ec.tstoolkit.maths.linearfilters.ISymmetricFilterDecomposer;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFrequencyResponse;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.maths.polynomials.UnitRootsSolver;

@Algorithm(entryPoint="decompose")
public class SymmetricFrequencyResponseDecomposer
implements ISymmetricFilterDecomposer {
    private double m_var;
    private BackFilter m_bf;
    private int m_freq;
    private double m_epsilon = 1.0E-4;
    private final double m_repsilon = 0.1;

    public SymmetricFrequencyResponseDecomposer() {
        this.m_freq = 12;
    }

    public SymmetricFrequencyResponseDecomposer(int freq) {
        this.m_freq = freq;
    }

    @Override
    public boolean decompose(SymmetricFilter sf) {
        Complex[] r;
        UnitRoots ur;
        UnitRoots sur;
        this.m_bf = null;
        if (sf.getWeight(0) <= 0.0) {
            return false;
        }
        SymmetricFrequencyResponse sfr = new SymmetricFrequencyResponse(sf);
        double var = sfr.getIntegral();
        if (var <= 0.0) {
            return false;
        }
        UnitRootsSolver urs = new UnitRootsSolver(this.m_freq);
        Polynomial p = Polynomial.copyOf(sf.getWeights());
        if (urs.factorize(p) && (sur = (ur = urs.getUnitRoots()).sqrt()) != null) {
            this.m_bf = new BackFilter(sur.toPolynomial());
            SymmetricFrequencyResponse sfrur = SymmetricFrequencyResponse.createFromFilter(this.m_bf);
            sfr = sfr.divide(sfrur);
        }
        if (this.m_bf == null) {
            this.m_bf = BackFilter.ONE;
        }
        if ((r = sfr.roots()) != null) {
            boolean[] used = new boolean[r.length];
            int nused = 0;
            for (int i = 0; i < r.length; ++i) {
                if (used[i]) continue;
                if (r[i].getIm() == 0.0) {
                    double x = r[i].getRe();
                    double ro = x * x - 1.0;
                    if (Math.abs(ro) < 1.0E-9) {
                        ro = 0.0;
                    }
                    if (ro >= 0.0) {
                        r[i] = x > 0.0 ? Complex.cart(x + Math.sqrt(ro)) : Complex.cart(x - Math.sqrt(ro));
                        used[i] = true;
                        ++nused;
                        continue;
                    }
                    int jbest = -1;
                    double del = -1.0;
                    for (int j = i + 1; j < r.length; ++j) {
                        if (used[j] || r[j].getIm() != 0.0) continue;
                        double dcur = Math.abs(r[j].getRe() - x);
                        if (!(del < 0.0) && !(dcur < del)) continue;
                        del = dcur;
                        jbest = j;
                    }
                    if (jbest > 0 && del < 0.1) {
                        used[i] = true;
                        used[jbest] = true;
                        double rr = x * r[jbest].getRe();
                        if (rr < 0.0) {
                            rr = 0.0;
                            x = 0.0;
                        } else {
                            x = x > 0.0 ? Math.sqrt(rr) : -Math.sqrt(rr);
                        }
                        ro = rr - 1.0;
                        ro = ro < 0.0 ? Math.sqrt(-ro) : 0.0;
                        r[i] = Complex.cart(x, ro);
                        r[jbest] = Complex.cart(x, -ro);
                        nused += 2;
                        continue;
                    }
                    this.m_bf = null;
                    return false;
                }
                Complex ro = r[i].times(r[i]).minus(1.0).sqrt();
                Complex c0 = r[i].plus(ro);
                Complex c1 = r[i].minus(ro);
                if (c1.absSquare() < c0.absSquare()) {
                    c1 = c0;
                }
                for (int j = i + 1; j < r.length; ++j) {
                    if (used[j] || !(r[i].conj().minus(r[j]).absSquare() < this.m_epsilon)) continue;
                    used[i] = true;
                    used[j] = true;
                    r[i] = c1;
                    r[j] = c1.conj();
                    nused += 2;
                    break;
                }
                if (used[i]) continue;
                this.m_bf = null;
                return false;
            }
            if (nused != r.length) {
                this.m_bf = null;
                return false;
            }
            Polynomial pr = Polynomial.fromComplexRoots(r);
            pr = pr.divide(pr.get(0));
            BackFilter bfr = new BackFilter(pr);
            this.m_bf = this.m_bf.times(bfr);
        }
        double s = 0.0;
        Polynomial coeff = this.m_bf.getPolynomial();
        for (int i = 0; i <= coeff.getDegree(); ++i) {
            s += coeff.get(i) * coeff.get(i);
        }
        this.m_var = var / s;
        return true;
    }

    @Override
    public BackFilter getBFilter() {
        return this.m_bf;
    }

    @Override
    public double getFactor() {
        return this.m_var;
    }

    @Override
    public ForeFilter getFFilter() {
        return this.m_bf.mirror();
    }

    public double getPrecision() {
        return this.m_epsilon;
    }

    public int getStartingURValue() {
        return this.m_freq;
    }

    public void setPrecision(double value) {
        this.m_epsilon = value;
    }

    public void setStartingURValue(int value) {
        this.m_freq = value;
    }
}

